/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.subtile.functional;

import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import vazkii.botania.api.lexicon.LexiconEntry;
import vazkii.botania.api.subtile.ISubTileContainer;
import vazkii.botania.api.subtile.RadiusDescriptor;
import vazkii.botania.api.subtile.SubTileFunctional;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.tile.TileFakeAir;
import vazkii.botania.common.lexicon.LexiconData;

public class SubTileBubbell
extends SubTileFunctional {
    private static final int RANGE = 12;
    private static final int RANGE_MINI = 6;
    private static final int COST_PER_TICK = 4;
    private static final String TAG_RANGE = "range";
    int range = 2;

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (this.supertile.func_145831_w().field_72995_K) {
            return;
        }
        if (this.ticksExisted % 200 == 0) {
            this.sync();
        }
        if (this.mana > 4) {
            this.mana -= 4;
            if (this.ticksExisted % 10 == 0 && this.range < this.getRange()) {
                ++this.range;
            }
            for (BlockPos pos : BlockPos.func_177975_b((BlockPos)this.getPos().func_177982_a(-this.range, -this.range, -this.range), (BlockPos)this.getPos().func_177982_a(this.range, this.range, this.range))) {
                IBlockState state;
                if (!(this.getPos().func_177951_i((Vec3i)pos) < (double)(this.range * this.range)) || (state = this.supertile.func_145831_w().func_180495_p(pos)).func_185904_a() != Material.field_151586_h) continue;
                this.supertile.func_145831_w().func_180501_a(pos, ModBlocks.fakeAir.func_176223_P(), 2);
                TileFakeAir air = (TileFakeAir)this.supertile.func_145831_w().func_175625_s(pos);
                air.setFlower(this.supertile);
            }
        }
    }

    public static boolean isValidBubbell(World world, BlockPos pos) {
        ISubTileContainer container;
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && tile instanceof ISubTileContainer && (container = (ISubTileContainer)tile).getSubTile() != null && container.getSubTile() instanceof SubTileBubbell) {
            SubTileBubbell bubbell = (SubTileBubbell)container.getSubTile();
            return bubbell.mana > 4;
        }
        return false;
    }

    @Override
    public void writeToPacketNBT(NBTTagCompound cmp) {
        super.writeToPacketNBT(cmp);
        cmp.func_74768_a(TAG_RANGE, this.range);
    }

    @Override
    public void readFromPacketNBT(NBTTagCompound cmp) {
        super.readFromPacketNBT(cmp);
        this.range = cmp.func_74762_e(TAG_RANGE);
    }

    @Override
    public int getMaxMana() {
        return 2000;
    }

    @Override
    public int getColor() {
        return 905097;
    }

    public int getRange() {
        return 12;
    }

    @Override
    public RadiusDescriptor getRadius() {
        return new RadiusDescriptor.Circle(this.toBlockPos(), this.range);
    }

    @Override
    public LexiconEntry getEntry() {
        return LexiconData.bubbell;
    }

    public static class Mini
    extends SubTileBubbell {
        @Override
        public int getRange() {
            return 6;
        }
    }
}

