/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.subtile.functional;

import com.google.common.base.Predicate;
import gnu.trove.list.array.TIntArrayList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.block.state.pattern.BlockStateMatcher;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import vazkii.botania.api.lexicon.LexiconEntry;
import vazkii.botania.api.state.BotaniaStateProps;
import vazkii.botania.api.state.enums.BiomeStoneVariant;
import vazkii.botania.api.subtile.RadiusDescriptor;
import vazkii.botania.api.subtile.SubTileFunctional;
import vazkii.botania.common.block.ModFluffBlocks;
import vazkii.botania.common.core.handler.ConfigHandler;
import vazkii.botania.common.lexicon.LexiconData;

public class SubTileMarimorphosis
extends SubTileFunctional {
    private static final int COST = 12;
    private static final int RANGE = 8;
    private static final int RANGE_Y = 5;
    private static final int RANGE_MINI = 2;
    private static final int RANGE_Y_MINI = 1;
    private static final BiomeDictionary.Type[] TYPES = new BiomeDictionary.Type[]{BiomeDictionary.Type.FOREST, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.MUSHROOM, BiomeDictionary.Type.SWAMP, BiomeDictionary.Type.SANDY, BiomeDictionary.Type.COLD, BiomeDictionary.Type.MESA};

    @Override
    public void onUpdate() {
        IBlockState state;
        BlockPos coords;
        super.onUpdate();
        if (this.supertile.func_145831_w().field_72995_K || this.redstoneSignal > 0) {
            return;
        }
        if (this.mana >= 12 && this.ticksExisted % 2 == 0 && (coords = this.getCoordsToPut()) != null && (state = this.getStoneToPut(coords)) != null) {
            this.supertile.func_145831_w().func_175656_a(coords, state);
            if (ConfigHandler.blockBreakParticles) {
                this.supertile.func_145831_w().func_175718_b(2001, coords, Block.func_176210_f((IBlockState)state));
            }
            this.mana -= 12;
            this.sync();
        }
    }

    public IBlockState getStoneToPut(BlockPos coords) {
        List<BiomeDictionary.Type> types = Arrays.asList(BiomeDictionary.getTypesForBiome((Biome)this.supertile.func_145831_w().func_180494_b(coords)));
        TIntArrayList values = new TIntArrayList();
        for (int i = 0; i < TYPES.length; ++i) {
            int times = 1;
            if (types.contains(TYPES[i])) {
                times = 12;
            }
            for (int j = 0; j < times; ++j) {
                values.add(i);
            }
        }
        BiomeStoneVariant variant = BiomeStoneVariant.values()[this.supertile.func_145831_w().field_73012_v.nextInt(values.size())];
        return ModFluffBlocks.biomeStoneA.func_176223_P().func_177226_a(BotaniaStateProps.BIOMESTONE_VARIANT, (Comparable)((Object)variant));
    }

    private BlockPos getCoordsToPut() {
        ArrayList<BlockPos> possibleCoords = new ArrayList<BlockPos>();
        int range = this.getRange();
        int rangeY = this.getRangeY();
        BlockStateMatcher matcher = BlockStateMatcher.func_177638_a((Block)Blocks.field_150348_b);
        for (BlockPos pos : BlockPos.func_177980_a((BlockPos)this.getPos().func_177982_a(-range, -rangeY, -range), (BlockPos)this.getPos().func_177982_a(range, rangeY, range))) {
            IBlockState state = this.supertile.func_145831_w().func_180495_p(pos);
            if (!state.func_177230_c().isReplaceableOreGen(state, (IBlockAccess)this.supertile.func_145831_w(), pos, (Predicate)matcher)) continue;
            possibleCoords.add(pos);
        }
        if (possibleCoords.isEmpty()) {
            return null;
        }
        return (BlockPos)possibleCoords.get(this.supertile.func_145831_w().field_73012_v.nextInt(possibleCoords.size()));
    }

    @Override
    public RadiusDescriptor getRadius() {
        return new RadiusDescriptor.Square(this.toBlockPos(), this.getRange());
    }

    public int getRange() {
        return 8;
    }

    public int getRangeY() {
        return 5;
    }

    @Override
    public int getColor() {
        return 7772311;
    }

    @Override
    public boolean acceptsRedstone() {
        return true;
    }

    @Override
    public int getMaxMana() {
        return 1000;
    }

    @Override
    public LexiconEntry getEntry() {
        return LexiconData.marimorphosis;
    }

    public static class Mini
    extends SubTileMarimorphosis {
        @Override
        public int getRange() {
            return 2;
        }

        @Override
        public int getRangeY() {
            return 1;
        }
    }
}

