/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.tile;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.common.block.tile.TileMod;

public class TileAnimatedTorch
extends TileMod {
    public static final String TAG_SIDE = "side";
    public static final String TAG_ROTATING = "rotating";
    public static final String TAG_ROTATION_TICKS = "rotationTicks";
    public static final String TAG_ANGLE_PER_TICK = "anglePerTick";
    public static final String TAG_TORCH_MODE = "torchMode";
    public static final String TAG_NEXT_RANDOM_ROTATION = "nextRandomRotation";
    public static final EnumFacing[] SIDES = new EnumFacing[]{EnumFacing.NORTH, EnumFacing.EAST, EnumFacing.SOUTH, EnumFacing.WEST};
    public int side;
    public double rotation;
    public boolean rotating;
    public double lastTickRotation;
    public int nextRandomRotation;
    public int currentRandomRotation;
    private int rotationTicks;
    public double anglePerTick;
    private TorchMode torchMode = TorchMode.TOGGLE;

    public void onLoad() {
        if (!this.field_145850_b.field_72995_K) {
            this.nextRandomRotation = this.field_145850_b.field_73012_v.nextInt(4);
        }
    }

    public void handRotate() {
        this.rotateTo((this.side + 1) % 4);
    }

    public void toggle() {
        this.rotateTo(this.torchMode.modeSwitcher.rotate(this, this.side));
        if (!this.field_145850_b.field_72995_K) {
            this.nextRandomRotation = this.field_145850_b.field_73012_v.nextInt(4);
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
        }
    }

    public void onWanded() {
        int modeOrdinal = this.torchMode.ordinal();
        TorchMode[] modes = (TorchMode[])TorchMode.class.getEnumConstants();
        if (++modeOrdinal >= modes.length) {
            modeOrdinal = 0;
        }
        this.torchMode = modes[modeOrdinal];
    }

    public void rotateTo(int side) {
        if (this.rotating) {
            return;
        }
        this.currentRandomRotation = this.nextRandomRotation;
        int finalRotation = side * 90;
        double diff = ((double)finalRotation - this.rotation % 360.0) % 360.0;
        if (diff < 0.0) {
            diff = 360.0 + diff;
        }
        this.rotationTicks = 4;
        this.anglePerTick = diff / (double)this.rotationTicks;
        this.side = side;
        this.rotating = true;
        this.field_145850_b.func_175685_c(this.func_174877_v(), this.func_145838_q());
    }

    @SideOnly(value=Side.CLIENT)
    public void renderHUD(Minecraft mc, ScaledResolution res) {
        int x = res.func_78326_a() / 2 + 10;
        int y = res.func_78328_b() / 2 - 8;
        mc.func_175599_af().func_180450_b(new ItemStack(Blocks.field_150429_aA), x, y);
        mc.field_71466_p.func_175063_a(I18n.func_74838_a((String)("botania.animatedTorch." + this.torchMode.name().toLowerCase())), (float)(x + 18), (float)(y + 6), 0xFF4444);
    }

    @Override
    public void func_73660_a() {
        if (this.rotating) {
            this.lastTickRotation = this.rotation;
            this.rotation = (this.rotation + this.anglePerTick) % 360.0;
            --this.rotationTicks;
            if (this.rotationTicks <= 0) {
                this.rotating = false;
                this.field_145850_b.func_175685_c(this.func_174877_v(), this.func_145838_q());
            }
        } else {
            this.rotation = this.side * 90;
        }
        int amt = this.rotating ? 3 : (Math.random() < 0.1 ? 1 : 0);
        double x = (double)this.func_174877_v().func_177958_n() + 0.5 + Math.cos((this.rotation + 90.0) / 180.0 * Math.PI) * 0.35;
        double y = (double)this.func_174877_v().func_177956_o() + 0.2;
        double z = (double)this.func_174877_v().func_177952_p() + 0.5 + Math.sin((this.rotation + 90.0) / 180.0 * Math.PI) * 0.35;
        for (int i = 0; i < amt; ++i) {
            this.field_145850_b.func_175688_a(EnumParticleTypes.REDSTONE, x, y, z, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    @Override
    public void writePacketNBT(NBTTagCompound cmp) {
        cmp.func_74768_a(TAG_SIDE, this.side);
        cmp.func_74757_a(TAG_ROTATING, this.rotating);
        cmp.func_74768_a(TAG_ROTATION_TICKS, this.rotationTicks);
        cmp.func_74780_a(TAG_ANGLE_PER_TICK, this.anglePerTick);
        cmp.func_74768_a(TAG_TORCH_MODE, this.torchMode.ordinal());
        cmp.func_74768_a(TAG_NEXT_RANDOM_ROTATION, this.nextRandomRotation);
    }

    @Override
    public void readPacketNBT(NBTTagCompound cmp) {
        this.side = cmp.func_74762_e(TAG_SIDE);
        this.rotating = cmp.func_74767_n(TAG_ROTATING);
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            this.rotationTicks = cmp.func_74762_e(TAG_ROTATION_TICKS);
        }
        this.anglePerTick = cmp.func_74769_h(TAG_ANGLE_PER_TICK);
        this.nextRandomRotation = cmp.func_74762_e(TAG_NEXT_RANDOM_ROTATION);
        int modeOrdinal = cmp.func_74762_e(TAG_TORCH_MODE);
        TorchMode[] modes = (TorchMode[])TorchMode.class.getEnumConstants();
        this.torchMode = modes[Math.max(0, Math.min(modes.length - 1, modeOrdinal))];
    }

    public static enum TorchMode {
        TOGGLE((t, i) -> (i + 2) % 4),
        ROTATE((t, i) -> (i + 1) % 4),
        RANDOM((t, i) -> t.currentRandomRotation);

        public final RotationHandler modeSwitcher;

        private TorchMode(RotationHandler modeSwitcher) {
            this.modeSwitcher = modeSwitcher;
        }

        private static interface RotationHandler {
            public int rotate(TileAnimatedTorch var1, int var2);
        }
    }
}

