/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.equipment.bauble;

import baubles.api.BaubleType;
import baubles.api.BaublesApi;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.common.core.helper.ItemNBTHelper;
import vazkii.botania.common.core.helper.Vector3;
import vazkii.botania.common.item.equipment.bauble.ItemBauble;
import vazkii.botania.common.network.PacketDodge;
import vazkii.botania.common.network.PacketHandler;

public class ItemDodgeRing
extends ItemBauble {
    public static final String TAG_DODGE_COOLDOWN = "dodgeCooldown";
    public static final int MAX_CD = 20;
    int leftDown;
    int rightDown;

    public ItemDodgeRing() {
        super("dodgeRing");
        if (FMLCommonHandler.instance().getSide().isClient()) {
            MinecraftForge.EVENT_BUS.register((Object)this);
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onKeyDown(InputEvent.KeyInputEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        IInventory baublesInv = BaublesApi.getBaubles((EntityPlayer)mc.field_71439_g);
        ItemStack ringStack = baublesInv.func_70301_a(1);
        if (!(ringStack != null && ringStack.func_77973_b() instanceof ItemDodgeRing || (ringStack = baublesInv.func_70301_a(2)) != null && ringStack.func_77973_b() instanceof ItemDodgeRing)) {
            return;
        }
        if (ItemNBTHelper.getInt(ringStack, TAG_DODGE_COOLDOWN, 0) > 0) {
            return;
        }
        int threshold = 4;
        if (mc.field_71474_y.field_74370_x.func_151470_d()) {
            int oldLeft = this.leftDown;
            this.leftDown = ClientTickHandler.ticksInGame;
            if (this.leftDown - oldLeft < threshold) {
                this.dodge((EntityPlayer)mc.field_71439_g, true);
            }
        } else if (mc.field_71474_y.field_74366_z.func_151470_d()) {
            int oldRight = this.rightDown;
            this.rightDown = ClientTickHandler.ticksInGame;
            if (this.rightDown - oldRight < threshold) {
                this.dodge((EntityPlayer)mc.field_71439_g, false);
            }
        }
    }

    @Override
    public void onWornTick(ItemStack stack, EntityLivingBase player) {
        int cd = ItemNBTHelper.getInt(stack, TAG_DODGE_COOLDOWN, 0);
        if (cd > 0) {
            ItemNBTHelper.setInt(stack, TAG_DODGE_COOLDOWN, cd - 1);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void dodge(EntityPlayer player, boolean left) {
        if (player.field_71075_bZ.field_75100_b || !player.field_70122_E || (double)player.field_70701_bs > 0.2 || (double)player.field_70701_bs < -0.2) {
            return;
        }
        float yaw = player.field_70177_z;
        float x = MathHelper.func_76126_a((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float z = MathHelper.func_76134_b((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        Vector3 lookVec = new Vector3(x, 0.0, z);
        Vector3 sideVec = lookVec.crossProduct(new Vector3(0.0, left ? 1.0 : -1.0, 0.0)).multiply(1.25);
        player.field_70159_w = sideVec.x;
        player.field_70181_x = sideVec.y;
        player.field_70179_y = sideVec.z;
        PacketHandler.sendToServer(new PacketDodge());
    }

    @SideOnly(value=Side.CLIENT)
    public static void renderHUD(ScaledResolution resolution, EntityPlayer player, ItemStack stack, float pticks) {
        Math.max(1, stack.func_77952_i());
        Minecraft.func_71410_x();
        int xo = resolution.func_78326_a() / 2 - 20;
        int y = resolution.func_78328_b() / 2 + 20;
        if (!player.field_71075_bZ.field_75100_b) {
            int cd = ItemNBTHelper.getInt(stack, TAG_DODGE_COOLDOWN, 0);
            int width = Math.min((int)(((float)cd - pticks) * 2.0f), 40);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (width > 0) {
                Gui.func_73734_a((int)xo, (int)(y - 2), (int)(xo + 40), (int)(y - 1), (int)-2013265920);
                Gui.func_73734_a((int)xo, (int)(y - 2), (int)(xo + width), (int)(y - 1), (int)-1);
            }
        }
        GlStateManager.func_179141_d();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public BaubleType getBaubleType(ItemStack arg0) {
        return BaubleType.RING;
    }
}

