/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.rod;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import vazkii.botania.api.item.IAvatarTile;
import vazkii.botania.api.item.IAvatarWieldable;
import vazkii.botania.api.item.IManaProficiencyArmor;
import vazkii.botania.api.mana.IManaUsingItem;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.api.sound.BotaniaSoundEvents;
import vazkii.botania.api.state.BotaniaStateProps;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.tile.TileBifrost;
import vazkii.botania.common.core.helper.Vector3;
import vazkii.botania.common.item.ItemMod;

public class ItemRainbowRod
extends ItemMod
implements IManaUsingItem,
IAvatarWieldable {
    private static final ResourceLocation avatarOverlay = new ResourceLocation("botania:textures/model/avatarRainbow.png");
    private static final int MANA_COST = 750;
    private static final int MANA_COST_AVATAR = 10;
    private static final int TIME = 600;

    public ItemRainbowRod() {
        super("rainbowRod");
        this.func_77625_d(1);
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(@Nonnull ItemStack par1ItemStack, World world, EntityPlayer player, EnumHand hand) {
        if (!world.field_72995_K && ManaItemHandler.requestManaExactForTool(par1ItemStack, player, 750, false)) {
            Block place = ModBlocks.bifrost;
            Vector3 vector = new Vector3(player.func_70040_Z()).normalize();
            double x = player.field_70165_t;
            double y = player.field_70163_u;
            double z = player.field_70161_v;
            BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos((int)x, (int)y, (int)z);
            double lastX = 0.0;
            double lastY = -1.0;
            double lastZ = 0.0;
            BlockPos.MutableBlockPos lastChecker = new BlockPos.MutableBlockPos();
            int count = 0;
            boolean prof = IManaProficiencyArmor.Helper.hasProficiency(player, par1ItemStack);
            int maxlen = prof ? 160 : 100;
            int time = prof ? 960 : 600;
            BlockPos.MutableBlockPos placePos = new BlockPos.MutableBlockPos();
            while (count < maxlen) {
                lastChecker.func_189532_c(lastX, lastY, lastZ);
                if (!lastChecker.equals((Object)pos)) {
                    if (y >= (double)world.func_72800_K() || y <= 0.0 || !world.func_175623_d((BlockPos)pos) && world.func_180495_p((BlockPos)pos).func_177230_c() != place) break;
                    for (int i = -2; i < 1; ++i) {
                        for (int j = -2; j < 1; ++j) {
                            placePos.func_181079_c(pos.func_177958_n() + i, pos.func_177956_o(), pos.func_177952_p() + j);
                            if (!world.func_175623_d((BlockPos)placePos) && world.func_180495_p((BlockPos)placePos).func_177230_c() != place) continue;
                            world.func_175656_a((BlockPos)placePos, place.func_176223_P());
                            TileBifrost tile = (TileBifrost)world.func_175625_s((BlockPos)placePos);
                            if (tile == null) continue;
                            tile.ticks = time;
                        }
                    }
                    ++count;
                }
                lastX = x;
                lastY = y;
                lastZ = z;
                pos.func_189532_c(x += vector.x, y += vector.y, z += vector.z);
            }
            if (count > 0) {
                world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, BotaniaSoundEvents.bifrostRod, SoundCategory.PLAYERS, 0.5f, 0.25f);
                ManaItemHandler.requestManaExactForTool(par1ItemStack, player, 750, false);
                player.func_184811_cZ().func_185145_a((Item)this, 600);
            }
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)par1ItemStack);
    }

    @Nonnull
    public ItemStack getContainerItem(@Nonnull ItemStack itemStack) {
        return itemStack.func_77946_l();
    }

    public boolean hasContainerItem(ItemStack stack) {
        return this.getContainerItem(stack) != null;
    }

    public void func_77663_a(ItemStack par1ItemStack, World world, Entity par3Entity, int par4, boolean par5) {
        if (par1ItemStack.func_77952_i() > 0) {
            par1ItemStack.func_77964_b(0);
        }
    }

    @Override
    public boolean usesMana(ItemStack stack) {
        return true;
    }

    @Override
    public void onAvatarUpdate(IAvatarTile tile, ItemStack stack) {
        TileEntity te = (TileEntity)tile;
        World world = te.func_145831_w();
        if (world.field_72995_K || tile.getCurrentMana() < 250 || !tile.isEnabled()) {
            return;
        }
        BlockPos tePos = te.func_174877_v();
        int w = 1;
        int h = 1;
        int l = 20;
        AxisAlignedBB axis = null;
        switch ((EnumFacing)world.func_180495_p(tePos).func_177229_b(BotaniaStateProps.CARDINALS)) {
            case NORTH: {
                axis = new AxisAlignedBB(tePos.func_177982_a(-w, -h, -l), tePos.func_177982_a(w + 1, h, 0));
                break;
            }
            case SOUTH: {
                axis = new AxisAlignedBB(tePos.func_177982_a(-w, -h, 1), tePos.func_177982_a(w + 1, h, l + 1));
                break;
            }
            case WEST: {
                axis = new AxisAlignedBB(tePos.func_177982_a(-l, -h, -w), tePos.func_177982_a(0, h, w + 1));
                break;
            }
            case EAST: {
                axis = new AxisAlignedBB(tePos.func_177982_a(1, -h, -w), tePos.func_177982_a(l + 1, h, w + 1));
            }
        }
        List players = world.func_72872_a(EntityPlayer.class, axis);
        for (EntityPlayer p : players) {
            int px = MathHelper.func_76128_c((double)p.field_70165_t);
            int py = MathHelper.func_76128_c((double)p.field_70163_u) - 1;
            int pz = MathHelper.func_76128_c((double)p.field_70161_v);
            int dist = 5;
            int diff = dist / 2;
            for (int i = 0; i < dist; ++i) {
                for (int j = 0; j < dist; ++j) {
                    TileBifrost tileBifrost;
                    int ex = px + i - diff;
                    int ez = pz + j - diff;
                    if (!axis.func_72318_a(new Vec3d((double)ex + 0.5, (double)(py + 1), (double)ez + 0.5))) continue;
                    BlockPos pos = new BlockPos(ex, py, ez);
                    Block block = world.func_180495_p(pos).func_177230_c();
                    if (block.isAir(world.func_180495_p(pos), (IBlockAccess)world, pos)) {
                        world.func_175656_a(pos, ModBlocks.bifrost.func_176223_P());
                        tileBifrost = (TileBifrost)world.func_175625_s(pos);
                        tileBifrost.ticks = 10;
                        tile.recieveMana(-10);
                        continue;
                    }
                    if (block != ModBlocks.bifrost) continue;
                    tileBifrost = (TileBifrost)world.func_175625_s(pos);
                    if (tileBifrost.ticks >= 2) continue;
                    tileBifrost.ticks = 10;
                    tile.recieveMana(-10);
                }
            }
        }
    }

    @Override
    public ResourceLocation getOverlayResource(IAvatarTile tile, ItemStack stack) {
        return avatarOverlay;
    }
}

