/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.everlastingabilities;

import org.apache.logging.log4j.Level;
import org.cyclops.cyclopscore.config.ConfigurableProperty;
import org.cyclops.cyclopscore.config.ConfigurableType;
import org.cyclops.cyclopscore.config.ConfigurableTypeCategory;
import org.cyclops.cyclopscore.config.extendedconfig.DummyConfig;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.cyclopscore.tracking.Analytics;
import org.cyclops.cyclopscore.tracking.IModVersion;
import org.cyclops.cyclopscore.tracking.Versions;
import org.cyclops.everlastingabilities.EverlastingAbilities;

public class GeneralConfig
extends DummyConfig {
    @ConfigurableProperty(category=ConfigurableTypeCategory.CORE, comment="Config version for EverlastingAbilities.\nDO NOT EDIT MANUALLY!", showInGui=false)
    public static String version = "1.2.5";
    @ConfigurableProperty(category=ConfigurableTypeCategory.CORE, comment="Set 'true' to enable development debug mode. This will result in a lower performance!", requiresMcRestart=true)
    public static boolean debug = false;
    @ConfigurableProperty(category=ConfigurableTypeCategory.CORE, comment="If the recipe loader should crash when finding invalid recipes.", requiresMcRestart=true)
    public static boolean crashOnInvalidRecipe = false;
    @ConfigurableProperty(category=ConfigurableTypeCategory.CORE, comment="If mod compatibility loader should crash hard if errors occur in that process.", requiresMcRestart=true)
    public static boolean crashOnModCompatCrash = false;
    @ConfigurableProperty(category=ConfigurableTypeCategory.CORE, comment="If an anonymous mod startup analytics request may be sent to our analytics service.")
    public static boolean analytics = true;
    @ConfigurableProperty(category=ConfigurableTypeCategory.CORE, comment="If the version checker should be enabled.")
    public static boolean versionChecker = true;
    @ConfigurableProperty(category=ConfigurableTypeCategory.GENERAL, comment="The maximum rarity of totems to spawn when a player first logs in. [0-3], -1 disables totem spawning.")
    public static int totemMaximumSpawnRarity = 1;
    @ConfigurableProperty(category=ConfigurableTypeCategory.GENERAL, comment="How many abilities should be dropped on player death.", isCommandable=true)
    public static int dropAbilitiesOnPlayerDeath = 1;
    @ConfigurableProperty(category=ConfigurableTypeCategory.GENERAL, comment="true: Abilities drop when players die; false: Abilities drop when players die by the hand of other players.", isCommandable=true)
    public static boolean alwaysDropAbilities = false;
    @ConfigurableProperty(category=ConfigurableTypeCategory.GENERAL, comment="1/x chance for mobs to have abilities.", isCommandable=true)
    public static int mobAbilityChance = 50;
    @ConfigurableProperty(category=ConfigurableTypeCategory.GENERAL, comment="If the magnetize ability should move xp.", isCommandable=true)
    public static boolean magnetizeMoveXp = true;
    @ConfigurableProperty(category=ConfigurableTypeCategory.GENERAL, comment="The multiplier for ability XP requirement", isCommandable=true)
    public static int abilityXpMultiplier = 10;
    @ConfigurableProperty(category=ConfigurableTypeCategory.GENERAL, comment="If players should have particle effects for the abilities they carry.", isCommandable=true)
    public static boolean showPlayerParticles = false;
    @ConfigurableProperty(category=ConfigurableTypeCategory.GENERAL, comment="The maximum amount of abilities a player can have, -1 is infinite.", isCommandable=true)
    public static int maxPlayerAbilities = -1;
    @ConfigurableProperty(category=ConfigurableTypeCategory.GENERAL, comment="The amount of exhaustion that should by applied to the player per active ability per second.", isCommandable=true)
    public static double exhaustionPerAbilityTick = 0.01;
    public static ConfigurableType TYPE = ConfigurableType.DUMMY;

    public GeneralConfig() {
        super((ModBase)EverlastingAbilities._instance, true, "general", null, GeneralConfig.class);
    }

    public void onRegistered() {
        if (!version.equals("1.2.5")) {
            this.getMod().log(Level.WARN, "The config file of EverlastingAbilities is out of date and might cause problems, please remove it so it can be regenerated.");
        }
        this.getMod().putGenericReference(ModBase.REFKEY_CRASH_ON_INVALID_RECIPE, (Object)crashOnInvalidRecipe);
        this.getMod().putGenericReference(ModBase.REFKEY_DEBUGCONFIG, (Object)debug);
        this.getMod().putGenericReference(ModBase.REFKEY_CRASH_ON_MODCOMPAT_CRASH, (Object)crashOnModCompatCrash);
        if (analytics) {
            Analytics.registerMod((ModBase)this.getMod(), (String)"UA-65307010-9");
        }
        if (versionChecker) {
            Versions.registerMod((ModBase)this.getMod(), (IModVersion)EverlastingAbilities._instance, (String)"https://raw.githubusercontent.com/CyclopsMC/Versions/master/1.9/EverlastingAbilities.txt");
        }
    }

    public boolean isEnabled() {
        return true;
    }
}

