/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.everlastingabilities.ability;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityOwnable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EntitySelectors;
import net.minecraft.world.World;
import org.apache.logging.log4j.Level;
import org.cyclops.everlastingabilities.EverlastingAbilities;
import org.cyclops.everlastingabilities.ability.AbilityTypeDefault;

public class AbilityTypePotionEffectRadius
extends AbilityTypeDefault {
    private static final int TICK_MODULUS = 10;
    private final Potion potion;

    public AbilityTypePotionEffectRadius(String id, int rarity, int maxLevel, int baseXpPerLevel, Potion potion) {
        super(id, rarity, maxLevel, baseXpPerLevel);
        this.potion = potion;
        if (this.potion == null) {
            EverlastingAbilities.clog(Level.WARN, "Tried to register a null potion for ability " + id + ". This is possibly caused by a mod forcefully removing the potion effect for this ability.");
        }
    }

    protected int getDurationMultiplier() {
        return 6;
    }

    @Override
    public void onTick(EntityPlayer player, int level) {
        World world = player.field_70170_p;
        if (this.potion != null && !world.field_72995_K && player.field_70170_p.func_72820_D() % 10L == 0L) {
            int radius = level * 2;
            List mobs = world.func_175647_a(EntityLivingBase.class, player.func_174813_aQ().func_186662_g((double)radius), EntitySelectors.field_180132_d);
            for (EntityLivingBase mob : mobs) {
                if (mob == player || mob instanceof IEntityOwnable && ((IEntityOwnable)mob).func_70902_q() == player || player.func_184191_r((Entity)mob)) continue;
                mob.func_70690_d(new PotionEffect(this.potion, 10 * this.getDurationMultiplier(), level - 1, true, false));
            }
        }
    }
}

