/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.everlastingabilities.api.capability;

import org.cyclops.everlastingabilities.api.Ability;
import org.cyclops.everlastingabilities.api.IAbilityType;
import org.cyclops.everlastingabilities.api.capability.DefaultAbilityStore;
import org.cyclops.everlastingabilities.api.capability.IMutableAbilityStore;

public class DefaultMutableAbilityStore
extends DefaultAbilityStore
implements IMutableAbilityStore {
    public DefaultMutableAbilityStore() {
    }

    public DefaultMutableAbilityStore(DefaultAbilityStore abilityStore) {
        this.setAbilities(abilityStore.abilityTypes);
    }

    @Override
    public Ability addAbility(Ability ability, boolean doAdd) {
        Ability addedAbility;
        IAbilityType abilityType = ability.getAbilityType();
        int currentLevel = this.abilityTypes.containsKey(abilityType) ? (Integer)this.abilityTypes.get(abilityType) : 0;
        int maxLevel = abilityType.getMaxLevel();
        int toAddLevel = ability.getLevel();
        int finalLevel = Math.min(currentLevel + toAddLevel, maxLevel);
        int addedLevel = finalLevel - currentLevel;
        Ability newAbility = new Ability(abilityType, finalLevel);
        Ability ability2 = addedAbility = addedLevel == 0 ? null : new Ability(abilityType, addedLevel);
        if (doAdd) {
            if (newAbility.getLevel() == 0) {
                this.abilityTypes.remove(newAbility.getAbilityType());
            } else {
                this.abilityTypes.put(newAbility.getAbilityType(), newAbility.getLevel());
            }
        }
        return addedAbility;
    }

    @Override
    public Ability removeAbility(Ability ability, boolean doRemove) {
        Ability removedAbility;
        IAbilityType abilityType = ability.getAbilityType();
        int currentLevel = this.abilityTypes.containsKey(abilityType) ? (Integer)this.abilityTypes.get(abilityType) : 0;
        int toRemoveLevel = ability.getLevel();
        int finalLevel = Math.max(currentLevel - toRemoveLevel, 0);
        int removedLevel = currentLevel - finalLevel;
        Ability newAbility = new Ability(abilityType, finalLevel);
        Ability ability2 = removedAbility = removedLevel == 0 ? null : new Ability(abilityType, removedLevel);
        if (doRemove) {
            if (newAbility.getLevel() == 0) {
                this.abilityTypes.remove(newAbility.getAbilityType());
            } else {
                this.abilityTypes.put(newAbility.getAbilityType(), newAbility.getLevel());
            }
        }
        return removedAbility;
    }
}

