/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.everlastingabilities.client.gui;

import com.google.common.collect.Lists;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import org.apache.commons.lang3.tuple.Triple;
import org.cyclops.cyclopscore.client.gui.component.button.GuiButtonArrow;
import org.cyclops.cyclopscore.client.gui.container.GuiContainerConfigurable;
import org.cyclops.cyclopscore.client.gui.container.GuiContainerExtended;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.helper.RenderHelpers;
import org.cyclops.cyclopscore.helper.StringHelpers;
import org.cyclops.cyclopscore.inventory.container.ExtendedInventoryContainer;
import org.cyclops.cyclopscore.inventory.container.InventoryContainerConfigurable;
import org.cyclops.cyclopscore.inventory.container.button.IButtonActionClient;
import org.cyclops.cyclopscore.item.IInformationProvider;
import org.cyclops.cyclopscore.network.PacketBase;
import org.cyclops.everlastingabilities.EverlastingAbilities;
import org.cyclops.everlastingabilities.ability.AbilityHelpers;
import org.cyclops.everlastingabilities.api.Ability;
import org.cyclops.everlastingabilities.api.capability.IAbilityStore;
import org.cyclops.everlastingabilities.api.capability.IMutableAbilityStore;
import org.cyclops.everlastingabilities.inventory.container.ContainerAbilityContainer;
import org.cyclops.everlastingabilities.item.ItemGuiAbilityContainer;
import org.cyclops.everlastingabilities.network.packet.MoveAbilityPacket;

public class GuiAbilityContainer
extends GuiContainerConfigurable<ContainerAbilityContainer> {
    private static final ResourceLocation RES_ITEM_GLINT = new ResourceLocation("textures/misc/enchanted_item_glint.png");
    protected static final int ABILITY_LIST_SIZE = 6;
    protected static final int ABILITY_BOX_HEIGHT = 18;
    protected static final int ABILITY_BOX_WIDTH = 63;
    private static final int BUTTON_UP_1 = 0;
    private static final int BUTTON_DOWN_1 = 1;
    private static final int BUTTON_UP_2 = 2;
    private static final int BUTTON_DOWN_2 = 3;
    private static final int BUTTON_LEFT = 4;
    private static final int BUTTON_RIGHT = 5;
    private final EntityPlayer player;
    protected int startIndexPlayer = 0;
    protected int startIndexItem = 0;
    protected int absoluteSelectedIndexPlayer = -1;
    protected int absoluteSelectedIndexItem = -1;
    protected GuiButtonArrow buttonUp1;
    protected GuiButtonArrow buttonDown1;
    protected GuiButtonArrow buttonUp2;
    protected GuiButtonArrow buttonDown2;
    protected GuiButtonArrow buttonLeft;
    protected GuiButtonArrow buttonRight;

    public GuiAbilityContainer(EntityPlayer player, int itemIndex) {
        super((InventoryContainerConfigurable)new ContainerAbilityContainer(player, itemIndex));
        this.player = player;
        ContainerAbilityContainer container = (ContainerAbilityContainer)this.getContainer();
        container.setGui(this);
        this.putButtonAction(0, (IButtonActionClient)new IButtonActionClient<GuiContainerExtended, ExtendedInventoryContainer>(){

            public void onAction(int buttonId, GuiContainerExtended gui, ExtendedInventoryContainer container) {
                if (GuiAbilityContainer.this.startIndexPlayer > 0) {
                    --GuiAbilityContainer.this.startIndexPlayer;
                }
            }
        });
        this.putButtonAction(1, (IButtonActionClient)new IButtonActionClient<GuiContainerExtended, ExtendedInventoryContainer>(){

            public void onAction(int buttonId, GuiContainerExtended gui, ExtendedInventoryContainer container) {
                if (GuiAbilityContainer.this.startIndexPlayer + 6 < Math.max(6, GuiAbilityContainer.this.getPlayerAbilitiesCount())) {
                    ++GuiAbilityContainer.this.startIndexPlayer;
                }
            }
        });
        this.putButtonAction(2, (IButtonActionClient)new IButtonActionClient<GuiContainerExtended, ExtendedInventoryContainer>(){

            public void onAction(int buttonId, GuiContainerExtended gui, ExtendedInventoryContainer container) {
                if (GuiAbilityContainer.this.startIndexItem > 0) {
                    --GuiAbilityContainer.this.startIndexItem;
                }
            }
        });
        this.putButtonAction(3, (IButtonActionClient)new IButtonActionClient<GuiContainerExtended, ExtendedInventoryContainer>(){

            public void onAction(int buttonId, GuiContainerExtended gui, ExtendedInventoryContainer container) {
                if (GuiAbilityContainer.this.startIndexItem + 6 < Math.max(6, GuiAbilityContainer.this.getItemAbilitiesCount())) {
                    ++GuiAbilityContainer.this.startIndexItem;
                }
            }
        });
        this.putButtonAction(4, (IButtonActionClient)new IButtonActionClient<GuiContainerExtended, ExtendedInventoryContainer>(){

            public void onAction(int buttonId, GuiContainerExtended gui, ExtendedInventoryContainer container) {
                if (GuiAbilityContainer.this.canMoveToPlayer()) {
                    EverlastingAbilities._instance.getPacketHandler().sendToServer((PacketBase)new MoveAbilityPacket(GuiAbilityContainer.this.getSelectedItemAbilitySingle(), MoveAbilityPacket.Movement.TO_PLAYER));
                    GuiAbilityContainer.this.moveToPlayer();
                }
            }
        });
        this.putButtonAction(5, (IButtonActionClient)new IButtonActionClient<GuiContainerExtended, ExtendedInventoryContainer>(){

            public void onAction(int buttonId, GuiContainerExtended gui, ExtendedInventoryContainer container) {
                if (GuiAbilityContainer.this.canMoveFromPlayer()) {
                    EverlastingAbilities._instance.getPacketHandler().sendToServer((PacketBase)new MoveAbilityPacket(GuiAbilityContainer.this.getSelectedPlayerAbilitySingle(), MoveAbilityPacket.Movement.FROM_PLAYER));
                    GuiAbilityContainer.this.moveFromPlayer();
                }
            }
        });
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.buttonUp1 = new GuiButtonArrow(0, this.field_147003_i + 73, this.field_147009_r + 83, GuiButtonArrow.Direction.NORTH);
        this.field_146292_n.add(this.buttonUp1);
        this.buttonDown1 = new GuiButtonArrow(1, this.field_147003_i + 73, this.field_147009_r + 174, GuiButtonArrow.Direction.SOUTH);
        this.field_146292_n.add(this.buttonDown1);
        this.buttonUp2 = new GuiButtonArrow(2, this.field_147003_i + 88, this.field_147009_r + 83, GuiButtonArrow.Direction.NORTH);
        this.field_146292_n.add(this.buttonUp2);
        this.buttonDown2 = new GuiButtonArrow(3, this.field_147003_i + 88, this.field_147009_r + 174, GuiButtonArrow.Direction.SOUTH);
        this.field_146292_n.add(this.buttonDown2);
        this.buttonLeft = new GuiButtonArrow(4, this.field_147003_i + 76, this.field_147009_r + 130, GuiButtonArrow.Direction.WEST);
        this.field_146292_n.add(this.buttonLeft);
        this.buttonRight = new GuiButtonArrow(5, this.field_147003_i + 90, this.field_147009_r + 130, GuiButtonArrow.Direction.EAST);
        this.field_146292_n.add(this.buttonRight);
    }

    protected int getBaseYSize() {
        return 219;
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        if (((ContainerAbilityContainer)this.getContainer()).getItemStack(this.player) == null) {
            return;
        }
        this.field_146289_q.func_78276_b(this.player.getDisplayNameString(), 8, 6, -1);
        this.field_146289_q.func_78276_b(L10NHelpers.localize((String)((ItemGuiAbilityContainer)((ContainerAbilityContainer)this.getContainer()).getItem()).getConfig().getFullUnlocalizedName()), 102, 6, -1);
        this.drawAbilitiesTooltip(8, 83, this.getPlayerAbilities(), this.startIndexPlayer, mouseX, mouseY);
        this.drawAbilitiesTooltip(105, 83, this.getItemAbilities(), this.startIndexItem, mouseX, mouseY);
    }

    protected List<Ability> getPlayerAbilities() {
        return ((ContainerAbilityContainer)this.getContainer()).getPlayerAbilities();
    }

    protected List<Ability> getItemAbilities() {
        return ((ContainerAbilityContainer)this.getContainer()).getItemAbilities();
    }

    protected IMutableAbilityStore getPlayerAbilityStore() {
        return ((ContainerAbilityContainer)this.getContainer()).getPlayerAbilityStore();
    }

    protected IMutableAbilityStore getItemAbilityStore() {
        return ((ContainerAbilityContainer)this.getContainer()).getItemAbilityStore();
    }

    protected int getPlayerAbilitiesCount() {
        return this.getPlayerAbilities().size();
    }

    protected int getItemAbilitiesCount() {
        return this.getItemAbilities().size();
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        if (((ContainerAbilityContainer)this.getContainer()).getItemStack(this.player) == null) {
            return;
        }
        this.buttonUp1.field_146124_l = this.startIndexPlayer > 0;
        this.buttonDown1.field_146124_l = this.startIndexPlayer + 6 < Math.max(6, this.getPlayerAbilitiesCount());
        this.buttonUp2.field_146124_l = this.startIndexItem > 0;
        this.buttonDown2.field_146124_l = this.startIndexItem + 6 < Math.max(6, this.getItemAbilitiesCount());
        this.buttonLeft.field_146124_l = this.canMoveToPlayer();
        this.buttonRight.field_146124_l = this.canMoveFromPlayer();
        this.buttonRight.field_146125_m = this.canMoveFromPlayerByItem();
        super.func_146976_a(partialTicks, mouseX, mouseY);
        int i = this.field_147003_i;
        int j = this.field_147009_r;
        this.drawFancyBackground(i + 8, j + 17, 66, 61, this.getPlayerAbilityStore());
        GuiInventory.func_147046_a((int)(i + 41), (int)(j + 74), (int)30, (float)((float)(i + 41) - (float)mouseX), (float)((float)(j + 76 - 50) - (float)mouseY), (EntityLivingBase)this.field_146297_k.field_71439_g);
        this.drawXp(i + 67, j + 70);
        RenderHelpers.drawScaledCenteredString((FontRenderer)this.field_146289_q, (String)("" + this.player.field_71067_cb), (int)(i + 62), (int)(j + 73), (int)0, (float)0.5f, (int)Helpers.RGBToInt((int)40, (int)215, (int)40));
        this.drawFancyBackground(i + 102, j + 17, 66, 61, this.getItemAbilityStore());
        GuiAbilityContainer.drawItemOnScreen(i + 134, j + 46, 50, (float)(i + 134) - (float)mouseX, (float)(j + 46 - 30) - (float)mouseY, ((ContainerAbilityContainer)this.getContainer()).getItemStack((EntityPlayer)this.field_146297_k.field_71439_g));
        this.drawAbilities(this.field_147003_i + 8, this.field_147009_r + 83, this.getPlayerAbilities(), this.startIndexPlayer, Integer.MAX_VALUE, this.absoluteSelectedIndexPlayer, mouseX, mouseY, this.canMoveFromPlayerByItem());
        this.drawAbilities(this.field_147003_i + 105, this.field_147009_r + 83, this.getItemAbilities(), this.startIndexItem, this.player.field_71067_cb, this.absoluteSelectedIndexItem, mouseX, mouseY, true);
    }

    public void drawFancyBackground(int x, int y, int width, int height, IAbilityStore abilityStore) {
        int r = 140;
        int g = 140;
        int b = 140;
        if (abilityStore != null) {
            if (abilityStore.getAbilityTypes().isEmpty()) {
                return;
            }
            Triple<Integer, Integer, Integer> color = AbilityHelpers.getAverageRarityColor(abilityStore);
            r = (Integer)color.getLeft();
            g = (Integer)color.getMiddle();
            b = (Integer)color.getRight();
        }
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179143_c((int)514);
        GlStateManager.func_179140_f();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(RES_ITEM_GLINT);
        GlStateManager.func_179128_n((int)5890);
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)8.0f, (float)8.0f, (float)8.0f);
        float f = (float)(Minecraft.func_71386_F() % 3000L) / 3000.0f / 8.0f;
        GlStateManager.func_179109_b((float)f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)-50.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179147_l();
        this.drawTexturedModalRectColor(x, y, 0, 0, width, height, r, g, b, 255);
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)8.0f, (float)8.0f, (float)8.0f);
        float f1 = (float)(Minecraft.func_71386_F() % 4873L) / 4873.0f / 8.0f;
        GlStateManager.func_179109_b((float)(-f1), (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)10.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        float rotation = (float)(Minecraft.func_71386_F() / 100L % 3600L) / 10.0f;
        GlStateManager.func_179114_b((float)rotation, (float)1.0f, (float)0.5f, (float)1.0f);
        this.drawTexturedModalRectColor(x, y, 0, 0, width, height, r, g, b, 255);
        GlStateManager.func_179121_F();
        GlStateManager.func_179128_n((int)5888);
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179143_c((int)515);
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179084_k();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    protected void drawXp(int x, int y) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this.texture);
        this.func_73729_b(x, y, 0, 219, 5, 5);
    }

    private void drawAbilities(int x, int y, List<Ability> abilities, int startIndex, int playerXp, int currentSelectedIndex, int mouseX, int mouseY, boolean canEdit) {
        int maxI = Math.min(6, abilities.size() - startIndex);
        for (int i = 0; i < maxI; ++i) {
            int boxY = y + i * 18;
            Ability ability = abilities.get(i + startIndex);
            if (canEdit) {
                boolean showActive;
                boolean active = currentSelectedIndex == i + startIndex;
                boolean bl = showActive = active || this.isPointInRegion(new Rectangle(x - this.field_147003_i, boxY - this.field_147009_r, 63, 18), new Point(mouseX, mouseY));
                if (showActive) {
                    this.drawFancyBackground(x, boxY - 1, 63, 18, null);
                }
            }
            RenderHelpers.drawScaledCenteredString((FontRenderer)this.field_146289_q, (String)(ability.getAbilityType().getRarity().field_77937_e + L10NHelpers.localize((String)ability.getAbilityType().getUnlocalizedName())), (int)(x + 27), (int)(boxY + 7), (int)0, (float)1.0f, (int)50, (int)-1);
            RenderHelpers.drawScaledCenteredString((FontRenderer)this.field_146289_q, (String)("" + ability.getLevel()), (int)(x + 58), (int)(boxY + 5), (int)0, (float)0.8f, (int)-1);
            int requiredXp = ability.getAbilityType().getBaseXpPerLevel();
            if (playerXp < requiredXp) {
                GlStateManager.func_179131_c((float)0.3f, (float)0.3f, (float)0.3f, (float)1.0f);
            } else {
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            this.drawXp(x + 57, boxY + 10);
            RenderHelpers.drawScaledCenteredString((FontRenderer)this.field_146289_q, (String)("" + requiredXp), (int)(x + 53), (int)(boxY + 13), (int)0, (float)0.5f, (int)Helpers.RGBToInt((int)40, (int)215, (int)40));
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private void drawAbilitiesTooltip(int x, int y, List<Ability> abilities, int startIndex, int mouseX, int mouseY) {
        int maxI = Math.min(6, abilities.size() - startIndex);
        for (int i = 0; i < maxI; ++i) {
            int boxY = y + i * 18;
            if (!this.isPointInRegion(new Rectangle(x, boxY, 63, 18), new Point(mouseX, mouseY))) continue;
            Ability ability = abilities.get(i + startIndex);
            LinkedList lines = Lists.newLinkedList();
            lines.add(ability.getAbilityType().getRarity().field_77937_e + L10NHelpers.localize((String)ability.getAbilityType().getUnlocalizedName()));
            lines.add(L10NHelpers.localize((String)"general.everlastingabilities.level", (Object[])new Object[]{ability.getLevel(), ability.getAbilityType().getMaxLevel()}));
            String localizedDescription = L10NHelpers.localize((String)ability.getAbilityType().getUnlocalizedDescription());
            lines.addAll(StringHelpers.splitLines((String)localizedDescription, (int)25, (String)IInformationProvider.INFO_PREFIX));
            lines.add(TextFormatting.DARK_GREEN + L10NHelpers.localize((String)"general.everlastingabilities.xp", (Object[])new Object[]{ability.getAbilityType().getBaseXpPerLevel()}));
            this.drawTooltip(lines, mouseX - this.field_147003_i, mouseY - this.field_147009_r);
        }
    }

    public void drawTexturedModalRectColor(int x, int y, int textureX, int textureY, int width, int height, int r, int g, int b, int a) {
        float f = 0.00390625f;
        float f1 = 0.00390625f;
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer vertexbuffer = tessellator.func_178180_c();
        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        vertexbuffer.func_181662_b((double)(x + 0), (double)(y + height), (double)this.field_73735_i).func_187315_a((double)((float)(textureX + 0) * f), (double)((float)(textureY + height) * f1)).func_181669_b(r, g, b, a).func_181675_d();
        vertexbuffer.func_181662_b((double)(x + width), (double)(y + height), (double)this.field_73735_i).func_187315_a((double)((float)(textureX + width) * f), (double)((float)(textureY + height) * f1)).func_181669_b(r, g, b, a).func_181675_d();
        vertexbuffer.func_181662_b((double)(x + width), (double)(y + 0), (double)this.field_73735_i).func_187315_a((double)((float)(textureX + width) * f), (double)((float)(textureY + 0) * f1)).func_181669_b(r, g, b, a).func_181675_d();
        vertexbuffer.func_181662_b((double)(x + 0), (double)(y + 0), (double)this.field_73735_i).func_187315_a((double)((float)(textureX + 0) * f), (double)((float)(textureY + 0) * f1)).func_181669_b(r, g, b, a).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void drawItemOnScreen(int posX, int posY, int scale, float mouseX, float mouseY, ItemStack itemStack) {
        GlStateManager.func_179142_g();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)posX, (float)posY, (float)50.0f);
        GlStateManager.func_179152_a((float)(-scale), (float)scale, (float)scale);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179114_b((float)(-((float)Math.atan(mouseX / 40.0f)) * 40.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(-((float)Math.atan(mouseY / 20.0f)) * 20.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179123_a();
        RenderHelper.func_74519_b();
        RenderHelpers.renderItem((ItemStack)itemStack);
        RenderHelper.func_74518_a();
        GlStateManager.func_179099_b();
        GlStateManager.func_179145_e();
        GlStateManager.func_179121_F();
        RenderHelper.func_74518_a();
        GlStateManager.func_179101_C();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
        GlStateManager.func_179090_x();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        int newSelectedPlayer = this.canMoveFromPlayerByItem() ? this.clickAbilities(8, 83, this.getPlayerAbilities(), this.startIndexPlayer, this.absoluteSelectedIndexPlayer, mouseX, mouseY) : -2;
        int newSelectedItem = this.clickAbilities(105, 83, this.getItemAbilities(), this.startIndexItem, this.absoluteSelectedIndexItem, mouseX, mouseY);
        if (newSelectedPlayer >= -1) {
            this.absoluteSelectedIndexPlayer = newSelectedPlayer;
        }
        if (newSelectedItem >= -1) {
            this.absoluteSelectedIndexItem = newSelectedItem;
        }
        if (newSelectedPlayer < 0 && newSelectedItem < 0) {
            super.func_73864_a(mouseX, mouseY, mouseButton);
        }
    }

    private int clickAbilities(int x, int y, List<Ability> abilities, int startIndex, int currentSelectedIndex, int mouseX, int mouseY) {
        int maxI = Math.min(6, abilities.size() - startIndex);
        for (int i = 0; i < maxI; ++i) {
            int boxY = y + i * 18;
            if (!this.isPointInRegion(new Rectangle(x, boxY, 63, 18), new Point(mouseX, mouseY))) continue;
            int absoluteIndex = startIndex + i;
            if (currentSelectedIndex == absoluteIndex) {
                return -1;
            }
            return absoluteIndex;
        }
        return -2;
    }

    public Ability getSelectedPlayerAbilitySingle() {
        Ability ability = this.getSelectedPlayerAbility();
        if (ability != null) {
            ability = new Ability(ability.getAbilityType(), 1);
        }
        return ability;
    }

    public Ability getSelectedItemAbilitySingle() {
        Ability ability = this.getSelectedItemAbility();
        if (ability != null) {
            ability = new Ability(ability.getAbilityType(), 1);
        }
        return ability;
    }

    public Ability getSelectedPlayerAbility() {
        List<Ability> abilities = this.getPlayerAbilities();
        if (this.absoluteSelectedIndexPlayer >= 0 && this.absoluteSelectedIndexPlayer < abilities.size()) {
            return abilities.get(this.absoluteSelectedIndexPlayer);
        }
        return null;
    }

    public Ability getSelectedItemAbility() {
        List<Ability> abilities = this.getItemAbilities();
        if (this.absoluteSelectedIndexItem >= 0 && this.absoluteSelectedIndexItem < abilities.size()) {
            return abilities.get(this.absoluteSelectedIndexItem);
        }
        return null;
    }

    public boolean canMoveFromPlayer(Ability ability, EntityPlayer player, IMutableAbilityStore target) {
        return ability != null && AbilityHelpers.canInsert(ability, target);
    }

    public boolean canMoveToPlayer(Ability ability, EntityPlayer player) {
        return ability != null && AbilityHelpers.canInsertToPlayer(ability, player);
    }

    public boolean canMoveFromPlayerByItem() {
        return ((ItemGuiAbilityContainer)((ContainerAbilityContainer)this.getContainer()).getItem()).canMoveFromPlayer();
    }

    public boolean canMoveFromPlayer() {
        if (!this.canMoveFromPlayerByItem()) {
            return false;
        }
        Ability playerAbility = this.getSelectedPlayerAbilitySingle();
        return this.canMoveFromPlayer(playerAbility, this.player, this.getItemAbilityStore());
    }

    public boolean canMoveToPlayer() {
        Ability itemAbility = this.getSelectedItemAbilitySingle();
        return this.canMoveToPlayer(itemAbility, this.player);
    }

    public void moveFromPlayer() {
        ((ContainerAbilityContainer)this.getContainer()).moveFromPlayer(this.getSelectedPlayerAbilitySingle());
    }

    public void moveToPlayer() {
        ((ContainerAbilityContainer)this.getContainer()).moveToPlayer(this.getSelectedItemAbilitySingle());
    }
}

