/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.everlastingabilities.command;

import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.fml.common.FMLCommonHandler;
import org.cyclops.cyclopscore.command.CommandMod;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.everlastingabilities.ability.AbilityHelpers;
import org.cyclops.everlastingabilities.ability.AbilityTypes;
import org.cyclops.everlastingabilities.api.Ability;
import org.cyclops.everlastingabilities.api.IAbilityType;
import org.cyclops.everlastingabilities.api.capability.IMutableAbilityStore;
import org.cyclops.everlastingabilities.capability.MutableAbilityStoreConfig;

public class CommandModifyAbilities
extends CommandMod {
    public static final String NAME = "abilities";

    public CommandModifyAbilities(ModBase mod) {
        super(mod, NAME);
    }

    public String getFullCommand() {
        return super.getFullCommand() + " " + NAME;
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] parts, BlockPos blockPos) {
        if (parts.length <= 1) {
            return Lists.newArrayList((Object[])new String[]{"add", "remove", "list"});
        }
        if (parts.length <= 2) {
            return CommandBase.func_71530_a((String[])parts, (String[])FMLCommonHandler.instance().getMinecraftServerInstance().func_71213_z());
        }
        if (parts.length <= 3 && ("add".equals(parts[0]) || "remove".equals(parts[0]))) {
            ArrayList abilityIds = Lists.newArrayList();
            Collection<IAbilityType> abilityTypes = AbilityTypes.REGISTRY.getAbilityTypes();
            for (IAbilityType abilityType : abilityTypes) {
                abilityIds.add(abilityType.getUnlocalizedName());
            }
            return abilityIds;
        }
        return Collections.emptyList();
    }

    public void processCommandHelp(ICommandSender icommandsender, String[] astring) throws CommandException {
        throw new WrongUsageException("/" + this.getFullCommand() + " <add|remove|list> <player> <abilityid> <level>", new Object[0]);
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] parts) throws CommandException {
        if (parts.length < 2 || parts[0].length() == 0) {
            this.processCommandHelp(sender, parts);
        } else {
            MinecraftServer minecraftserver = FMLCommonHandler.instance().getMinecraftServerInstance();
            GameProfile gameprofile = minecraftserver.func_152358_ax().func_152655_a(parts[1]);
            if (gameprofile == null) {
                sender.func_145747_a((ITextComponent)new TextComponentString(L10NHelpers.localize((String)"chat.cyclopscore.command.invalidPlayer", (Object[])new Object[]{parts[1]})));
            } else {
                EntityPlayerMP player = minecraftserver.func_184103_al().func_152612_a(parts[1]);
                IMutableAbilityStore abilityStore = (IMutableAbilityStore)player.getCapability(MutableAbilityStoreConfig.CAPABILITY, null);
                String command = parts[0];
                if ("list".equals(command)) {
                    sender.func_145747_a((ITextComponent)new TextComponentString(abilityStore.getAbilities().toString()));
                } else if ("add".equals(command) || "remove".equals(command)) {
                    if (parts.length >= 3 && parts.length < 5) {
                        String unlocalizedAbilityName = parts[2];
                        IAbilityType abilityType = AbilityTypes.REGISTRY.getAbilityType(unlocalizedAbilityName);
                        int level = 1;
                        if (parts.length > 3) {
                            try {
                                level = Integer.parseInt(parts[3]);
                            }
                            catch (NumberFormatException e) {
                                // empty catch block
                            }
                        }
                        if (abilityType == null) {
                            sender.func_145747_a((ITextComponent)new TextComponentString(L10NHelpers.localize((String)"chat.everlastingabilities.command.invalidAbility", (Object[])new Object[]{abilityType})));
                        } else if ("add".equals(command)) {
                            level = Math.max(1, Math.min(abilityType.getMaxLevel(), level));
                            Ability ability = new Ability(abilityType, level);
                            Ability addedAbility = AbilityHelpers.addPlayerAbility((EntityPlayer)player, ability, true, false);
                            Ability newAbility = abilityStore.getAbility(abilityType);
                            sender.func_145747_a((ITextComponent)new TextComponentString(L10NHelpers.localize((String)"chat.everlastingabilities.command.addedAbility", (Object[])new Object[]{addedAbility, newAbility})));
                        } else {
                            level = Math.max(1, level);
                            Ability ability = new Ability(abilityType, level);
                            Ability removedAbility = AbilityHelpers.removePlayerAbility((EntityPlayer)player, ability, true, false);
                            Ability newAbility = abilityStore.getAbility(abilityType);
                            sender.func_145747_a((ITextComponent)new TextComponentString(L10NHelpers.localize((String)"chat.everlastingabilities.command.removedAbility", (Object[])new Object[]{removedAbility, newAbility})));
                        }
                    }
                } else {
                    this.processCommandHelp(sender, parts);
                }
            }
        }
    }
}

