/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.everlastingabilities.item;

import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfig;
import org.cyclops.everlastingabilities.ability.AbilityTypes;
import org.cyclops.everlastingabilities.api.Ability;
import org.cyclops.everlastingabilities.api.IAbilityType;
import org.cyclops.everlastingabilities.api.capability.IAbilityStore;
import org.cyclops.everlastingabilities.api.capability.IMutableAbilityStore;
import org.cyclops.everlastingabilities.capability.MutableAbilityStoreConfig;
import org.cyclops.everlastingabilities.item.ItemGuiAbilityContainer;

public class ItemAbilityTotem
extends ItemGuiAbilityContainer {
    private static ItemAbilityTotem _instance = null;

    public static ItemAbilityTotem getInstance() {
        return _instance;
    }

    public ItemAbilityTotem(ExtendedConfig eConfig) {
        super(eConfig);
    }

    @Override
    public boolean canMoveFromPlayer() {
        return false;
    }

    public EnumRarity func_77613_e(ItemStack itemStack) {
        IAbilityStore abilityStore = (IAbilityStore)itemStack.getCapability(MutableAbilityStoreConfig.CAPABILITY, null);
        int maxRarity = 0;
        for (Ability ability : abilityStore.getAbilities()) {
            maxRarity = Math.max(maxRarity, ability.getAbilityType().getRarity().ordinal());
        }
        return EnumRarity.values()[maxRarity];
    }

    public ItemStack getTotem(Ability ability) {
        ItemStack itemStack = new ItemStack((Item)this);
        IMutableAbilityStore mutableAbilityStore = (IMutableAbilityStore)itemStack.getCapability(MutableAbilityStoreConfig.CAPABILITY, null);
        mutableAbilityStore.addAbility(ability, true);
        return itemStack;
    }

    public void func_150895_a(Item itemIn, CreativeTabs tab, List<ItemStack> subItems) {
        for (IAbilityType abilityType : AbilityTypes.REGISTRY.getAbilityTypes()) {
            for (int level = 1; level <= abilityType.getMaxLevel(); ++level) {
                Ability ability = new Ability(abilityType, level);
                subItems.add(this.getTotem(ability));
            }
        }
    }
}

