/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones;

import net.blay09.mods.waystones.WaystoneManager;
import net.blay09.mods.waystones.Waystones;
import net.blay09.mods.waystones.util.WaystoneEntry;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class PlayerWaystoneData {
    public static final String WAYSTONES = "Waystones";
    public static final String WAYSTONE_LIST = "WaystoneList";
    public static final String LAST_FREE_WARP = "LastFreeWarp";
    public static final String LAST_WARP_STONE_USE = "LastWarpStoneUse";
    public static final String LAST_SERVER_WAYSTONE = "LastWaystone";
    private final WaystoneEntry[] entries;
    private final String lastServerWaystoneName;
    private final long lastFreeWarp;
    private final long lastWarpStoneUse;

    public PlayerWaystoneData(WaystoneEntry[] entries, String lastServerWaystoneName, long lastFreeWarp, long lastWarpStoneUse) {
        this.entries = entries;
        this.lastServerWaystoneName = lastServerWaystoneName;
        this.lastFreeWarp = lastFreeWarp;
        this.lastWarpStoneUse = lastWarpStoneUse;
    }

    public WaystoneEntry[] getWaystones() {
        return this.entries;
    }

    public long getLastFreeWarp() {
        return this.lastFreeWarp;
    }

    public long getLastWarpStoneUse() {
        return this.lastWarpStoneUse;
    }

    public static NBTTagCompound getWaystonesTag(EntityPlayer player) {
        return player.getEntityData().func_74775_l("PlayerPersisted").func_74775_l(WAYSTONES);
    }

    public static NBTTagCompound getOrCreateWaystonesTag(EntityPlayer player) {
        NBTTagCompound persistedTag = player.getEntityData().func_74775_l("PlayerPersisted");
        NBTTagCompound waystonesTag = persistedTag.func_74775_l(WAYSTONES);
        persistedTag.func_74782_a(WAYSTONES, (NBTBase)waystonesTag);
        player.getEntityData().func_74782_a("PlayerPersisted", (NBTBase)persistedTag);
        return waystonesTag;
    }

    public static PlayerWaystoneData fromPlayer(EntityPlayer player) {
        NBTTagCompound tagCompound = PlayerWaystoneData.getWaystonesTag(player);
        NBTTagList tagList = tagCompound.func_150295_c(WAYSTONE_LIST, 10);
        WaystoneEntry[] entries = new WaystoneEntry[tagList.func_74745_c()];
        for (int i = 0; i < entries.length; ++i) {
            entries[i] = WaystoneEntry.read(tagList.func_150305_b(i));
        }
        String lastServerWaystoneName = tagCompound.func_74779_i(LAST_SERVER_WAYSTONE);
        long lastFreeWarp = tagCompound.func_74763_f(LAST_FREE_WARP);
        long lastWarpStoneUse = tagCompound.func_74763_f(LAST_WARP_STONE_USE);
        return new PlayerWaystoneData(entries, lastServerWaystoneName, lastFreeWarp, lastWarpStoneUse);
    }

    public static void store(EntityPlayer player, WaystoneEntry[] entries, String lastServerWaystoneName, long lastFreeWarp, long lastWarpStoneUse) {
        NBTTagCompound tagCompound = PlayerWaystoneData.getOrCreateWaystonesTag(player);
        NBTTagList tagList = new NBTTagList();
        for (WaystoneEntry entry : entries) {
            tagList.func_74742_a((NBTBase)entry.writeToNBT());
        }
        tagCompound.func_74782_a(WAYSTONE_LIST, (NBTBase)tagList);
        tagCompound.func_74778_a(LAST_SERVER_WAYSTONE, lastServerWaystoneName);
        tagCompound.func_74772_a(LAST_FREE_WARP, lastFreeWarp);
        tagCompound.func_74772_a(LAST_WARP_STONE_USE, lastWarpStoneUse);
    }

    public static void setLastServerWaystone(EntityPlayer player, WaystoneEntry waystone) {
        PlayerWaystoneData.getOrCreateWaystonesTag(player).func_74778_a(LAST_SERVER_WAYSTONE, waystone.getName());
    }

    public static void resetLastServerWaystone(EntityPlayer player) {
        PlayerWaystoneData.getWaystonesTag(player).func_82580_o(LAST_SERVER_WAYSTONE);
    }

    public static WaystoneEntry getLastWaystone(EntityPlayer player) {
        NBTTagCompound tagCompound = PlayerWaystoneData.getWaystonesTag(player);
        NBTTagList tagList = tagCompound.func_150295_c(WAYSTONE_LIST, 10);
        WaystoneEntry lastServerWaystone = WaystoneManager.getServerWaystone(tagCompound.func_74779_i(LAST_SERVER_WAYSTONE));
        if (lastServerWaystone != null) {
            return lastServerWaystone;
        }
        if (tagList.func_74745_c() > 0) {
            return WaystoneEntry.read(tagList.func_150305_b(tagList.func_74745_c() - 1));
        }
        return null;
    }

    public static boolean canFreeWarp(EntityPlayer player) {
        return System.currentTimeMillis() - PlayerWaystoneData.getLastFreeWarp(player) > (long)(Waystones.getConfig().teleportButtonCooldown * 1000);
    }

    public static boolean canUseWarpStone(EntityPlayer player) {
        return System.currentTimeMillis() - PlayerWaystoneData.getLastWarpStoneUse(player) > (long)(Waystones.getConfig().warpStoneCooldown * 1000);
    }

    public static void setLastFreeWarp(EntityPlayer player, long lastFreeWarp) {
        PlayerWaystoneData.getOrCreateWaystonesTag(player).func_74772_a(LAST_FREE_WARP, lastFreeWarp);
    }

    public static long getLastFreeWarp(EntityPlayer player) {
        return PlayerWaystoneData.getWaystonesTag(player).func_74763_f(LAST_FREE_WARP);
    }

    public static void setLastWarpStoneUse(EntityPlayer player, long lastWarpStone) {
        PlayerWaystoneData.getOrCreateWaystonesTag(player).func_74772_a(LAST_WARP_STONE_USE, lastWarpStone);
    }

    public static long getLastWarpStoneUse(EntityPlayer player) {
        return PlayerWaystoneData.getWaystonesTag(player).func_74763_f(LAST_WARP_STONE_USE);
    }

    public String getLastServerWaystoneName() {
        return this.lastServerWaystoneName;
    }
}

