/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.block;

import java.util.Random;
import javax.annotation.Nullable;
import net.blay09.mods.waystones.WaystoneConfig;
import net.blay09.mods.waystones.WaystoneManager;
import net.blay09.mods.waystones.Waystones;
import net.blay09.mods.waystones.block.TileWaystone;
import net.blay09.mods.waystones.util.WaystoneEntry;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.BlockPistonBase;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockWaystone
extends BlockContainer {
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;
    public static final PropertyBool BASE = PropertyBool.func_177716_a((String)"base");

    public BlockWaystone() {
        super(Material.field_151576_e);
        this.setRegistryName("waystones", "waystone");
        this.func_149663_c(this.getRegistryName().toString());
        this.func_149711_c(5.0f);
        this.func_149752_b(2000.0f);
        this.func_149647_a(CreativeTabs.field_78031_c);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, BASE});
    }

    public int func_176201_c(IBlockState state) {
        int meta = ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
        if (((Boolean)state.func_177229_b((IProperty)BASE)).booleanValue()) {
            meta |= 8;
        }
        return meta;
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing facing = EnumFacing.func_82600_a((int)(meta & 7));
        if (facing.func_176740_k() == EnumFacing.Axis.Y) {
            facing = EnumFacing.NORTH;
        }
        boolean isBase = (meta & 8) > 0;
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)facing).func_177226_a((IProperty)BASE, (Comparable)Boolean.valueOf(isBase));
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Nullable
    public TileEntity func_149915_a(World world, int metadata) {
        if ((metadata & 8) > 0) {
            return new TileWaystone();
        }
        return null;
    }

    public float func_180647_a(IBlockState state, EntityPlayer player, World world, BlockPos pos) {
        if (Waystones.getConfig().creativeModeOnly && !player.field_71075_bZ.field_75098_d) {
            return -1.0f;
        }
        TileWaystone tileWaystone = (TileWaystone)world.func_175625_s(pos);
        if (tileWaystone != null && WaystoneManager.getServerWaystone(tileWaystone.getWaystoneName()) != null && !player.field_71075_bZ.field_75098_d) {
            return -1.0f;
        }
        return super.func_180647_a(state, player, world, pos);
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        Block blockBelow = world.func_180495_p(pos.func_177977_b()).func_177230_c();
        if (blockBelow == this) {
            return false;
        }
        Block blockAbove = world.func_180495_p(pos.func_177981_b(2)).func_177230_c();
        return blockAbove != this && super.func_176196_c(world, pos) && world.func_180495_p(pos.func_177984_a()).func_177230_c().func_176200_f((IBlockAccess)world, pos.func_177984_a());
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileWaystone tileWaystone;
        EnumFacing facing = BlockPistonBase.func_185647_a((BlockPos)pos, (EntityLivingBase)placer);
        if (facing.func_176740_k() == EnumFacing.Axis.Y) {
            facing = EnumFacing.NORTH;
        }
        world.func_175656_a(pos, this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)facing).func_177226_a((IProperty)BASE, (Comparable)Boolean.valueOf(true)));
        world.func_175656_a(pos.func_177984_a(), this.func_176223_P().func_177226_a((IProperty)BASE, (Comparable)Boolean.valueOf(false)));
        if (!world.field_72995_K && placer instanceof EntityPlayer && (!Waystones.getConfig().creativeModeOnly || ((EntityPlayer)placer).field_71075_bZ.field_75098_d) && (tileWaystone = (TileWaystone)world.func_175625_s(pos)) != null) {
            tileWaystone.setOwner((EntityPlayer)placer);
            ((EntityPlayer)placer).openGui((Object)Waystones.instance, 1, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileWaystone tileWaystone = this.getTileWaystone(world, pos);
        if (tileWaystone != null) {
            WaystoneManager.removeServerWaystone(new WaystoneEntry(tileWaystone));
        }
        super.func_180663_b(world, pos, state);
        if (world.func_180495_p(pos.func_177984_a()).func_177230_c() == this) {
            world.func_175698_g(pos.func_177984_a());
        } else if (world.func_180495_p(pos.func_177977_b()).func_177230_c() == this) {
            world.func_175698_g(pos.func_177977_b());
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, @Nullable ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (player.func_70093_af() && (player.field_71075_bZ.field_75098_d || !Waystones.getConfig().creativeModeOnly)) {
            if (!world.field_72995_K) {
                TileWaystone tileWaystone = this.getTileWaystone(world, pos);
                if (tileWaystone == null) {
                    return true;
                }
                if (Waystones.getConfig().restrictRenameToOwner && !tileWaystone.isOwner(player)) {
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("waystones:notTheOwner", new Object[0]));
                    return true;
                }
                if (WaystoneManager.getServerWaystone(tileWaystone.getWaystoneName()) != null && !player.field_71075_bZ.field_75098_d) {
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("waystones:creativeRequired", new Object[0]));
                    return true;
                }
                player.openGui((Object)Waystones.instance, 1, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            }
            return true;
        }
        if (!world.field_72995_K) {
            TileWaystone tileWaystone = this.getTileWaystone(world, pos);
            if (tileWaystone == null) {
                return true;
            }
            if (!WaystoneManager.checkAndUpdateWaystone(player, new WaystoneEntry(tileWaystone))) {
                TextComponentString nameComponent = new TextComponentString(tileWaystone.getWaystoneName());
                nameComponent.func_150256_b().func_150238_a(TextFormatting.WHITE);
                TextComponentTranslation chatComponent = new TextComponentTranslation("waystones:activatedWaystone", new Object[]{nameComponent});
                chatComponent.func_150256_b().func_150238_a(TextFormatting.YELLOW);
                player.func_146105_b((ITextComponent)chatComponent);
            }
            WaystoneManager.activateWaystone(player, tileWaystone);
            if (Waystones.getConfig().setSpawnPoint) {
                EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
                player.setSpawnChunk(new BlockPos((Vec3i)tileWaystone.func_174877_v().func_177972_a(facing)), true, world.field_73011_w.getDimension());
            }
        } else {
            Waystones.proxy.playSound(SoundEvents.field_187802_ec, pos, 1.0f);
            for (int i = 0; i < 32; ++i) {
                world.func_175688_a(EnumParticleTypes.ENCHANTMENT_TABLE, (double)pos.func_177958_n() + 0.5 + (world.field_73012_v.nextDouble() - 0.5) * 2.0, (double)(pos.func_177956_o() + 3), (double)pos.func_177952_p() + 0.5 + (world.field_73012_v.nextDouble() - 0.5) * 2.0, 0.0, -5.0, 0.0, new int[0]);
                world.func_175688_a(EnumParticleTypes.ENCHANTMENT_TABLE, (double)pos.func_177958_n() + 0.5 + (world.field_73012_v.nextDouble() - 0.5) * 2.0, (double)(pos.func_177956_o() + 4), (double)pos.func_177952_p() + 0.5 + (world.field_73012_v.nextDouble() - 0.5) * 2.0, 0.0, -5.0, 0.0, new int[0]);
            }
        }
        return true;
    }

    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        if (!WaystoneConfig.disableParticles && rand.nextFloat() < 0.75f) {
            TileWaystone tileWaystone = this.getTileWaystone(world, pos);
            if (tileWaystone == null) {
                return;
            }
            if (WaystoneManager.getKnownWaystone(tileWaystone.getWaystoneName()) != null || WaystoneManager.getServerWaystone(tileWaystone.getWaystoneName()) != null) {
                world.func_175688_a(EnumParticleTypes.PORTAL, (double)pos.func_177958_n() + 0.5 + (rand.nextDouble() - 0.5) * 1.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5 + (rand.nextDouble() - 0.5) * 1.5, 0.0, 0.0, 0.0, new int[0]);
                world.func_175688_a(EnumParticleTypes.ENCHANTMENT_TABLE, (double)pos.func_177958_n() + 0.5 + (rand.nextDouble() - 0.5) * 1.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5 + (rand.nextDouble() - 0.5) * 1.5, 0.0, 0.0, 0.0, new int[0]);
            }
        }
    }

    @Nullable
    public TileWaystone getTileWaystone(World world, BlockPos pos) {
        TileWaystone tileWaystone = (TileWaystone)world.func_175625_s(pos);
        if (tileWaystone == null) {
            TileEntity tileBelow = world.func_175625_s(pos.func_177977_b());
            if (tileBelow instanceof TileWaystone) {
                return (TileWaystone)tileBelow;
            }
            return null;
        }
        return tileWaystone;
    }
}

