/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.client;

import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;
import net.blay09.mods.waystones.CommonProxy;
import net.blay09.mods.waystones.PlayerWaystoneData;
import net.blay09.mods.waystones.WaystoneConfig;
import net.blay09.mods.waystones.WaystoneManager;
import net.blay09.mods.waystones.Waystones;
import net.blay09.mods.waystones.block.TileWaystone;
import net.blay09.mods.waystones.client.gui.GuiButtonWarp;
import net.blay09.mods.waystones.client.gui.GuiConfirmReturn;
import net.blay09.mods.waystones.client.gui.GuiWarpStone;
import net.blay09.mods.waystones.client.gui.GuiWaystoneName;
import net.blay09.mods.waystones.client.render.RenderWaystone;
import net.blay09.mods.waystones.util.WaystoneEntry;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ClientProxy
extends CommonProxy {
    private GuiButtonWarp buttonWarp;
    private static final List<String> tmpTooltip = Lists.newArrayList();

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        super.preInit(event);
        MinecraftForge.EVENT_BUS.register((Object)this);
        ClientRegistry.bindTileEntitySpecialRenderer(TileWaystone.class, (TileEntitySpecialRenderer)new RenderWaystone());
        ForgeHooksClient.registerTESRItemStack((Item)Item.func_150898_a((Block)Waystones.blockWaystone), (int)0, TileWaystone.class);
        Item itemBlockWaystone = Item.func_150898_a((Block)Waystones.blockWaystone);
        if (itemBlockWaystone != null) {
            ModelLoader.setCustomModelResourceLocation((Item)itemBlockWaystone, (int)0, (ModelResourceLocation)new ModelResourceLocation("waystones:waystone", "inventory"));
        }
        ModelLoader.setCustomModelResourceLocation((Item)Waystones.itemWarpStone, (int)0, (ModelResourceLocation)new ModelResourceLocation(Waystones.itemWarpStone.getRegistryName(), "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)Waystones.itemReturnScroll, (int)0, (ModelResourceLocation)new ModelResourceLocation(Waystones.itemReturnScroll.getRegistryName(), "inventory"));
    }

    @SubscribeEvent
    public void onInitGui(GuiScreenEvent.InitGuiEvent.Post event) {
        if (Waystones.getConfig().teleportButton && event.getGui() instanceof GuiInventory) {
            this.buttonWarp = new GuiButtonWarp((GuiContainer)event.getGui());
            event.getButtonList().add(this.buttonWarp);
        }
    }

    @SubscribeEvent
    public void onActionPerformed(GuiScreenEvent.ActionPerformedEvent.Pre event) {
        if (event.getButton() instanceof GuiButtonWarp) {
            EntityPlayerSP entityPlayer = FMLClientHandler.instance().getClientPlayerEntity();
            if (PlayerWaystoneData.canFreeWarp((EntityPlayer)entityPlayer) && PlayerWaystoneData.getLastWaystone((EntityPlayer)entityPlayer) != null) {
                if (Waystones.getConfig().teleportButtonReturnOnly) {
                    event.getGui().field_146297_k.func_147108_a((GuiScreen)new GuiConfirmReturn());
                } else {
                    Waystones.proxy.openWaystoneSelection(true);
                }
            } else {
                event.getGui().field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)0.5f));
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onDrawScreen(GuiScreenEvent.DrawScreenEvent.Post event) {
        if (event.getGui() instanceof GuiInventory && this.buttonWarp != null && this.buttonWarp.isHovered()) {
            tmpTooltip.clear();
            long timeSince = System.currentTimeMillis() - PlayerWaystoneData.getLastFreeWarp((EntityPlayer)FMLClientHandler.instance().getClientPlayerEntity());
            int secondsLeft = (int)(((long)(Waystones.getConfig().teleportButtonCooldown * 1000) - timeSince) / 1000L);
            if (Waystones.getConfig().teleportButtonReturnOnly) {
                tmpTooltip.add(TextFormatting.YELLOW + I18n.func_135052_a((String)"tooltip.waystones:returnToWaystone", (Object[])new Object[0]));
                WaystoneEntry lastEntry = PlayerWaystoneData.getLastWaystone((EntityPlayer)FMLClientHandler.instance().getClientPlayerEntity());
                if (lastEntry != null) {
                    tmpTooltip.add(TextFormatting.GRAY + I18n.func_135052_a((String)"tooltip.waystones:boundTo", (Object[])new Object[]{TextFormatting.DARK_AQUA + lastEntry.getName()}));
                } else {
                    tmpTooltip.add(TextFormatting.GRAY + I18n.func_135052_a((String)"tooltip.waystones:boundTo", (Object[])new Object[]{I18n.func_135052_a((String)"tooltip.waystones:none", (Object[])new Object[0])}));
                }
                if (secondsLeft > 0) {
                    tmpTooltip.add("");
                    tmpTooltip.add(TextFormatting.GRAY + I18n.func_135052_a((String)"tooltip.waystones:cooldownLeft", (Object[])new Object[]{secondsLeft}));
                }
            } else {
                tmpTooltip.add(TextFormatting.YELLOW + I18n.func_135052_a((String)"tooltip.waystones:openWaystoneMenu", (Object[])new Object[0]));
                if (secondsLeft > 0) {
                    tmpTooltip.add(TextFormatting.GRAY + I18n.func_135052_a((String)"tooltip.waystones:cooldownLeft", (Object[])new Object[]{secondsLeft}));
                }
            }
            event.getGui().func_146283_a(tmpTooltip, event.getMouseX(), event.getMouseY());
        }
    }

    @SubscribeEvent
    public void onFOV(FOVUpdateEvent event) {
        if (event.getEntity().func_184607_cu() != null && event.getEntity().func_184607_cu().func_77973_b() == Waystones.itemReturnScroll) {
            event.setNewfov((float)event.getEntity().func_184605_cv() / 64.0f * 2.0f + 0.5f);
        }
    }

    @Override
    public Object getClientGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
        TileEntity tileEntity;
        if (id == 1 && (tileEntity = world.func_175625_s(new BlockPos(x, y, z))) instanceof TileWaystone) {
            return new GuiWaystoneName((TileWaystone)tileEntity);
        }
        return null;
    }

    @Override
    public void openWaystoneSelection(boolean isFree) {
        WaystoneEntry[] playerWaystones = PlayerWaystoneData.fromPlayer((EntityPlayer)FMLClientHandler.instance().getClientPlayerEntity()).getWaystones();
        WaystoneEntry[] combinedWaystones = new WaystoneEntry[WaystoneManager.getServerWaystones().size() + playerWaystones.length];
        int i = 0;
        Iterator<WaystoneEntry> iterator = WaystoneManager.getServerWaystones().iterator();
        while (iterator.hasNext()) {
            WaystoneEntry entry;
            combinedWaystones[i] = entry = iterator.next();
            ++i;
        }
        System.arraycopy(playerWaystones, 0, combinedWaystones, i, playerWaystones.length);
        Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiWarpStone(combinedWaystones, isFree));
    }

    @Override
    public void printChatMessage(int id, ITextComponent chatComponent) {
        Minecraft.func_71410_x().field_71456_v.func_146158_b().func_146234_a(chatComponent, id);
    }

    @Override
    public void playSound(SoundEvent sound, BlockPos pos, float pitch) {
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)new PositionedSoundRecord(sound, SoundCategory.AMBIENT, WaystoneConfig.soundVolume, pitch, pos));
    }

    @Override
    public void addScheduledTask(Runnable runnable) {
        Minecraft.func_71410_x().func_152344_a(runnable);
    }
}

