/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.item;

import java.util.List;
import javax.annotation.Nullable;
import net.blay09.mods.waystones.PlayerWaystoneData;
import net.blay09.mods.waystones.WaystoneManager;
import net.blay09.mods.waystones.Waystones;
import net.minecraft.client.resources.I18n;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemWarpStone
extends Item {
    public ItemWarpStone() {
        this.setRegistryName("waystones", "warpStone");
        this.func_77655_b(this.getRegistryName().toString());
        this.func_77637_a(CreativeTabs.field_78040_i);
        this.func_77625_d(1);
        this.func_77656_e(100);
    }

    public int func_77626_a(ItemStack itemStack) {
        return 32;
    }

    public EnumAction func_77661_b(ItemStack itemStack) {
        return EnumAction.BOW;
    }

    @Nullable
    public ItemStack func_77654_b(ItemStack itemStack, World world, EntityLivingBase entityLiving) {
        if (world.field_72995_K) {
            Waystones.proxy.openWaystoneSelection(false);
        }
        return itemStack;
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack itemStack, World world, EntityPlayer player, EnumHand hand) {
        if (player.field_71075_bZ.field_75098_d) {
            PlayerWaystoneData.setLastWarpStoneUse(player, 0L);
        }
        if (PlayerWaystoneData.canUseWarpStone(player)) {
            if (PlayerWaystoneData.getLastWaystone(player) != null || !WaystoneManager.getServerWaystones().isEmpty()) {
                if (!player.func_184587_cr() && world.field_72995_K) {
                    Waystones.proxy.playSound(SoundEvents.field_187814_ei, new BlockPos(player.field_70165_t, player.field_70163_u, player.field_70161_v), 2.0f);
                }
                player.func_184598_c(hand);
                return new ActionResult(EnumActionResult.SUCCESS, (Object)itemStack);
            }
            TextComponentTranslation chatComponent = new TextComponentTranslation("waystones:scrollNotBound", new Object[0]);
            chatComponent.func_150256_b().func_150238_a(TextFormatting.RED);
            Waystones.proxy.printChatMessage(3, (ITextComponent)chatComponent);
            return new ActionResult(EnumActionResult.FAIL, (Object)itemStack);
        }
        TextComponentTranslation chatComponent = new TextComponentTranslation("waystones:stoneNotCharged", new Object[0]);
        chatComponent.func_150256_b().func_150238_a(TextFormatting.RED);
        Waystones.proxy.printChatMessage(3, (ITextComponent)chatComponent);
        return new ActionResult(EnumActionResult.FAIL, (Object)itemStack);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean showDurabilityBar(ItemStack itemStack) {
        return this.getDurabilityForDisplay(itemStack) > 0.0;
    }

    @SideOnly(value=Side.CLIENT)
    public double getDurabilityForDisplay(ItemStack stack) {
        long timeSince = System.currentTimeMillis() - PlayerWaystoneData.getLastWarpStoneUse((EntityPlayer)FMLClientHandler.instance().getClientPlayerEntity());
        float percentage = (float)timeSince / (float)(Waystones.getConfig().warpStoneCooldown * 1000);
        return 1.0 - (double)Math.max(0.0f, Math.min(1.0f, percentage));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, EntityPlayer player, List list, boolean debug) {
        long timeSince = System.currentTimeMillis() - PlayerWaystoneData.getLastWarpStoneUse((EntityPlayer)FMLClientHandler.instance().getClientPlayerEntity());
        int secondsLeft = (int)(((long)(Waystones.getConfig().warpStoneCooldown * 1000) - timeSince) / 1000L);
        if (secondsLeft > 0) {
            list.add(TextFormatting.GRAY + I18n.func_135052_a((String)"tooltip.waystones:cooldownLeft", (Object[])new Object[]{secondsLeft}));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack itemStack) {
        return PlayerWaystoneData.canUseWarpStone((EntityPlayer)FMLClientHandler.instance().getClientPlayerEntity());
    }
}

