/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.util;

import io.netty.buffer.ByteBuf;
import net.blay09.mods.waystones.block.TileWaystone;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public class WaystoneEntry {
    private final String name;
    private final int dimensionId;
    private final BlockPos pos;
    private boolean isGlobal;

    public WaystoneEntry(String name, int dimensionId, BlockPos pos) {
        this.name = name;
        this.dimensionId = dimensionId;
        this.pos = pos;
    }

    public WaystoneEntry(TileWaystone tileWaystone) {
        this.name = tileWaystone.getWaystoneName();
        this.dimensionId = tileWaystone.func_145831_w().field_73011_w.getDimension();
        this.pos = tileWaystone.func_174877_v();
    }

    public String getName() {
        return this.name;
    }

    public int getDimensionId() {
        return this.dimensionId;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public boolean isGlobal() {
        return this.isGlobal;
    }

    public void setGlobal(boolean isGlobal) {
        this.isGlobal = isGlobal;
    }

    public static WaystoneEntry read(ByteBuf buf) {
        return new WaystoneEntry(ByteBufUtils.readUTF8String((ByteBuf)buf), buf.readInt(), BlockPos.func_177969_a((long)buf.readLong()));
    }

    public static WaystoneEntry read(NBTTagCompound tagCompound) {
        return new WaystoneEntry(tagCompound.func_74779_i("Name"), tagCompound.func_74762_e("Dimension"), BlockPos.func_177969_a((long)tagCompound.func_74763_f("Position")));
    }

    public void write(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.name);
        buf.writeInt(this.dimensionId);
        buf.writeLong(this.pos.func_177986_g());
    }

    public NBTTagCompound writeToNBT() {
        NBTTagCompound tagCompound = new NBTTagCompound();
        tagCompound.func_74778_a("Name", this.name);
        tagCompound.func_74768_a("Dimension", this.dimensionId);
        tagCompound.func_74772_a("Position", this.pos.func_177986_g());
        return tagCompound;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WaystoneEntry that = (WaystoneEntry)o;
        return this.dimensionId == that.dimensionId && this.pos.equals((Object)that.pos);
    }

    public int hashCode() {
        int result = this.dimensionId;
        result = 31 * result + this.pos.hashCode();
        return result;
    }
}

