/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.lib.lib.config;

import de.teamlapen.lib.VampLib;
import de.teamlapen.lib.lib.config.DefaultBoolean;
import de.teamlapen.lib.lib.config.DefaultDouble;
import de.teamlapen.lib.lib.config.DefaultInt;
import java.io.File;
import java.io.PrintWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;

public abstract class BalanceValues {
    private static final String TAG = "Balance";
    private final String name;
    private Configuration configuration;

    private static void reset(File f) {
        VampLib.log.i("Configs", "Resetting config file " + f.getName(), new Object[0]);
        try {
            PrintWriter writer = new PrintWriter(f);
            writer.write("");
            writer.flush();
            writer.close();
        }
        catch (Exception e) {
            VampLib.log.e("Configs", "Failed to reset config file", new Object[0]);
        }
    }

    public BalanceValues(String name, File directory) {
        this.configuration = new Configuration(new File(directory, name + ".cfg"));
        this.name = name;
    }

    public ConfigCategory getConfigCategory() {
        return this.configuration.getCategory("general");
    }

    public String getName() {
        return this.name;
    }

    public void loadBalance() {
        ConfigCategory cat = this.configuration.getCategory("general");
        boolean alt = this.shouldUseAlternate();
        for (Field f : this.getClass().getDeclaredFields()) {
            String name = f.getName();
            Class<?> type = f.getType();
            try {
                int value;
                Annotation a;
                if (type == Integer.TYPE) {
                    a = f.getAnnotation(DefaultInt.class);
                    value = alt && a.hasAlternate() ? a.alternateValue() : a.value();
                    f.set(this, this.configuration.get(cat.getQualifiedName(), this.chooseName(name, a.name()), value, a.comment(), a.minValue(), a.maxValue()).getInt());
                    continue;
                }
                if (type == Double.TYPE) {
                    a = f.getAnnotation(DefaultDouble.class);
                    double value2 = alt && a.hasAlternate() ? a.alternateValue() : a.value();
                    f.set(this, this.configuration.get(cat.getQualifiedName(), this.chooseName(name, a.name()), value2, a.comment(), a.minValue(), a.maxValue()).getDouble());
                    continue;
                }
                if (type != Boolean.TYPE) continue;
                a = f.getAnnotation(DefaultBoolean.class);
                value = (alt && a.hasAlternate() ? a.alternateValue() : a.value()) ? 1 : 0;
                f.set(this, this.configuration.get(cat.getQualifiedName(), this.chooseName(name, a.name()), value != 0, a.comment()).getBoolean());
            }
            catch (NullPointerException e1) {
                VampLib.log.e(TAG, "Author probably forgot to specify a default annotation for " + name + " in " + this.name, e1);
                throw new Error("Please check you default values in " + this.name);
            }
            catch (Exception e) {
                VampLib.log.e(TAG, "Cant set " + this.name + " values", e);
                throw new Error("Please check your " + this.configuration.getConfigFile().getAbsolutePath() + " config file");
            }
        }
        if (this.configuration.hasChanged()) {
            this.configuration.save();
        }
    }

    public void resetAndReload() {
        BalanceValues.reset(this.configuration.getConfigFile());
        this.configuration = new Configuration(this.configuration.getConfigFile());
        this.loadBalance();
    }

    protected abstract boolean shouldUseAlternate();

    private String chooseName(String fieldName, String attrName) {
        if (attrName.isEmpty()) {
            return fieldName.toLowerCase();
        }
        return attrName;
    }
}

