/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.lib.lib.network;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityTracker;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;

public abstract class AbstractPacketDispatcher {
    private final SimpleNetworkWrapper dispatcher;
    private byte packetId = 0;

    protected AbstractPacketDispatcher(String channelName) {
        this.dispatcher = NetworkRegistry.INSTANCE.newSimpleChannel(channelName);
    }

    public abstract void registerPackets();

    public final void sendTo(IMessage message, EntityPlayerMP player) {
        this.dispatcher.sendTo(message, player);
    }

    public final void sendToAllAround(IMessage message, NetworkRegistry.TargetPoint point) {
        this.dispatcher.sendToAllAround(message, point);
    }

    public final void sendToAllAround(IMessage message, int dimension, double x, double y, double z, double range) {
        this.sendToAllAround(message, new NetworkRegistry.TargetPoint(dimension, x, y, z, range));
    }

    public final void sendToAllAround(IMessage message, EntityPlayer player, double range) {
        this.sendToAllAround(message, player.func_130014_f_().field_73011_w.getDimension(), player.field_70165_t, player.field_70163_u, player.field_70161_v, range);
    }

    public final void sendToAllTrackingPlayers(IMessage message, Entity target) {
        EntityTracker et = ((WorldServer)target.func_130014_f_()).func_73039_n();
        et.func_151248_b(target, this.dispatcher.getPacketFrom(message));
    }

    public final void sendToDimension(IMessage message, int dimensionId) {
        this.dispatcher.sendToDimension(message, dimensionId);
    }

    public final void sendToServer(IMessage message) {
        this.dispatcher.sendToServer(message);
    }

    protected final void registerMessage(Class handlerClass, Class messageClass, Side side) {
        byte by = this.packetId;
        this.packetId = (byte)(by + 1);
        this.dispatcher.registerMessage(handlerClass, messageClass, (int)by, side);
    }
}

