/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.lib.lib.util;

import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class InventoryRenderHelper {
    private final String domain;

    public InventoryRenderHelper(String domain) {
        this.domain = domain;
    }

    public void registerRender(Item item, int meta, String name, String variant) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)new ModelResourceLocation(new ResourceLocation(this.domain, "item/" + name), "type=" + variant));
    }

    public void registerRender(Item item, int meta, String variant) {
        this.registerRender(item, meta, item.getRegistryName().func_110623_a(), variant);
    }

    public void registerRender(Item item, String name, String variant) {
        this.registerRender(item, 0, name, variant);
    }

    public void registerRender(Item item, String variant) {
        this.registerRender(item, item.getRegistryName().func_110623_a(), variant);
    }

    public void registerRender(Block block, int meta, String name) {
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)block), (int)meta, (ModelResourceLocation)new ModelResourceLocation(new ResourceLocation(this.domain, name), "inventory"));
    }

    public void registerRender(Block block, int meta) {
        this.registerRender(block, meta, block.getRegistryName().func_110623_a());
    }

    public void registerRender(Block block, String name) {
        this.registerRender(block, 0, name);
    }

    public void registerRender(Block block) {
        this.registerRender(block, 0, block.getRegistryName().func_110623_a());
    }

    public void registerRenderAllMeta(Item item, int meta_count) {
        for (int i = 0; i < meta_count; ++i) {
            this.registerRender(item, i, "meta_" + i);
        }
    }

    public void registerRenderAllMeta(Item item, String[] variants) {
        for (int i = 0; i < variants.length; ++i) {
            this.registerRender(item, i, variants[i]);
        }
    }

    public void registerRenderAllMeta(Item item, int meta_count, String state) {
        for (int i = 0; i < meta_count; ++i) {
            this.registerRender(item, i, state);
        }
    }

    public void registerRenderAllMeta(Item item, IStringSerializable[] variants) {
        for (int i = 0; i < variants.length; ++i) {
            this.registerRender(item, i, variants[i].func_176610_l());
        }
    }
}

