/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.lib.lib.util;

import com.google.common.io.ByteStreams;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import de.teamlapen.lib.VampLib;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class VersionChecker
implements Runnable {
    private static final String TAG = "VersionChecker";
    private final String UPDATE_FILE_URL;
    private final VersionInfo versionInfo;
    private final String currentVersion;

    public static VersionInfo executeVersionCheck(String updateUrl, String currentVersion) {
        VersionChecker checker = new VersionChecker(updateUrl, currentVersion);
        new Thread(checker).start();
        return checker.versionInfo;
    }

    protected VersionChecker(String update_file_url, String currentVersion) {
        this.UPDATE_FILE_URL = update_file_url;
        this.currentVersion = currentVersion;
        this.versionInfo = new VersionInfo(currentVersion);
    }

    @Override
    public void run() {
        VampLib.log.i(TAG, "Starting version check at %s", this.UPDATE_FILE_URL);
        try {
            URL url = new URL(this.UPDATE_FILE_URL);
            this.check(url);
        }
        catch (MalformedURLException e) {
            VampLib.log.e(TAG, e, "Failed to parse update file url (%s)", this.UPDATE_FILE_URL);
        }
        catch (IOException e) {
            if (e instanceof ConnectException) {
                VampLib.log.e(TAG, "Failed to connect to version check url %s", this.UPDATE_FILE_URL);
            } else {
                VampLib.log.e(TAG, e, "Failed to perform version check", new Object[0]);
            }
        }
        catch (JsonSyntaxException e) {
            VampLib.log.e(TAG, e, "Failed to parse update file. It seems not well formatted", new Object[0]);
        }
        this.versionInfo.checked = true;
    }

    private void check(URL url) throws IOException, JsonSyntaxException {
        String download;
        Map tmp2;
        InputStream con = url.openStream();
        String data = new String(ByteStreams.toByteArray((InputStream)con));
        con.close();
        Map json = (Map)new Gson().fromJson(data, Map.class);
        Map promos = (Map)json.get("promos");
        this.versionInfo.homePage = (String)json.get("homepage");
        String rec = (String)promos.get("1.10.2-recommended");
        String lat = (String)promos.get("1.10.2-latest");
        Version current = Version.parse(this.currentVersion);
        if (current == null) {
            VampLib.log.w(TAG, "Failed to parse current version (%s), aborting version check", this.currentVersion);
            return;
        }
        this.versionInfo.currentVersion = current;
        Version possibleTarget = null;
        if (current.type == Version.TYPE.RELEASE) {
            if (rec != null) {
                possibleTarget = Version.parse(rec);
            }
        } else if (lat != null) {
            possibleTarget = Version.parse(lat);
        }
        if (possibleTarget == null) {
            VampLib.log.i(TAG, "Did not find a version of type %s for %s (%s)", new Object[]{current.type, "1.10.2", current.type == Version.TYPE.RELEASE ? rec : lat});
            return;
        }
        int res = possibleTarget.compareTo(current);
        if (res <= 0) {
            return;
        }
        ArrayList<String> changes = new ArrayList<String>();
        Map tmp = (Map)json.get("1.10.2");
        if (tmp != null) {
            ArrayList<Version> ordered = new ArrayList<Version>();
            for (String key : tmp.keySet()) {
                Version ver = Version.parse(key);
                if (ver == null || ver.compareTo(current) <= 0 || ver.compareTo(possibleTarget) >= 1) continue;
                ordered.add(ver);
            }
            Collections.sort(ordered);
            for (Version ver : ordered) {
                if (ver.type != Version.TYPE.RELEASE && current.type == Version.TYPE.RELEASE) continue;
                changes.add(ver.name + ":\n" + (String)tmp.get(ver.name));
            }
        } else {
            VampLib.log.i(TAG, "No changelog provided for new version %s", possibleTarget.name);
        }
        possibleTarget.setChanges(changes);
        Map downloads = (Map)json.get("downloads");
        if (downloads != null && (tmp2 = (Map)downloads.get("1.10.2")) != null && (download = (String)tmp2.get(possibleTarget.name)) != null) {
            possibleTarget.setUrl(download);
        }
        if (possibleTarget.getUrl() == null) {
            VampLib.log.i(TAG, "No download link provided for new version %s", possibleTarget.name);
        }
        if (VampLib.inDev) {
            VampLib.log.d(TAG, "Found new version %s, but in dev", possibleTarget);
        } else {
            VampLib.log.i(TAG, "Found new version %s", possibleTarget);
            this.versionInfo.newVersion = possibleTarget;
        }
    }

    public static class Version
    implements Comparable<Version> {
        public final String name;
        @Nullable
        public final String extra;
        private final TYPE type;
        private final int main;
        private final int major;
        private final int minor;
        private String url;
        private List<String> changes;

        @Nullable
        public static Version parse(String version) {
            String name = version;
            try {
                int i = version.indexOf(43);
                String extra = null;
                if (i != -1) {
                    extra = version.substring(i);
                    version = version.substring(0, i);
                }
                i = version.indexOf(46);
                int main = Integer.parseInt(version.substring(0, i));
                version = version.substring(i + 1);
                i = version.indexOf(46);
                int major = Integer.parseInt(version.substring(0, i));
                if ((i = (version = version.substring(i + 1)).indexOf(45)) == -1) {
                    i = version.length();
                }
                int minor = Integer.parseInt(version.substring(0, i));
                TYPE type = TYPE.RELEASE;
                if (version.contains("alpha")) {
                    type = TYPE.ALPHA;
                } else if (version.contains("beta")) {
                    type = TYPE.BETA;
                    i = version.indexOf(46, version.indexOf("beta"));
                    extra = version.substring(i + 1);
                } else if (version.contains("test")) {
                    type = TYPE.TEST;
                }
                return new Version(name, main, major, minor, type, extra);
            }
            catch (NumberFormatException e) {
                VampLib.log.e(VersionChecker.TAG, e, "Failed to parse version %s", name);
                return null;
            }
            catch (StringIndexOutOfBoundsException e) {
                VampLib.log.e(VersionChecker.TAG, e, "Failed to parse version %s", name);
                return null;
            }
        }

        public Version(String name, int main, int major, int minor, TYPE type, @Nullable String extra) {
            this.name = name;
            this.main = main;
            this.major = major;
            this.minor = minor;
            this.type = type;
            this.extra = extra;
        }

        @Override
        public int compareTo(@Nonnull Version version) {
            if (version.main > this.main) {
                return -1;
            }
            if (version.main < this.main) {
                return 1;
            }
            if (version.major > this.major) {
                return -1;
            }
            if (version.major < this.major) {
                return 1;
            }
            if (version.minor > this.minor) {
                return -1;
            }
            if (version.minor < this.minor) {
                return 1;
            }
            int i = this.type.compare(version.type);
            if (i != 0) {
                return i;
            }
            if (this.type == TYPE.BETA) {
                try {
                    int cb = Integer.parseInt(this.extra);
                    int nb = Integer.parseInt(version.extra);
                    if (nb > cb) {
                        return -1;
                    }
                    if (nb < cb) {
                        return 1;
                    }
                }
                catch (NumberFormatException e) {
                    VampLib.log.e(VersionChecker.TAG, e, "Failed to parse beta number (%s)", this.extra);
                }
                return 0;
            }
            if (this.type == TYPE.ALPHA && this.extra != null && version.extra != null) {
                return this.compareDate(this.extra, version.extra);
            }
            return 0;
        }

        public List<String> getChanges() {
            return this.changes;
        }

        public void setChanges(List<String> changes) {
            this.changes = changes;
        }

        @Nullable
        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public boolean isTestVersion() {
            return this.type == TYPE.ALPHA || this.type == TYPE.TEST;
        }

        public String toString() {
            return "Version{main=" + this.main + ", major=" + this.major + ", minor=" + this.minor + ", type=" + (Object)((Object)this.type) + ", name='" + this.name + '\'' + ", url='" + this.url + '\'' + '}';
        }

        private int compareDate(String one, String two) {
            try {
                String[] ones = one.split("-");
                String[] twos = two.split("-");
                for (int i = 0; i < ones.length && i < twos.length; ++i) {
                    int o = Integer.parseInt(ones[i]);
                    int t = Integer.parseInt(twos[i]);
                    if (t > o) {
                        return -1;
                    }
                    if (t >= o) continue;
                    return 1;
                }
            }
            catch (Exception e) {
                VampLib.log.e(VersionChecker.TAG, e, "Failed to parse date %s/%s", one, two);
            }
            return 0;
        }

        static enum TYPE {
            RELEASE(0),
            BETA(1),
            ALPHA(2),
            TEST(3);

            public final int ORDER;

            private TYPE(int pos) {
                this.ORDER = pos;
            }

            public int compare(TYPE type) {
                if (type.ORDER < this.ORDER) {
                    return -1;
                }
                if (type.ORDER > this.ORDER) {
                    return 1;
                }
                return 0;
            }
        }
    }

    public static class VersionInfo {
        private Version newVersion;
        private Version currentVersion;
        private boolean checked = false;
        private String homePage;

        public VersionInfo(String current) {
            this.currentVersion = Version.parse(current);
            if (this.currentVersion == null) {
                this.currentVersion = new Version("current", 0, 0, 0, Version.TYPE.TEST, null);
            }
        }

        @Nonnull
        public Version getCurrentVersion() {
            return this.currentVersion;
        }

        @Nullable
        public String getHomePage() {
            return this.homePage;
        }

        @Nullable
        public Version getNewVersion() {
            return this.newVersion;
        }

        public boolean isChecked() {
            return this.checked;
        }

        public boolean isNewVersionAvailable() {
            return this.newVersion != null;
        }
    }
}

