/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.lib.network;

import de.teamlapen.lib.VampLib;
import de.teamlapen.vampirism.network.AbstractClientMessageHandler;
import io.netty.buffer.ByteBuf;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class SpawnCustomParticlePacket
implements IMessage {
    private NBTTagCompound nbt;

    public SpawnCustomParticlePacket() {
    }

    public SpawnCustomParticlePacket(ResourceLocation particle, double posX, double posY, double posZ, NBTTagCompound param, int count, double maxdist) {
        this(particle, posX, posY, posZ, param);
        this.nbt.func_74768_a("count", count);
        this.nbt.func_74780_a("maxdist", maxdist);
    }

    public SpawnCustomParticlePacket(ResourceLocation particle, double posX, double posY, double posZ, NBTTagCompound param) {
        this.nbt = new NBTTagCompound();
        this.nbt.func_74780_a("x", posX);
        this.nbt.func_74780_a("y", posY);
        this.nbt.func_74780_a("z", posZ);
        this.nbt.func_74778_a("id", particle.toString());
        this.nbt.func_74782_a("data", (NBTBase)param);
    }

    public void fromBytes(ByteBuf buf) {
        this.nbt = ByteBufUtils.readTag((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.nbt);
    }

    public static class Handler
    extends AbstractClientMessageHandler<SpawnCustomParticlePacket> {
        @Override
        public IMessage handleClientMessage(EntityPlayer player, SpawnCustomParticlePacket message, MessageContext ctx) {
            NBTTagCompound nbt = message.nbt;
            double posX = nbt.func_74769_h("x");
            double posY = nbt.func_74769_h("y");
            double posZ = nbt.func_74769_h("z");
            ResourceLocation particle = new ResourceLocation(nbt.func_74779_i("id"));
            NBTTagCompound data = nbt.func_74775_l("data");
            if (nbt.func_74764_b("count")) {
                int count = nbt.func_74762_e("count");
                double maxDist = nbt.func_74769_h("maxdist");
                Random random = player.func_70681_au();
                VampLib.proxy.getParticleHandler().spawnParticles(player.func_130014_f_(), particle, posX, posY, posZ, count, maxDist, random, data);
            } else {
                VampLib.proxy.getParticleHandler().spawnParticle(player.func_130014_f_(), particle, posX, posY, posZ, data);
            }
            return null;
        }

        @Override
        protected boolean handleOnMainThread() {
            return true;
        }
    }
}

