/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.lib.proxy;

import de.teamlapen.lib.proxy.CommonProxy;
import de.teamlapen.lib.util.ISoundReference;
import de.teamlapen.lib.util.ParticleHandler;
import de.teamlapen.lib.util.ParticleHandlerClient;
import de.teamlapen.lib.util.SoundReference;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.StringEscapeUtils;

@SideOnly(value=Side.CLIENT)
public class ClientProxy
extends CommonProxy {
    private ParticleHandler clientParticleHandler = new ParticleHandlerClient();

    @Override
    @Nonnull
    public ISoundReference createSoundReference(SoundEvent event, SoundCategory category, BlockPos pos, float volume, float pinch) {
        return new SoundReference((ISound)new PositionedSoundRecord(event, category, volume, pinch, pos));
    }

    @Override
    @Nonnull
    public ISoundReference createSoundReference(SoundEvent event, SoundCategory category, double x, double y, double z, float volume, float pinch) {
        return new SoundReference((ISound)new PositionedSoundRecord(event, category, volume, pinch, (float)x, (float)y, (float)z));
    }

    @Override
    public String getActiveLanguage() {
        return Minecraft.func_71410_x().func_135016_M().func_135041_c().toString();
    }

    @Override
    public ParticleHandler getParticleHandler() {
        return FMLCommonHandler.instance().getEffectiveSide().isClient() ? this.clientParticleHandler : this.serverParticleHandler;
    }

    @Override
    public EntityPlayer getPlayerEntity(MessageContext ctx) {
        return ctx.side.isClient() ? Minecraft.func_71410_x().field_71439_g : super.getPlayerEntity(ctx);
    }

    @Override
    public List<String> listFormattedStringToWidth(String str, int wrapWidth) {
        str = StringEscapeUtils.unescapeJava((String)str);
        return Minecraft.func_71410_x().field_71466_p.func_78271_c(str, wrapWidth);
    }
}

