/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.api.entity.player.skills;

import de.teamlapen.vampirism.api.entity.player.actions.IAction;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.api.entity.player.skills.ISkillPlayer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;

public abstract class DefaultSkill<T extends ISkillPlayer>
implements ISkill<T> {
    private final Map<IAttribute, AttributeModifier> attributeModifierMap = new HashMap<IAttribute, AttributeModifier>();
    private int renderRow;
    private int renderColumn;

    @Override
    public int getRenderColumn() {
        return this.renderColumn;
    }

    @Override
    public int getRenderRow() {
        return this.renderRow;
    }

    @Override
    public final void onDisable(T player) {
        this.removeAttributesModifiersFromEntity(player.getRepresentingPlayer());
        player.getActionHandler().ununlockActions(this.getActions());
        this.onDisabled(player);
    }

    @Override
    public final void onEnable(T player) {
        this.applyAttributesModifiersToEntity(player.getRepresentingPlayer());
        player.getActionHandler().unlockActions(this.getActions());
        this.onEnabled(player);
    }

    public DefaultSkill<T> registerAttributeModifier(IAttribute attribute, String uuid, double amount, int operation) {
        AttributeModifier attributemodifier = new AttributeModifier(UUID.fromString(uuid), this.getID(), amount, operation);
        this.attributeModifierMap.put(attribute, attributemodifier);
        return this;
    }

    @Override
    public void setRenderPos(int row, int column) {
        this.renderRow = row;
        this.renderColumn = column;
    }

    public String toString() {
        return this.getID() + "(" + this.getClass().getSimpleName() + ")";
    }

    protected void getActions(Collection<IAction<T>> list) {
    }

    protected void onDisabled(T player) {
    }

    protected void onEnabled(T player) {
    }

    private void applyAttributesModifiersToEntity(EntityPlayer player) {
        for (Map.Entry<IAttribute, AttributeModifier> entry : this.attributeModifierMap.entrySet()) {
            IAttributeInstance iattributeinstance = player.func_110140_aT().func_111151_a(entry.getKey());
            if (iattributeinstance == null) continue;
            AttributeModifier attributemodifier = entry.getValue();
            iattributeinstance.func_111124_b(attributemodifier);
            iattributeinstance.func_111121_a(new AttributeModifier(attributemodifier.func_111167_a(), this.getID(), attributemodifier.func_111164_d(), attributemodifier.func_111169_c()));
        }
    }

    private Collection<IAction<T>> getActions() {
        ArrayList<IAction<T>> collection = new ArrayList<IAction<T>>();
        this.getActions(collection);
        return collection;
    }

    private void removeAttributesModifiersFromEntity(EntityPlayer player) {
        for (Map.Entry<IAttribute, AttributeModifier> entry : this.attributeModifierMap.entrySet()) {
            IAttributeInstance iattributeinstance = player.func_110140_aT().func_111151_a(entry.getKey());
            if (iattributeinstance == null) continue;
            iattributeinstance.func_111124_b(entry.getValue());
        }
    }
}

