/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.blocks;

import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.blocks.VampirismBlockContainer;
import de.teamlapen.vampirism.tileentity.TileAlchemicalCauldron;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockAlchemicalCauldron
extends VampirismBlockContainer {
    public static final String regName = "alchemical_cauldron";
    public static final PropertyInteger LIQUID = PropertyInteger.func_177719_a((String)"liquid", (int)0, (int)2);
    public static final PropertyBool BURNING = PropertyBool.func_177716_a((String)"burning");
    private static final AxisAlignedBB BOUNDING_BOX = new AxisAlignedBB(0.07, 0.0, 0.07, 0.93, 0.87, 0.93);

    public BlockAlchemicalCauldron() {
        super(regName, Material.field_151573_f);
        this.setHasFacing();
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)LIQUID, (Comparable)Integer.valueOf(0)).func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)BURNING, (Comparable)Boolean.valueOf(false)));
        this.func_149711_c(4.0f);
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileAlchemicalCauldron();
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        TileAlchemicalCauldron t = this.getTile(worldIn, pos);
        if (t != null) {
            state = state.func_177226_a((IProperty)LIQUID, (Comparable)Integer.valueOf(!t.isFilled() ? 0 : (t.isCooking() ? 2 : 1))).func_177226_a((IProperty)BURNING, (Comparable)Boolean.valueOf(t.isBurning()));
        }
        return state;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return BOUNDING_BOX;
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b();
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, ItemStack heldStack) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing face = EnumFacing.func_176731_b((int)meta);
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)face);
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Override
    public boolean onBlockActivated(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing faing, float hitX, float hitY, float hitZ) {
        TileAlchemicalCauldron tile;
        if (!worldIn.field_72995_K && (tile = this.getTile((IBlockAccess)worldIn, pos)) != null && tile.canUse(playerIn)) {
            playerIn.openGui((Object)VampirismMod.instance, 10, worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
        return true;
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(worldIn, pos, state, placer, stack);
        TileAlchemicalCauldron tile = this.getTile((IBlockAccess)worldIn, pos);
        if (tile != null && placer instanceof EntityPlayer) {
            tile.setOwner((EntityPlayer)placer);
        }
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, LIQUID, BURNING});
    }

    @Nullable
    private TileAlchemicalCauldron getTile(IBlockAccess world, BlockPos pos) {
        TileEntity t = world.func_175625_s(pos);
        if (t instanceof TileAlchemicalCauldron) {
            return (TileAlchemicalCauldron)t;
        }
        return null;
    }
}

