/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.blocks;

import de.teamlapen.lib.lib.util.FluidLib;
import de.teamlapen.lib.lib.util.ItemStackUtil;
import de.teamlapen.vampirism.blocks.VampirismBlockContainer;
import de.teamlapen.vampirism.tileentity.TileAltarInspiration;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.common.property.Properties;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockAltarInspiration
extends VampirismBlockContainer {
    public static final String regName = "altar_inspiration";
    public static final IUnlistedProperty<Integer> FLUID_LEVEL = new Properties.PropertyAdapter((IProperty)PropertyInteger.func_177719_a((String)"fluidLevel", (int)0, (int)10));

    public BlockAltarInspiration() {
        super(regName, Material.field_151573_f);
        this.setHarvestLevel("pickaxe", 1);
        this.func_149711_c(2.0f);
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileAltarInspiration();
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        FluidStack fluid;
        IExtendedBlockState extendedBlockState = (IExtendedBlockState)state;
        TileAltarInspiration tile = (TileAltarInspiration)world.func_175625_s(pos);
        if (tile != null && (fluid = tile.getTankInfo().fluid) != null) {
            float i = (float)fluid.amount / 10000.0f * 10.0f;
            int l = i > 0.0f && i < 1.0f ? 1 : (int)i;
            return extendedBlockState.withProperty(FLUID_LEVEL, (Object)l);
        }
        return extendedBlockState.withProperty(FLUID_LEVEL, (Object)0);
    }

    @Nonnull
    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Override
    public boolean onBlockActivated(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = playerIn.func_184586_b(hand);
        if (!ItemStackUtil.isEmpty(stack) && !worldIn.field_72995_K && FluidLib.hasFluidItemCap(stack)) {
            TileAltarInspiration tileEntity = (TileAltarInspiration)worldIn.func_175625_s(pos);
            if (!playerIn.func_70093_af()) {
                FluidLib.drainContainerIntoTank((IFluidHandler)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null), (IFluidHandler)tileEntity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null));
            }
            worldIn.func_184138_a(pos, state, state, 3);
            tileEntity.func_70296_d();
            return true;
        }
        if (ItemStackUtil.isEmpty(stack)) {
            TileAltarInspiration tileEntity = (TileAltarInspiration)worldIn.func_175625_s(pos);
            tileEntity.startRitual(playerIn);
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return super.func_176225_a(blockState, blockAccess, pos, side);
    }

    protected BlockStateContainer func_180661_e() {
        return new ExtendedBlockState((Block)this, new IProperty[0], new IUnlistedProperty[]{FLUID_LEVEL});
    }
}

