/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.gui;

import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.api.entity.player.skills.ISkillHandler;
import de.teamlapen.vampirism.api.entity.player.skills.SkillNode;
import de.teamlapen.vampirism.blocks.BlockCastleBlock;
import de.teamlapen.vampirism.client.core.ModKeys;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.network.InputEventPacket;
import de.teamlapen.vampirism.player.skills.SkillHandler;
import de.teamlapen.vampirism.player.skills.SkillRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiOptionButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiYesNo;
import net.minecraft.client.gui.GuiYesNoCallback;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Mouse;

@SideOnly(value=Side.CLIENT)
public class GuiSkills
extends GuiScreen
implements GuiYesNoCallback {
    private static final ResourceLocation BACKGROUND = new ResourceLocation("textures/gui/achievement/achievement_background.png");
    private static final ResourceLocation defaultIcons = new ResourceLocation("vampirism", "textures/gui/skills.png");
    private static final int ICON_TEXTURE_WIDTH = 256;
    private static final int ICON_TEXTURE_HEIGHT = 80;
    private final int area_min_y = -77;
    private final int skill_width = 24;
    private final List<SkillNode> skillNodes = new ArrayList<SkillNode>();
    private int display_width = 256;
    private int display_height = 202;
    private int area_min_x = 0;
    private int area_max_x = 0;
    private int area_max_y;
    private int field_146563_h;
    private int field_146564_i;
    private float zoomOut = 1.0f;
    private double displayX;
    private double displayY;
    private double displayXNew;
    private double displayYNew;
    private double field_146565_w;
    private double field_146573_x;
    private SkillHandler skillHandler;
    private boolean display;
    private ISkill selected;
    private int field_146554_D;

    public void func_73878_a(boolean result, int id) {
        super.func_73878_a(result, id);
        if (id == 10) {
            if (result) {
                VampirismMod.dispatcher.sendToServer(new InputEventPacket("rs", ""));
                this.field_146297_k.func_147108_a(null);
            } else {
                this.field_146297_k.func_147108_a((GuiScreen)this);
            }
        }
    }

    public boolean func_73868_f() {
        return false;
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        if (!this.display) {
            this.func_146276_q_();
            super.func_73863_a(mouseX, mouseY, partialTicks);
            return;
        }
        if (Mouse.isButtonDown((int)0)) {
            int centerX = (this.field_146294_l - this.display_width) / 2;
            int centerY = (this.field_146295_m - this.display_height) / 2;
            int k = centerX + 8;
            int l = centerY + 17;
            if ((this.field_146554_D == 0 || this.field_146554_D == 1) && mouseX >= k && mouseX < k + 224 && mouseY >= l && mouseY < l + 155) {
                if (this.field_146554_D == 0) {
                    this.field_146554_D = 1;
                } else {
                    this.displayXNew -= (double)((float)(mouseX - this.field_146563_h) * this.zoomOut);
                    this.displayYNew -= (double)((float)(mouseY - this.field_146564_i) * this.zoomOut);
                    this.field_146565_w = this.displayX = this.displayXNew;
                    this.field_146573_x = this.displayY = this.displayYNew;
                }
                this.field_146563_h = mouseX;
                this.field_146564_i = mouseY;
            }
        } else {
            this.field_146554_D = 0;
        }
        int mdmovement = Mouse.getDWheel();
        float zoomOutOld = this.zoomOut;
        if (mdmovement < 0) {
            this.zoomOut += 0.25f;
        } else if (mdmovement > 0) {
            this.zoomOut -= 0.25f;
        }
        this.zoomOut = MathHelper.func_76131_a((float)this.zoomOut, (float)1.0f, (float)2.0f);
        if (this.zoomOut != zoomOutOld) {
            float f5 = zoomOutOld - this.zoomOut;
            float f4 = zoomOutOld * (float)this.display_width;
            float f = zoomOutOld * (float)this.display_height;
            float f1 = this.zoomOut * (float)this.display_width;
            float f2 = this.zoomOut * (float)this.display_height;
            this.displayXNew -= (double)((f1 - f4) * 0.5f);
            this.displayYNew -= (double)((f2 - f) * 0.5f);
            this.field_146565_w = this.displayX = this.displayXNew;
            this.field_146573_x = this.displayY = this.displayYNew;
        }
        if (this.field_146565_w < (double)this.area_min_x) {
            this.field_146565_w = this.area_min_x;
        }
        if (this.field_146573_x < -77.0) {
            this.field_146573_x = -77.0;
        }
        if (this.field_146565_w >= (double)this.area_max_x) {
            this.field_146565_w = this.area_max_x - 1;
        }
        if (this.field_146573_x >= (double)this.area_max_y) {
            this.field_146573_x = this.area_max_y - 1;
        }
        this.func_146276_q_();
        this.drawSkills(mouseX, mouseY, partialTicks);
        GlStateManager.func_179140_f();
        GlStateManager.func_179097_i();
        this.drawTitle();
        GlStateManager.func_179145_e();
        GlStateManager.func_179126_j();
    }

    public void func_73866_w_() {
        IFactionPlayer factionPlayer = FactionPlayerHandler.get((EntityPlayer)this.field_146297_k.field_71439_g).getCurrentFactionPlayer();
        if (factionPlayer != null) {
            this.display = true;
            this.skillHandler = (SkillHandler)factionPlayer.getSkillHandler();
            Integer[] info = ((SkillRegistry)VampirismAPI.skillRegistry()).getDisplayInfo(factionPlayer.getFaction());
            int w = info[0] * info[1] * 24 * 2;
            this.area_max_x = w + 10 - this.display_width;
            this.area_min_x = -w - 10 - this.display_width;
            this.area_max_y = info[2] * 24 * 2;
            this.field_146565_w = -100.0;
            this.displayXNew = -100.0;
            this.displayX = -100.0;
            this.field_146573_x = -10.0;
            this.displayYNew = -10.0;
            this.displayY = -10.0;
            this.skillNodes.clear();
            this.addToList(this.skillNodes, this.skillHandler.getRootNode());
        }
        this.field_146292_n.clear();
        this.field_146292_n.add(new GuiOptionButton(1, this.field_146294_l / 2 + 24, this.field_146295_m / 2 + 74, 80, 20, UtilLib.translate("gui.done")));
        if (this.display) {
            GuiButton resetSkills = new GuiButton(2, (this.field_146294_l - this.display_width) / 2 + 24, this.field_146295_m / 2 + 74, 125, 20, UtilLib.translate("text.vampirism.skill.resetall"));
            if (factionPlayer.getLevel() < 2) {
                resetSkills.field_146124_l = false;
            }
            this.field_146292_n.add(resetSkills);
        }
    }

    public void func_73876_c() {
        if (this.display) {
            this.displayX = this.displayXNew;
            this.displayY = this.displayYNew;
            double d0 = this.field_146565_w - this.displayXNew;
            double d1 = this.field_146573_x - this.displayYNew;
            if (d0 * d0 + d1 * d1 < 4.0) {
                this.displayXNew += d0;
                this.displayYNew += d1;
            } else {
                this.displayXNew += d0 * 0.85;
                this.displayYNew += d1 * 0.85;
            }
        }
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        if (button.field_146127_k == 1) {
            this.field_146297_k.func_147108_a(null);
        }
        if (button.field_146127_k == 2) {
            boolean test = VampirismMod.inDev || VampirismMod.instance.getVersionInfo().getCurrentVersion().isTestVersion();
            GuiYesNo resetGui = new GuiYesNo((GuiYesNoCallback)this, UtilLib.translate("gui.vampirism.reset_skills.title"), UtilLib.translate("gui.vampirism.reset_skills." + (test ? "desc_test" : "desc")), 10);
            this.field_146297_k.func_147108_a((GuiScreen)resetGui);
        }
    }

    protected void drawTitle() {
        String title = I18n.func_135052_a((String)"text.vampirism.skills.gui_title", (Object[])new Object[0]);
        int x = (this.field_146294_l - this.display_width) / 2;
        int y = (this.field_146295_m - this.display_height) / 2;
        this.field_146289_q.func_78276_b(title, x + 15, y + 5, -1);
        String points = I18n.func_135052_a((String)"text.vampirism.skills.points_left", (Object[])new Object[]{this.skillHandler.getLeftSkillPoints()});
        x = (this.field_146294_l + this.display_width) / 2 - this.field_146289_q.func_78256_a(points);
        this.field_146289_q.func_78276_b(points, x - 15, y + 5, -1);
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (ModKeys.getKeyCode(ModKeys.KEY.SKILL) == keyCode) {
            this.field_146297_k.func_147108_a(null);
            this.field_146297_k.func_71381_h();
        } else {
            super.func_73869_a(typedChar, keyCode);
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        if (mouseButton == 0 && this.selected != null) {
            if (this.skillHandler.canSkillBeEnabled(this.selected) == ISkillHandler.Result.OK) {
                VampirismMod.dispatcher.sendToServer(new InputEventPacket("us", VampirismAPI.skillRegistry().getID(this.skillHandler.getPlayer().getFaction(), this.selected)));
                this.playSoundEffect(SoundEvents.field_187802_ec, 0.7f);
            } else {
                this.playSoundEffect(SoundEvents.field_187679_dF, 0.5f);
            }
        }
    }

    private void addToList(List<SkillNode> list, SkillNode root) {
        list.add(root);
        for (SkillNode node : root.getChildren()) {
            this.addToList(list, node);
        }
    }

    private void drawSkills(int mouseX, int mouseY, float partialTicks) {
        int offsetX = MathHelper.func_76128_c((double)(this.displayX + (this.displayXNew - this.displayX) * (double)partialTicks));
        int offsetY = MathHelper.func_76128_c((double)(this.displayY + (this.displayYNew - this.displayY) * (double)partialTicks));
        if (offsetX < this.area_min_x) {
            offsetX = this.area_min_x;
        }
        if (offsetY < -77) {
            offsetY = -77;
        }
        if (offsetX >= this.area_max_x) {
            offsetX = this.area_max_x - 1;
        }
        if (offsetY >= this.area_max_y) {
            offsetY = this.area_max_y - 1;
        }
        int k = (this.field_146294_l - this.display_width) / 2;
        int l = (this.field_146295_m - this.display_height) / 2;
        int i1 = k + 16;
        int j1 = l + 17;
        this.field_73735_i = 0.0f;
        GlStateManager.func_179143_c((int)518);
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)i1, (float)j1, (float)-200.0f);
        GlStateManager.func_179152_a((float)(1.0f / this.zoomOut), (float)(1.0f / this.zoomOut), (float)1.0f);
        GlStateManager.func_179098_w();
        GlStateManager.func_179140_f();
        GlStateManager.func_179091_B();
        GlStateManager.func_179142_g();
        int k1 = offsetX + 288 >> 4;
        int l1 = offsetY + 288 >> 4;
        int i2 = (offsetX + this.display_width * 2) % 16;
        int j2 = (offsetY + 288) % 16;
        Random random = new Random();
        float f = 16.0f / this.zoomOut;
        float f1 = 16.0f / this.zoomOut;
        int y = 0;
        while ((float)y * f - (float)j2 < 155.0f) {
            float f2 = 0.6f - (float)(l1 + y) / 25.0f * 0.3f;
            GlStateManager.func_179131_c((float)f2, (float)f2, (float)f2, (float)1.0f);
            int x = 0;
            while ((float)x * f1 - (float)i2 < 224.0f) {
                random.setSeed(this.field_146297_k.func_110432_I().func_148255_b().hashCode() + k1 + x + (l1 + y) * 16);
                int j4 = random.nextInt(1 + l1 + y) + (l1 + y) / 2;
                TextureAtlasSprite textureatlassprite = this.getTexture((Block)Blocks.field_150354_m);
                if (j4 <= 37 && l1 + y != 35) {
                    if (j4 == 22) {
                        textureatlassprite = random.nextInt(2) == 0 ? this.getTexture(Blocks.field_150402_ci) : this.getTexture(Blocks.field_150451_bX);
                    } else if (j4 == 10) {
                        textureatlassprite = this.getTexture(ModBlocks.castleBlock.func_176223_P().func_177226_a(BlockCastleBlock.VARIANT, (Comparable)((Object)BlockCastleBlock.EnumType.DARK_BRICK_BLOODY)));
                    } else if (j4 == 8) {
                        textureatlassprite = this.getTexture(Blocks.field_150417_aV);
                    } else if (j4 > 4) {
                        textureatlassprite = this.getTexture(ModBlocks.castleBlock);
                    } else if (j4 > 0) {
                        textureatlassprite = this.getTexture(Blocks.field_150346_d);
                    }
                } else {
                    Block block = Blocks.field_150357_h;
                    textureatlassprite = this.getTexture(block);
                }
                this.field_146297_k.func_110434_K().func_110577_a(TextureMap.field_110575_b);
                this.func_175175_a(x * 16 - i2, y * 16 - j2, textureatlassprite, 16, 16);
                ++x;
            }
            ++y;
        }
        GlStateManager.func_179126_j();
        GlStateManager.func_179143_c((int)515);
        this.field_146297_k.func_110434_K().func_110577_a(BACKGROUND);
        for (SkillNode node : this.skillNodes) {
            if (node.getParent() == null) continue;
            int xs = this.findHorizontalNodeCenter(node) - offsetX + 11;
            int ys = node.getElements()[0].getRenderRow() * 24 - offsetY + 11;
            int xp = this.findHorizontalNodeCenter(node.getParent()) - offsetX + 11;
            int yp = node.getParent().getElements()[0].getRenderRow() * 24 - offsetY + 11;
            int unlockstate = this.skillHandler.isNodeEnabled(node) ? 0 : (this.skillHandler.isNodeEnabled(node.getParent()) ? 1 : -1);
            int color = -16777216;
            if (unlockstate == 0) {
                color = -6250336;
            } else if (unlockstate == 1) {
                color = -16738048;
            }
            this.func_73730_a(xs, xp, yp, color);
            this.func_73728_b(xs, ys - 11, yp, color);
            if (ys > yp) {
                this.func_73729_b(xs - 5, ys - 11 - 7, 96, 234, 11, 7);
                continue;
            }
            if (ys < yp) {
                this.func_73729_b(xs - 5, ys + 11, 96, 241, 11, 7);
                continue;
            }
            if (xs > xp) {
                this.func_73729_b(xs - 11 - 7, ys - 5, 114, 234, 7, 11);
                continue;
            }
            if (xs >= xp) continue;
            this.func_73729_b(xs + 11, ys - 5, 107, 234, 7, 11);
        }
        float mMouseX = (float)(mouseX - i1) * this.zoomOut;
        float mMouseY = (float)(mouseY - j1) * this.zoomOut;
        RenderHelper.func_74520_c();
        GlStateManager.func_179140_f();
        GlStateManager.func_179091_B();
        GlStateManager.func_179142_g();
        ISkill newselected = null;
        for (SkillNode node : this.skillNodes) {
            ISkill[] elements = node.getElements();
            if (elements.length > 1) {
                int minX = elements[0].getRenderColumn() * 24 - offsetX;
                int maxX = elements[elements.length - 1].getRenderColumn() * 24 - offsetX;
                int y2 = elements[0].getRenderRow() * 24 - offsetY;
                if (maxX >= -24 && y2 >= -24 && (float)minX <= 224.0f * this.zoomOut && (float)y2 <= 155.0f * this.zoomOut) {
                    GlStateManager.func_179147_l();
                    this.func_73733_a(minX - 1, y2 - 1, maxX + 23, y2 + 23, -6578783, -6578783);
                    GlStateManager.func_179084_k();
                }
            }
            for (int i = 0; i < elements.length; ++i) {
                int unlockstate;
                ISkill skill = elements[i];
                int x = skill.getRenderColumn() * 24 - offsetX;
                int y3 = skill.getRenderRow() * 24 - offsetY;
                if (x < -24 || y3 < -24 || !((float)x <= 224.0f * this.zoomOut) || !((float)y3 <= 155.0f * this.zoomOut)) continue;
                int n = this.skillHandler.isSkillEnabled(skill) ? 0 : (this.skillHandler.isNodeEnabled(node) ? -1 : (unlockstate = this.skillHandler.canSkillBeEnabled(skill) == ISkillHandler.Result.OK ? 1 : 2));
                if (unlockstate == 0) {
                    float f5 = 1.0f;
                    GlStateManager.func_179131_c((float)f5, (float)f5, (float)f5, (float)1.0f);
                } else if (unlockstate == 1) {
                    float f6 = 0.6f;
                    GlStateManager.func_179131_c((float)f6, (float)f6, (float)f6, (float)1.0f);
                } else if (unlockstate == 2) {
                    float f7 = 0.3f;
                    GlStateManager.func_179131_c((float)f7, (float)f7, (float)f7, (float)1.0f);
                } else if (unlockstate == -1) {
                    float f8 = 0.2f;
                    GlStateManager.func_179131_c((float)f8, (float)f8, (float)f8, (float)1.0f);
                }
                this.field_146297_k.func_110434_K().func_110577_a(BACKGROUND);
                GlStateManager.func_179147_l();
                this.func_73729_b(x - 2, y3 - 2, 0, 202, 26, 26);
                GlStateManager.func_179084_k();
                this.field_146297_k.func_110434_K().func_110577_a(this.getIconLoc(skill));
                GlStateManager.func_179140_f();
                GlStateManager.func_179147_l();
                UtilLib.drawTexturedModalRect(this.field_73735_i, x + 3, y3 + 3, skill.getMinU(), skill.getMinV(), 16, 16, 256, 80);
                GlStateManager.func_179140_f();
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                if (mMouseX >= (float)x && mMouseX <= (float)(x + 22) && mMouseY >= (float)y3 && mMouseY <= (float)(y3 + 22)) {
                    newselected = skill;
                }
                if (i + 1 >= elements.length) continue;
                this.func_73732_a(this.field_146289_q, "OR", x + 24 + 12, y3 + 1 + (24 - this.field_146289_q.field_78288_b) / 2, 0xFFFFFF);
            }
        }
        GlStateManager.func_179097_i();
        GlStateManager.func_179147_l();
        GlStateManager.func_179121_F();
        int color = this.skillHandler.getPlayer().getFaction().getColor();
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        GlStateManager.func_179131_c((float)((float)r / 255.0f), (float)((float)g / 255.0f), (float)((float)b / 255.0f), (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(BACKGROUND);
        this.func_73729_b(k, l, 0, 0, this.display_width, this.display_height);
        this.field_73735_i = 0.0f;
        GlStateManager.func_179143_c((int)515);
        GlStateManager.func_179097_i();
        GlStateManager.func_179098_w();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.selected = newselected;
        if (this.selected != null) {
            int height_desc;
            int m2MouseX = mouseX + 12;
            int m2MouseY = mouseY - 4;
            String name = I18n.func_135052_a((String)this.selected.getUnlocalizedName(), (Object[])new Object[0]);
            String desc = this.selected.getLocalizedDescription();
            ISkillHandler.Result result = this.skillHandler.canSkillBeEnabled(this.selected);
            int width_name = Math.max(this.field_146289_q.func_78256_a(name), 110);
            int n = height_desc = desc == null ? 0 : this.field_146289_q.func_78267_b(desc, width_name);
            if (result == ISkillHandler.Result.ALREADY_ENABLED || result == ISkillHandler.Result.PARENT_NOT_ENABLED) {
                height_desc += 12;
            }
            this.func_73733_a(m2MouseX - 3, m2MouseY - 3, m2MouseX + width_name + 3, m2MouseY + height_desc + 3 + 12, -1073741824, -1073741824);
            this.field_146289_q.func_175063_a(name, (float)m2MouseX, (float)m2MouseY, -8355712);
            if (desc != null) {
                this.field_146289_q.func_78279_b(desc, m2MouseX, m2MouseY + 12, width_name, -11513776);
            }
            if (result == ISkillHandler.Result.ALREADY_ENABLED) {
                this.field_146289_q.func_175063_a(I18n.func_135052_a((String)"text.vampirism.skill.unlocked", (Object[])new Object[0]), (float)m2MouseX, (float)(m2MouseY + height_desc + 3), -283136);
            } else if (result == ISkillHandler.Result.PARENT_NOT_ENABLED) {
                this.field_146289_q.func_175063_a(I18n.func_135052_a((String)"text.vampirism.skill.unlock_parent_first", (Object[])new Object[0]), (float)m2MouseX, (float)(m2MouseY + height_desc + 3), -6086104);
            }
        }
        GlStateManager.func_179126_j();
        GlStateManager.func_179145_e();
        RenderHelper.func_74518_a();
    }

    private int findHorizontalNodeCenter(SkillNode node) {
        int width = (node.getElements().length - 1) * 2 * 24;
        return node.getElements()[0].getRenderColumn() * 24 + width / 2;
    }

    private ResourceLocation getIconLoc(ISkill skill) {
        return skill.getIconLoc() == null ? defaultIcons : skill.getIconLoc();
    }

    private TextureAtlasSprite getTexture(IBlockState blockstate) {
        return Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178122_a(blockstate);
    }

    private TextureAtlasSprite getTexture(Block block) {
        return this.getTexture(block.func_176223_P());
    }

    private void playSoundEffect(SoundEvent event, float pitch) {
        this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)event, (float)1.0f));
    }
}

