/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.gui;

import de.teamlapen.lib.lib.client.gui.ExtendedGui;
import de.teamlapen.lib.lib.util.FluidLib;
import de.teamlapen.vampirism.api.entity.IBiteableEntity;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.entity.player.vampire.IVampirePlayer;
import de.teamlapen.vampirism.config.Configs;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.core.ModFluids;
import de.teamlapen.vampirism.core.ModPotions;
import de.teamlapen.vampirism.entity.ExtendedCreature;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.player.hunter.HunterPlayer;
import de.teamlapen.vampirism.player.vampire.BloodStats;
import de.teamlapen.vampirism.player.vampire.VampirePlayer;
import de.teamlapen.vampirism.player.vampire.actions.VampireActions;
import de.teamlapen.vampirism.util.Helper;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.client.GuiIngameForge;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class VampirismHUDOverlay
extends ExtendedGui {
    private final Minecraft mc;
    private final ResourceLocation icons = new ResourceLocation("vampirism:textures/gui/icons.png");
    private int screenColor = 0;
    private int screenPercentage = 0;
    private boolean fullScreen = false;
    private int renderFullTick = 0;
    private int rederFullOn;
    private int renderFullOff;
    private int renderFullColor;

    public VampirismHUDOverlay(Minecraft mc) {
        this.mc = mc;
    }

    public void makeRenderFullColor(int on, int off, int color) {
        this.rederFullOn = on;
        this.renderFullOff = off;
        this.renderFullTick = on + off;
        if ((color >> 24 & 0xFF) == 0) {
            color |= 0xFF000000;
        }
        this.renderFullColor = color;
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (this.mc.field_71439_g == null) {
            return;
        }
        if (event.phase == TickEvent.Phase.END) {
            return;
        }
        IFactionPlayer player = FactionPlayerHandler.get((EntityPlayer)this.mc.field_71439_g).getCurrentFactionPlayer();
        if (player != null && player instanceof IVampirePlayer) {
            if (((IVampirePlayer)player).getActionHandler().isActionActive(VampireActions.rageAction)) {
                this.screenPercentage = 100;
                this.screenColor = -1048576;
                this.fullScreen = false;
            } else {
                this.screenPercentage = ((IVampirePlayer)player).getTicksInSun();
                if (this.screenPercentage > 0) {
                    PotionEffect effect = this.mc.field_71439_g.func_70660_b(ModPotions.sunscreen);
                    if (effect == null || effect.func_76458_c() < 5) {
                        this.screenColor = -6400;
                        this.fullScreen = false;
                        if (player.getRepresentingPlayer().field_71075_bZ.field_75098_d) {
                            this.screenPercentage = Math.min(20, this.screenPercentage);
                        }
                    } else {
                        this.screenPercentage = 0;
                    }
                }
            }
        } else if (player != null && player instanceof HunterPlayer && ((HunterPlayer)player).getSpecialAttributes().isDisguised()) {
            this.screenPercentage = (int)(100.0f * ((HunterPlayer)player).getSpecialAttributes().getDisguiseProgress());
            this.screenColor = -15658735;
            this.fullScreen = false;
        } else {
            this.screenPercentage = 0;
        }
        if (this.renderFullTick > 0) {
            this.screenColor = this.renderFullColor;
            this.fullScreen = true;
            this.screenPercentage = this.renderFullTick > this.renderFullOff ? (int)(100.0f * (1.0f - (float)(this.renderFullTick - this.renderFullOff) / (float)this.rederFullOn)) : (int)((float)(100 * this.renderFullTick) / (float)this.renderFullOff);
            --this.renderFullTick;
        }
    }

    @SubscribeEvent
    public void onRenderCrosshair(RenderGameOverlayEvent.Pre event) {
        TileEntity tile;
        VampirePlayer player;
        IBlockState block;
        if (event.getType() != RenderGameOverlayEvent.ElementType.CROSSHAIRS) {
            return;
        }
        RayTraceResult p = Minecraft.func_71410_x().field_71476_x;
        if (p != null && p.field_72313_a == RayTraceResult.Type.ENTITY && p.field_72308_g != null) {
            VampirePlayer player2 = VampirePlayer.get((EntityPlayer)this.mc.field_71439_g);
            if (player2.getLevel() > 0 && !this.mc.field_71439_g.func_175149_v()) {
                Entity entity = p.field_72308_g;
                IBiteableEntity biteable = null;
                float perc = 1.0f;
                if (entity instanceof IBiteableEntity) {
                    biteable = (IBiteableEntity)entity;
                } else if (entity instanceof EntityCreature) {
                    biteable = ExtendedCreature.get((EntityCreature)entity);
                    perc = ((ExtendedCreature)biteable).getBloodLevelRelative();
                } else if (entity instanceof EntityPlayer) {
                    biteable = VampirePlayer.get((EntityPlayer)entity);
                    perc = ((VampirePlayer)biteable).getBloodLevelRelative();
                }
                if (biteable != null && biteable.canBeBitten(player2)) {
                    this.renderBloodFangs(event.getResolution().func_78326_a(), event.getResolution().func_78328_b(), MathHelper.func_76131_a((float)perc, (float)0.2f, (float)1.0f));
                    event.setCanceled(true);
                }
            }
        } else if (p != null && p.field_72313_a == RayTraceResult.Type.BLOCK && ((Object)((Object)ModBlocks.bloodContainer)).equals((block = Minecraft.func_71410_x().field_71441_e.func_180495_p(p.func_178782_a())).func_177230_c()) && (player = VampirePlayer.get((EntityPlayer)this.mc.field_71439_g)).wantsBlood() && (tile = Minecraft.func_71410_x().field_71441_e.func_175625_s(p.func_178782_a())) != null && tile.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null) && FluidLib.getFluidAmount((IFluidHandler)tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null), ModFluids.blood) > 0) {
            this.renderBloodFangs(event.getResolution().func_78326_a(), event.getResolution().func_78328_b(), 1.0f);
            event.setCanceled(true);
        }
    }

    private void renderBloodFangs(int width, int height, float perc) {
        this.mc.func_110434_K().func_110577_a(this.icons);
        int left = width / 2 - 8;
        int top = height / 2 - 4;
        GL11.glEnable((int)3042);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.7f);
        this.func_73729_b(left, top, 27, 0, 16, 10);
        GL11.glColor4f((float)1.0f, (float)0.0f, (float)0.0f, (float)0.8f);
        int percHeight = (int)(10.0f * perc);
        this.func_73729_b(left, top + (10 - percHeight), 27, 10 - percHeight, 16, percHeight);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)3042);
    }

    @SubscribeEvent
    public void onRenderExperienceBar(RenderGameOverlayEvent.Post event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.EXPERIENCE) {
            return;
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)2896);
        IPlayableFaction faction = FactionPlayerHandler.get((EntityPlayer)this.mc.field_71439_g).getCurrentFaction();
        if (this.mc.field_71442_b.func_78763_f() && faction != null && faction.renderLevel()) {
            int color = faction.getColor();
            String text = "" + FactionPlayerHandler.get((EntityPlayer)this.mc.field_71439_g).getCurrentLevel();
            int x = (event.getResolution().func_78326_a() - this.mc.field_71466_p.func_78256_a(text)) / 2 + Configs.gui_level_offset_x;
            int y = event.getResolution().func_78328_b() - Configs.gui_level_offset_y;
            this.mc.field_71466_p.func_78276_b(text, x + 1, y, 0);
            this.mc.field_71466_p.func_78276_b(text, x - 1, y, 0);
            this.mc.field_71466_p.func_78276_b(text, x, y + 1, 0);
            this.mc.field_71466_p.func_78276_b(text, x, y - 1, 0);
            this.mc.field_71466_p.func_78276_b(text, x, y, color);
        }
    }

    @SubscribeEvent
    public void onRenderFoodBar(RenderGameOverlayEvent.Pre event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.FOOD) {
            return;
        }
        if (Helper.isVampire((Entity)this.mc.field_71439_g)) {
            event.setCanceled(true);
            if (this.mc.field_71442_b.func_78763_f()) {
                BloodStats stats = VampirePlayer.get((EntityPlayer)this.mc.field_71439_g).getBloodStats();
                GlStateManager.func_179147_l();
                this.mc.func_110434_K().func_110577_a(this.icons);
                int left = event.getResolution().func_78326_a() / 2 + 91;
                int top = event.getResolution().func_78328_b() - GuiIngameForge.right_height;
                GuiIngameForge.right_height += 10;
                for (int i = 0; i < 10; ++i) {
                    int idx = i * 2 + 1;
                    int x = left - i * 8 - 9;
                    this.func_73729_b(x, top, 0, 0, 9, 9);
                    if (idx < stats.getBloodLevel()) {
                        this.func_73729_b(x, top, 9, 0, 9, 9);
                        continue;
                    }
                    if (idx != stats.getBloodLevel()) continue;
                    this.func_73729_b(x, top, 18, 0, 9, 9);
                }
                this.mc.func_110434_K().func_110577_a(Gui.field_110324_m);
                GlStateManager.func_179084_k();
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onRenderWorldLast(RenderWorldLastEvent event) {
        if (this.screenPercentage > 0 && !Configs.disable_screen_overlay) {
            ScaledResolution scaledresolution = new ScaledResolution(this.mc);
            GlStateManager.func_179086_m((int)256);
            GlStateManager.func_179128_n((int)5889);
            GlStateManager.func_179096_D();
            GlStateManager.func_179130_a((double)0.0, (double)scaledresolution.func_78327_c(), (double)scaledresolution.func_78324_d(), (double)0.0, (double)1.0, (double)-1.0);
            GlStateManager.func_179128_n((int)5888);
            GlStateManager.func_179096_D();
            GlStateManager.func_179094_E();
            GL11.glDisable((int)2929);
            int w = scaledresolution.func_78326_a();
            int h = scaledresolution.func_78328_b();
            if (this.fullScreen) {
                float r = (float)(this.screenColor >> 16 & 0xFF) / 255.0f;
                float g = (float)(this.screenColor >> 8 & 0xFF) / 255.0f;
                float b = (float)(this.screenColor & 0xFF) / 255.0f;
                float a = (float)this.screenPercentage / 100.0f * (float)(this.screenColor >> 24 & 0xFF) / 255.0f;
                GlStateManager.func_179090_x();
                GlStateManager.func_179147_l();
                GlStateManager.func_179118_c();
                GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
                GlStateManager.func_179103_j((int)7425);
                Tessellator tessellator = Tessellator.func_178181_a();
                VertexBuffer worldrenderer = tessellator.func_178180_c();
                worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
                worldrenderer.func_181662_b(0.0, (double)h, (double)this.field_73735_i).func_181666_a(r, g, b, a).func_181675_d();
                worldrenderer.func_181662_b((double)w, (double)h, (double)this.field_73735_i).func_181666_a(r, g, b, a).func_181675_d();
                worldrenderer.func_181662_b((double)w, 0.0, (double)this.field_73735_i).func_181666_a(r, g, b, a).func_181675_d();
                worldrenderer.func_181662_b(0.0, 0.0, (double)this.field_73735_i).func_181666_a(r, g, b, a).func_181675_d();
                tessellator.func_78381_a();
                GlStateManager.func_179103_j((int)7424);
                GlStateManager.func_179084_k();
                GlStateManager.func_179141_d();
                GlStateManager.func_179098_w();
            } else {
                int bw = 0;
                int bh = 0;
                bh = Math.round((float)h / 4.0f * (float)this.screenPercentage / 100.0f);
                bw = Math.round((float)w / 8.0f * (float)this.screenPercentage / 100.0f);
                this.func_73733_a(0, 0, w, bh, this.screenColor, 0);
                this.func_73733_a(0, h - bh, w, h, 0, this.screenColor);
                this.drawGradientRect2(0, 0, bw, h, 0, this.screenColor);
                this.drawGradientRect2(w - bw, 0, w, h, this.screenColor, 0);
            }
            GL11.glEnable((int)2929);
            GlStateManager.func_179121_F();
        }
    }
}

