/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.render;

import de.teamlapen.vampirism.config.Configs;
import de.teamlapen.vampirism.player.vampire.VampirePlayer;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class LayerVampirePlayerHead
implements LayerRenderer<AbstractClientPlayer> {
    private final RenderPlayer playerRenderer;
    private final ResourceLocation[] eyeOverlays;
    private final ResourceLocation[] fangOverlays;

    public LayerVampirePlayerHead(RenderPlayer playerRendererIn) {
        int i;
        this.playerRenderer = playerRendererIn;
        this.eyeOverlays = new ResourceLocation[7];
        for (i = 0; i < this.eyeOverlays.length; ++i) {
            this.eyeOverlays[i] = new ResourceLocation("vampirism:textures/entity/vanilla/eyes" + i + ".png");
        }
        this.fangOverlays = new ResourceLocation[6];
        for (i = 0; i < this.fangOverlays.length; ++i) {
            this.fangOverlays[i] = new ResourceLocation("vampirism:textures/entity/vanilla/fangs" + i + ".png");
        }
    }

    public void doRenderLayer(AbstractClientPlayer player, float p_177141_2_, float p_177141_3_, float partialTicks, float p_177141_5_, float p_177141_6_, float p_177141_7_, float scale) {
        if (Configs.disable_vampireEyes) {
            return;
        }
        VampirePlayer vampirePlayer = VampirePlayer.get((EntityPlayer)player);
        if (vampirePlayer.getLevel() > 0 && !vampirePlayer.isDisguised() && !player.func_82150_aj()) {
            int eyeType = Math.max(0, Math.min(vampirePlayer.getEyeType(), this.eyeOverlays.length - 1));
            int fangType = Math.max(0, Math.min(vampirePlayer.getFangType(), this.fangOverlays.length - 1));
            GlStateManager.func_179094_E();
            if (player.func_70093_af()) {
                GlStateManager.func_179109_b((float)0.0f, (float)0.2f, (float)0.0f);
            }
            this.playerRenderer.func_110776_a(this.fangOverlays[fangType]);
            this.playerRenderer.func_177087_b().field_78116_c.func_78785_a(scale);
            this.renderNormalEyes(eyeType, scale);
            GlStateManager.func_179121_F();
        }
    }

    public boolean func_177142_b() {
        return true;
    }

    private void renderGlowingEyes(EntityPlayer player, int eyeType, float partialTicks, float scale) {
        this.playerRenderer.func_110776_a(this.eyeOverlays[eyeType]);
        GlStateManager.func_179147_l();
        GlStateManager.func_179118_c();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        if (player.func_82150_aj()) {
            GlStateManager.func_179132_a((boolean)false);
        } else {
            GlStateManager.func_179132_a((boolean)true);
        }
        int i = 61680;
        int j = i % 65536;
        int k = i / 65536;
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)j, (float)k);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.playerRenderer.func_177087_b().field_78116_c.func_78785_a(scale);
        i = player.func_70070_b(partialTicks);
        j = i % 65536;
        k = i / 65536;
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)j, (float)k);
        GlStateManager.func_179084_k();
        GlStateManager.func_179141_d();
    }

    private void renderNormalEyes(int eyeType, float scale) {
        this.playerRenderer.func_110776_a(this.eyeOverlays[eyeType]);
        this.playerRenderer.func_177087_b().field_78116_c.func_78785_a(scale);
    }
}

