/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.render.tiles;

import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.blocks.BlockCoffin;
import de.teamlapen.vampirism.client.model.ModelCoffin;
import de.teamlapen.vampirism.client.render.tiles.VampirismTESR;
import de.teamlapen.vampirism.tileentity.TileCoffin;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class CoffinTESR
extends VampirismTESR<TileCoffin> {
    public static final String[] colors = new String[]{"black", "red", "green", "brown", "blue", "purple", "cyan", "silver", "gray", "pink", "lime", "yellow", "lightBlue", "magenta", "orange", "white"};
    private final int maxLidPos = 61;
    private ModelCoffin model;
    private ResourceLocation[] textures = new ResourceLocation[16];

    public CoffinTESR() {
        this.model = new ModelCoffin();
        for (int i = 0; i < colors.length; ++i) {
            this.textures[i] = new ResourceLocation("vampirism", "textures/blocks/coffin/coffin_" + colors[i] + ".png");
        }
    }

    public void renderTileEntityAt(TileCoffin te, double x, double y, double z, float partialTicks, int destroyStage) {
        TileCoffin tile = te;
        if (!this.isHeadSafe(te.func_145831_w(), te.func_174877_v())) {
            return;
        }
        boolean occupied = BlockCoffin.isOccupied((IBlockAccess)te.func_145831_w(), te.func_174877_v());
        if (!occupied && tile.lidPos > 0) {
            --tile.lidPos;
        } else if (occupied && tile.lidPos < 61) {
            ++tile.lidPos;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)((float)x + 0.5f), (float)((float)y + 1.5f), (float)((float)z + 0.5f));
        int color = Math.min(tile.color, 15);
        this.func_147499_a(this.textures[color]);
        GlStateManager.func_179094_E();
        this.adjustRotatePivotViaState(te);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        this.model.rotateLid(this.calcLidAngle(tile.lidPos));
        this.model.func_78088_a(null, 0.0f, 0.0f, -0.1f, 0.0f, 0.0f, 0.0625f);
        GlStateManager.func_179121_F();
        GlStateManager.func_179121_F();
    }

    private float calcLidAngle(int pos) {
        if (pos == 61) {
            return 0.0f;
        }
        if (pos == 0) {
            return 2.3561945f;
        }
        return (float)(-Math.pow(1.02, pos) + 1.0 + 2.356194490192345);
    }

    private boolean isHeadSafe(World world, BlockPos pos) {
        try {
            return BlockCoffin.isHead((IBlockAccess)world, pos);
        }
        catch (IllegalArgumentException e) {
            VampirismMod.log.e("CoffinTESR", "Failed to check coffin head at %s caused by wrong blockstate. Block at that pos: %s", pos, world.func_180495_p(pos));
        }
        catch (Exception e) {
            VampirismMod.log.e("CoffinTESR", e, "Failed to check coffin head at %s.", pos);
        }
        return false;
    }
}

