/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.core;

import de.teamlapen.lib.lib.util.IInitListener;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.items.IItemWithTier;
import de.teamlapen.vampirism.config.Configs;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.world.gen.village.VillagePieceModChurch;
import de.teamlapen.vampirism.world.gen.village.VillagePieceTrainer;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.gen.MapGenBase;
import net.minecraft.world.gen.structure.MapGenStructureIO;
import net.minecraft.world.gen.structure.MapGenVillage;
import net.minecraftforge.fml.common.event.FMLStateEvent;
import net.minecraftforge.fml.common.registry.VillagerRegistry;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class ModVillages {
    private static final String TAG = "ModVillages";

    public static void onInitStep(IInitListener.Step step, FMLStateEvent event) {
        switch (step) {
            case INIT: {
                ModVillages.registerCreationHandlers();
                ModVillages.registerPieces();
                ModVillages.registerTrades();
                break;
            }
        }
    }

    private static void registerPieces() {
        MapGenStructureIO.func_143031_a(VillagePieceTrainer.class, (String)"Vampirism-TR");
        MapGenStructureIO.func_143031_a(VillagePieceModChurch.class, (String)"Vampirism-MC");
    }

    private static void registerCreationHandlers() {
        VillagerRegistry.instance().registerVillageCreationHandler((VillagerRegistry.IVillageCreationHandler)new VillagePieceTrainer.CreationHandler());
        VillagerRegistry.instance().registerVillageCreationHandler((VillagerRegistry.IVillageCreationHandler)new VillagePieceModChurch.CreationHandler());
    }

    public static void modifyVillageSize(MapGenBase mapGenVillage) {
        if (mapGenVillage instanceof MapGenVillage) {
            try {
                ReflectionHelper.setPrivateValue(MapGenVillage.class, (Object)((MapGenVillage)mapGenVillage), (Object)Configs.village_size, (String[])new String[]{"size", "field_75054_f"});
            }
            catch (ReflectionHelper.UnableToAccessFieldException e) {
                VampirismMod.log.e(TAG, e, "Could not modify field 'terrainType' in MapGenVillage", new Object[0]);
            }
            try {
                ReflectionHelper.setPrivateValue(MapGenVillage.class, (Object)((MapGenVillage)mapGenVillage), (Object)Configs.village_density, (String[])new String[]{"distance", "field_82665_g"});
            }
            catch (ReflectionHelper.UnableToAccessFieldException e) {
                VampirismMod.log.e(TAG, e, "Could not modify field for village density in MapGenVillage", new Object[0]);
            }
            try {
                ReflectionHelper.setPrivateValue(MapGenVillage.class, (Object)((MapGenVillage)mapGenVillage), (Object)Configs.village_min_dist, (String[])new String[]{"minTownSeparation", "field_82666_h"});
            }
            catch (ReflectionHelper.UnableToAccessFieldException e) {
                VampirismMod.log.e(TAG, e, "Could not modify field for village min dist in MapGenVillage", new Object[0]);
            }
            VampirismMod.log.d(TAG, "Modified MapGenVillage fields.", new Object[0]);
        } else {
            VampirismMod.log.e(TAG, "VillageGen (%s) is not an instance of MapGenVillage, can't modify gen", mapGenVillage);
        }
    }

    private static void registerTrades() {
        VillagerRegistry.VillagerProfession priest = (VillagerRegistry.VillagerProfession)VillagerRegistry.instance().getRegistry().getValue(new ResourceLocation("minecraft", "priest"));
        VillagerRegistry.VillagerCareer hunterPriest = new VillagerRegistry.VillagerCareer(priest, "vampire_hunter");
        hunterPriest.addTrade(1, new EntityVillager.ITradeList[]{new EntityVillager.EmeraldForItems(Items.field_151043_k, new EntityVillager.PriceInfo(8, 10))});
        hunterPriest.addTrade(1, new EntityVillager.ITradeList[]{new EntityVillager.EmeraldForItems((Item)ModItems.vampireFang, new EntityVillager.PriceInfo(20, 30))});
        hunterPriest.addTrade(2, new EntityVillager.ITradeList[]{new EntityVillager.ListItemForEmeralds((Item)ModItems.holyWaterBottle, new EntityVillager.PriceInfo(-8, -2))});
        hunterPriest.addTrade(3, new EntityVillager.ITradeList[]{new EntityVillager.ListItemForEmeralds(ModItems.holyWaterBottle.setTier(new ItemStack((Item)ModItems.holyWaterBottle), IItemWithTier.TIER.ENHANCED), new EntityVillager.PriceInfo(-5, -1))});
        hunterPriest.addTrade(3, new EntityVillager.ITradeList[]{new EntityVillager.ListItemForEmeralds((Item)ModItems.holySalt, new EntityVillager.PriceInfo(-10, -3))});
        hunterPriest.addTrade(4, new EntityVillager.ITradeList[]{new EntityVillager.ListItemForEmeralds(Items.field_151062_by, new EntityVillager.PriceInfo(3, 11))});
    }
}

