/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.core;

import de.teamlapen.lib.lib.util.BasicCommand;
import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.entity.player.actions.IActionHandler;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.api.entity.player.skills.ISkillHandler;
import de.teamlapen.vampirism.api.world.IVampirismVillageProvider;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.entity.hunter.EntityHunterVillager;
import de.teamlapen.vampirism.player.skills.SkillRegistry;
import de.teamlapen.vampirism.player.vampire.VampirePlayer;
import de.teamlapen.vampirism.tests.Tests;
import de.teamlapen.vampirism.tileentity.TileTent;
import de.teamlapen.vampirism.util.VampireBookManager;
import de.teamlapen.vampirism.world.GarlicChunkHandler;
import de.teamlapen.vampirism.world.gen.VampirismWorldGen;
import de.teamlapen.vampirism.world.villages.VampirismVillage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.profiler.Profiler;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class TestCommand
extends BasicCommand {
    public TestCommand() {
        if (VampirismMod.inDev) {
            this.aliases.add("vtest");
        }
        this.addSubcommand((ICommand)new SubCommand(){

            public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
                EntityPlayerMP player = 1.func_71521_c((ICommandSender)sender);
                IVampirismVillageProvider provider = VampirismAPI.getVampirismVillageProvider(player.func_130014_f_());
                VampirismVillage v = (VampirismVillage)provider.getNearestVillage((Entity)player);
                if (v == null) {
                    sender.func_145747_a((ITextComponent)new TextComponentString("No village found"));
                } else {
                    sender.func_145747_a((ITextComponent)new TextComponentString(v.makeDebugString(player.func_180425_c())));
                }
            }

            public String func_71517_b() {
                return "info-village";
            }

            public String func_71518_a(ICommandSender sender) {
                return this.func_71517_b();
            }
        });
        this.addSubcommand((ICommand)new SubCommand(){

            public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
                EntityPlayerMP player = 2.func_71521_c((ICommandSender)sender);
                int entityMonster = player.func_130014_f_().countEntities(EnumCreatureType.MONSTER, false);
                int entityMonsterSpawn = player.func_130014_f_().countEntities(EnumCreatureType.MONSTER, true);
                int entityHunter = player.func_130014_f_().countEntities(VReference.HUNTER_CREATURE_TYPE, false);
                int entityHunterSpawn = player.func_130014_f_().countEntities(VReference.HUNTER_CREATURE_TYPE, true);
                int entityVampire = player.func_130014_f_().countEntities(VReference.VAMPIRE_CREATURE_TYPE, false);
                int entityVampireSpawn = player.func_130014_f_().countEntities(VReference.VAMPIRE_CREATURE_TYPE, true);
                sender.func_145747_a((ITextComponent)new TextComponentString(String.format("Monster: %s (%s), Hunter: %s (%s), Vampire: %s (%s)", entityMonster, entityMonsterSpawn, entityHunter, entityHunterSpawn, entityVampire, entityVampireSpawn)));
            }

            public String func_71517_b() {
                return "info-entity";
            }

            public String func_71518_a(ICommandSender sender) {
                return this.func_71517_b();
            }
        });
        this.addSubcommand((ICommand)new SubCommand(){

            public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
                VampirismMod.log.t("************************************************************", new Object[0]);
                VampirismMod.log.t("", new Object[0]);
                VampirismMod.log.t("Marker %s", new Object[0]);
                if (args.length > 0) {
                    VampirismMod.log.t(3.func_71527_a((Object[])args), new Object[0]);
                }
                VampirismMod.log.t("", new Object[0]);
                VampirismMod.log.t("***********************************************************", new Object[0]);
            }

            public String func_71517_b() {
                return "marker";
            }

            public String func_71518_a(ICommandSender sender) {
                return this.func_71517_b();
            }
        });
        this.addSubcommand((ICommand)new SubCommand(){

            public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) {
                sender.func_145747_a((ITextComponent)new TextComponentString("Tick"));
                this.print(sender, "tick");
                sender.func_145747_a((ITextComponent)new TextComponentString("Garlic"));
                this.print(sender, "vampirism_checkGarlic");
            }

            public String func_71517_b() {
                return "garlic_profiler";
            }

            public String func_71518_a(ICommandSender sender) {
                return this.func_71517_b();
            }

            private void print(ICommandSender var1, String id) {
                List l = FMLCommonHandler.instance().getMinecraftServerInstance().field_71304_b.func_76321_b(id);
                for (Profiler.Result r : l) {
                    var1.func_145747_a((ITextComponent)new TextComponentString("" + r.field_76331_c + ": " + r.field_76332_a + "|" + r.field_76330_b));
                }
            }
        });
        this.addSubcommand((ICommand)new SubCommand(){

            public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
                IFactionPlayer factionPlayer = FactionPlayerHandler.get((EntityPlayer)5.func_71521_c((ICommandSender)sender)).getCurrentFactionPlayer();
                if (factionPlayer == null) {
                    sender.func_145747_a((ITextComponent)new TextComponentString("You have to be in a faction"));
                    return;
                }
                if (args.length == 0) {
                    throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
                }
                if ("list".equals(args[0])) {
                    ((SkillRegistry)VampirismAPI.skillRegistry()).printSkills(factionPlayer.getFaction(), sender);
                    return;
                }
                if ("disableall".equals(args[0])) {
                    factionPlayer.getSkillHandler().resetSkills();
                    return;
                }
                ISkill skill = VampirismAPI.skillRegistry().getSkill(factionPlayer.getFaction(), args[0]);
                if (skill == null) {
                    sender.func_145747_a((ITextComponent)new TextComponentString("Skill with id " + args[0] + " could not be found for faction " + factionPlayer.getFaction().name()));
                    return;
                }
                if (factionPlayer.getSkillHandler().isSkillEnabled(skill)) {
                    factionPlayer.getSkillHandler().disableSkill(skill);
                    sender.func_145747_a((ITextComponent)new TextComponentString("Disabled skill"));
                    return;
                }
                ISkillHandler.Result result = factionPlayer.getSkillHandler().canSkillBeEnabled(skill);
                if (result == ISkillHandler.Result.OK) {
                    factionPlayer.getSkillHandler().enableSkill(skill);
                    sender.func_145747_a((ITextComponent)new TextComponentString("Enabled skill"));
                } else {
                    sender.func_145747_a((ITextComponent)new TextComponentString("Could not enable skill " + (Object)((Object)result)));
                }
            }

            public String func_71517_b() {
                return "skill";
            }

            public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos pos) {
                return sender instanceof EntityPlayer ? (args.length == 1 ? 5.func_175762_a((String[])args, this.getOptions((EntityPlayer)sender)) : this.getOptions((EntityPlayer)sender)) : Collections.emptyList();
            }

            public String func_71518_a(ICommandSender sender) {
                return this.func_71517_b() + " <skillname>";
            }

            private List<String> getOptions(EntityPlayer sender) {
                ArrayList<String> list = new ArrayList<String>();
                list.add("list");
                list.add("disableall");
                IFactionPlayer factionPlayer = FactionPlayerHandler.get(sender).getCurrentFactionPlayer();
                ((SkillRegistry)VampirismAPI.skillRegistry()).addSkills(factionPlayer.getFaction(), list);
                return list;
            }
        });
        this.addSubcommand((ICommand)new SubCommand(){

            public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
                VampirePlayer player = VampirePlayer.get((EntityPlayer)6.func_71521_c((ICommandSender)sender));
                if (player.getLevel() > 0) {
                    player.getBloodStats().setBloodLevel(0);
                }
            }

            public String func_71517_b() {
                return "emptyBloodBar";
            }

            public String func_71518_a(ICommandSender sender) {
                return this.func_71517_b();
            }
        });
        this.addSubcommand((ICommand)new SubCommand(){

            public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
                EntityPlayerMP player = 7.func_71521_c((ICommandSender)sender);
                List l = player.func_130014_f_().func_72839_b((Entity)player, player.func_174813_aQ().func_72314_b(3.0, 2.0, 3.0));
                for (Object o : l) {
                    if (o instanceof EntityCreature) {
                        String s = EntityList.func_75621_b((Entity)((Entity)o));
                        sender.func_145747_a((ITextComponent)new TextComponentString(s));
                        continue;
                    }
                    sender.func_145747_a((ITextComponent)new TextComponentString("Not biteable " + o.getClass().getName()));
                }
            }

            public String func_71517_b() {
                return "entity";
            }

            @Override
            public int func_82362_a() {
                return 0;
            }

            public String func_71518_a(ICommandSender sender) {
                return this.func_71517_b();
            }
        });
        this.addSubcommand((ICommand)new SubCommand(){

            public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
                EntityPlayerMP player = 8.func_71521_c((ICommandSender)sender);
                ResourceLocation res = player.func_130014_f_().func_180494_b(player.func_180425_c()).getRegistryName();
                sender.func_145747_a((ITextComponent)new TextComponentString(res.toString()));
            }

            public String func_71517_b() {
                return "biome";
            }

            @Override
            public int func_82362_a() {
                return 0;
            }

            public String func_71518_a(ICommandSender sender) {
                return this.func_71517_b();
            }
        });
        this.addSubcommand((ICommand)new SubCommand(){

            public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
                EntityPlayerMP player = 9.func_71521_c((ICommandSender)sender);
                List l = player.func_130014_f_().func_72872_a(EntityVillager.class, player.func_174813_aQ().func_72314_b(3.0, 2.0, 3.0));
                for (EntityVillager v : l) {
                    EntityHunterVillager hunter = EntityHunterVillager.makeHunter(v);
                    v.func_70106_y();
                    v.func_130014_f_().func_72838_d((Entity)hunter);
                }
            }

            public String func_71517_b() {
                return "makeVillagerAgressive";
            }

            public String func_71518_a(ICommandSender sender) {
                return this.func_71517_b();
            }
        });
        this.addSubcommand((ICommand)new SubCommand(){

            public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
                IActionHandler handler;
                EntityPlayerMP player = 10.func_71521_c((ICommandSender)sender);
                IFactionPlayer factionPlayer = FactionPlayerHandler.get((EntityPlayer)player).getCurrentFactionPlayer();
                if (factionPlayer != null && (handler = factionPlayer.getActionHandler()) != null) {
                    handler.resetTimers();
                    sender.func_145747_a((ITextComponent)new TextComponentString("Reset Timers"));
                }
            }

            public String func_71517_b() {
                return "resetActions";
            }

            public String func_71518_a(ICommandSender sender) {
                return this.func_71517_b();
            }
        });
        this.addSubcommand((ICommand)new SubCommand(){

            public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
                TileEntity tent;
                EntityPlayerMP player = 11.func_71521_c((ICommandSender)sender);
                RayTraceResult result = UtilLib.getPlayerLookingSpot((EntityPlayer)player, 5.0);
                if (result != null && result.field_72313_a == RayTraceResult.Type.BLOCK && (tent = player.func_130014_f_().func_175625_s(result.func_178782_a())) != null && tent instanceof TileTent) {
                    ((TileTent)tent).setSpawn(true);
                    sender.func_145747_a((ITextComponent)new TextComponentString("Success"));
                }
            }

            public String func_71517_b() {
                return "tent";
            }

            public String func_71518_a(ICommandSender sender) {
                return this.func_71517_b();
            }
        });
        this.addSubcommand((ICommand)new SubCommand(){

            public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
                EntityPlayerMP player = 12.func_71521_c((ICommandSender)sender);
                player.field_71071_by.func_70441_a(VampireBookManager.getInstance().getRandomBook(player.func_70681_au()));
            }

            public String func_71517_b() {
                return "vampireBook";
            }

            @Override
            public int func_82362_a() {
                return 2;
            }

            public String func_71518_a(ICommandSender sender) {
                return this.func_71517_b();
            }
        });
        this.addSubcommand((ICommand)new SubCommand(){

            public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
                if (VampirismWorldGen.debug) {
                    VampirismWorldGen.debug = false;
                    13.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"command.vampirism.test.gen_debug.false", (Object[])new Object[0]);
                } else {
                    VampirismWorldGen.debug = true;
                    13.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"command.vampirism.test.gen_debug.true", (Object[])new Object[0]);
                }
            }

            public String func_71517_b() {
                return "debugGen";
            }

            public String func_71518_a(ICommandSender sender) {
                return this.func_71517_b();
            }
        });
        this.addSubcommand((ICommand)new SubCommand(){

            public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
                EntityPlayerMP p = 14.func_71521_c((ICommandSender)sender);
                Tests.runTests(p.func_130014_f_(), (EntityPlayer)p);
            }

            public String func_71517_b() {
                return "runTests";
            }

            public String func_71518_a(ICommandSender sender) {
                return this.func_71517_b();
            }
        });
        this.addSubcommand((ICommand)new SubCommand(){

            public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
                if (sender instanceof EntityPlayer) {
                    sender.func_145747_a((ITextComponent)new TextComponentString("Garlic strength: " + (Object)((Object)VampirismAPI.getGarlicChunkHandler(sender.func_130014_f_()).getStrengthAtChunk(new ChunkPos(sender.func_180425_c())))));
                }
                if (args != null && args.length > 0 && "print".equals(args[0])) {
                    ((GarlicChunkHandler)VampirismAPI.getGarlicChunkHandler(sender.func_130014_f_())).printDebug(sender);
                }
            }

            public String func_71517_b() {
                return "garlicCheck";
            }

            @Override
            public int func_82362_a() {
                return 2;
            }

            public String func_71518_a(ICommandSender sender) {
                return this.func_71517_b() + "(print)";
            }
        });
    }

    public String func_71517_b() {
        return "vampirism-test";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/" + this.func_71517_b() + " <sub>";
    }

    public static abstract class SubCommand
    extends CommandBase {
        private SubCommand() {
        }

        public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
            return VampirismMod.inDev || super.func_184882_a(server, sender);
        }

        public int func_82362_a() {
            return 3;
        }
    }
}

