/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity;

import com.google.common.base.Optional;
import de.teamlapen.lib.lib.util.ItemStackUtil;
import de.teamlapen.vampirism.VampirismMod;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public class EntityThrowableItem
extends EntityThrowable {
    private static final DataParameter<Optional<ItemStack>> ITEM = EntityDataManager.func_187226_a(EntityThrowableItem.class, (DataSerializer)DataSerializers.field_187196_f);

    public EntityThrowableItem(World worldIn) {
        super(worldIn);
    }

    public EntityThrowableItem(World worldIn, EntityLivingBase thrower) {
        super(worldIn, thrower);
    }

    @Nullable
    public ItemStack getItem() {
        return (ItemStack)((Optional)this.func_184212_Q().func_187225_a(ITEM)).orNull();
    }

    public void setItem(@Nullable ItemStack stack) {
        if (!ItemStackUtil.isEmpty(stack) && !(stack.func_77973_b() instanceof IVampirismThrowableItem)) {
            throw new IllegalArgumentException("EntityThrowable only accepts IVampirismThrowableItem, but not " + stack);
        }
        this.func_184212_Q().func_187227_b(ITEM, (Object)Optional.fromNullable((Object)stack));
        this.func_184212_Q().func_187217_b(ITEM);
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        ItemStack stack = ItemStackUtil.loadFromNBT(compound.func_74775_l("thrownItem"));
        if (ItemStackUtil.isEmpty(stack)) {
            this.func_70106_y();
        } else {
            this.setItem(stack);
        }
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        ItemStack stack = this.getItem();
        if (!ItemStackUtil.isEmpty(stack)) {
            compound.func_74782_a("thrownItem", (NBTBase)stack.func_77955_b(new NBTTagCompound()));
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(ITEM, (Object)Optional.absent());
    }

    protected float func_70185_h() {
        return 0.05f;
    }

    protected void func_70184_a(RayTraceResult result) {
        ItemStack stack = this.getItem();
        if (!ItemStackUtil.isEmpty(stack)) {
            Item item = stack.func_77973_b();
            if (item instanceof IVampirismThrowableItem) {
                ((IVampirismThrowableItem)item).onImpact(this, stack, result, this.field_70170_p.field_72995_K);
            } else {
                VampirismMod.log.w("EntityThrowableItem", "Saved item (%s) is not an instance of IVampirismThrowableItem. This should not be able to happen", stack);
            }
        }
        if (!this.field_70170_p.field_72995_K) {
            this.func_70106_y();
        }
    }

    public static interface IVampirismThrowableItem {
        public void onImpact(EntityThrowableItem var1, ItemStack var2, RayTraceResult var3, boolean var4);
    }
}

