/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.converted;

import de.teamlapen.lib.lib.network.ISyncable;
import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.convertible.IConvertedCreature;
import de.teamlapen.vampirism.api.entity.convertible.IConvertingHandler;
import de.teamlapen.vampirism.entity.ai.EntityAIAttackMeleeNoSun;
import de.teamlapen.vampirism.entity.converted.DefaultConvertingHandler;
import de.teamlapen.vampirism.entity.vampire.EntityVampireBase;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIRestrictSun;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class EntityConvertedCreature<T extends EntityCreature>
extends EntityVampireBase
implements IConvertedCreature<T>,
ISyncable {
    private static final String TAG = "ConvCreature";
    private T entityCreature;
    private boolean entityChanged = false;
    private boolean canDespawn = false;

    public EntityConvertedCreature(World world) {
        super(world, false);
    }

    public String func_70005_c_() {
        return UtilLib.translate("entity.vampirism.vampire.name") + " " + (this.nil() ? super.func_70005_c_() : this.entityCreature.func_70005_c_());
    }

    public T getOldCreature() {
        return this.entityCreature;
    }

    @Override
    public boolean isCreatureType(EnumCreatureType type, boolean forSpawnCount) {
        if (forSpawnCount && type == EnumCreatureType.CREATURE) {
            return true;
        }
        return super.isCreatureType(type, forSpawnCount);
    }

    @Override
    public void loadUpdateFromNBT(NBTTagCompound nbt) {
        if (nbt.func_74764_b("entity_old")) {
            this.setEntityCreature((EntityCreature)EntityList.func_75615_a((NBTTagCompound)nbt.func_74775_l("entity_old"), (World)this.func_130014_f_()));
        }
    }

    public void func_70030_z() {
        super.func_70030_z();
        if (!this.nil()) {
            this.entityCreature.func_82149_j((Entity)this);
            ((EntityCreature)this.entityCreature).field_70166_s = this.field_70166_s;
            ((EntityCreature)this.entityCreature).field_70167_r = this.field_70167_r;
            ((EntityCreature)this.entityCreature).field_70169_q = this.field_70169_q;
            ((EntityCreature)this.entityCreature).field_70759_as = this.field_70759_as;
            ((EntityCreature)this.entityCreature).field_70127_C = this.field_70127_C;
            ((EntityCreature)this.entityCreature).field_70126_B = this.field_70126_B;
            ((EntityCreature)this.entityCreature).field_70758_at = this.field_70758_at;
            ((EntityCreature)this.entityCreature).field_70159_w = this.field_70159_w;
            ((EntityCreature)this.entityCreature).field_70181_x = this.field_70181_x;
            ((EntityCreature)this.entityCreature).field_70179_y = this.field_70179_y;
            ((EntityCreature)this.entityCreature).field_70142_S = this.field_70142_S;
            ((EntityCreature)this.entityCreature).field_70137_T = this.field_70137_T;
            ((EntityCreature)this.entityCreature).field_70136_U = this.field_70136_U;
            ((EntityCreature)this.entityCreature).field_70737_aN = this.field_70737_aN;
            ((EntityCreature)this.entityCreature).field_70738_aO = this.field_70738_aO;
            ((EntityCreature)this.entityCreature).field_70739_aP = this.field_70739_aP;
            ((EntityCreature)this.entityCreature).field_70733_aJ = this.field_70733_aJ;
            ((EntityCreature)this.entityCreature).field_70732_aI = this.field_70732_aI;
            ((EntityCreature)this.entityCreature).field_184618_aE = this.field_184618_aE;
            ((EntityCreature)this.entityCreature).field_70721_aZ = this.field_70721_aZ;
            ((EntityCreature)this.entityCreature).field_184619_aG = this.field_184619_aG;
            ((EntityCreature)this.entityCreature).field_70761_aq = this.field_70761_aq;
            ((EntityCreature)this.entityCreature).field_70760_ar = this.field_70760_ar;
            ((EntityCreature)this.entityCreature).field_70725_aQ = this.field_70725_aQ;
            if (this.field_70170_p.field_72995_K) {
                ((EntityCreature)this.entityCreature).field_70118_ct = this.field_70118_ct;
                ((EntityCreature)this.entityCreature).field_70117_cu = this.field_70117_cu;
                ((EntityCreature)this.entityCreature).field_70116_cv = this.field_70116_cv;
            }
        }
        if (this.entityChanged) {
            this.updateEntityAttributes();
            this.entityChanged = false;
        }
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && this.entityCreature == null) {
            VampirismMod.log.d(TAG, "Setting dead, since creature is null", new Object[0]);
            this.func_70106_y();
        }
    }

    public void func_70642_aH() {
        if (!this.nil()) {
            this.entityCreature.func_70642_aH();
        }
    }

    @Override
    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        if (nbt.func_74764_b("entity_old")) {
            this.setEntityCreature((EntityCreature)EntityList.func_75615_a((NBTTagCompound)nbt.func_74775_l("entity_old"), (World)this.field_70170_p));
            if (this.nil()) {
                VampirismMod.log.w(TAG, "Failed to create old entity %s. Maybe the entity does not exist anymore", nbt.func_74775_l("entity_old"));
            }
        } else {
            VampirismMod.log.w(TAG, "Saved entity did not have a old entity", new Object[0]);
        }
        if (nbt.func_74764_b("converted_canDespawn")) {
            this.canDespawn = nbt.func_74767_n("converted_canDespawn");
        }
    }

    public void setCanDespawn() {
        this.canDespawn = true;
    }

    public void setEntityCreature(T creature) {
        if (creature == null && this.entityCreature != null) {
            this.entityChanged = true;
            this.entityCreature = null;
        } else if (creature != null && !creature.equals(this.entityCreature)) {
            this.entityCreature = creature;
            this.entityChanged = true;
            this.func_70105_a(((EntityCreature)creature).field_70130_N, ((EntityCreature)creature).field_70131_O);
        }
        if (this.entityCreature != null && this.getConvertedHelper() == null) {
            this.entityCreature = null;
            VampirismMod.log.w(TAG, "Cannot find converting handler for converted creature %s (%s)", this, this.entityCreature);
        }
    }

    public String toString() {
        return "[" + super.toString() + " representing " + this.entityCreature + "]";
    }

    @Override
    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        this.writeOldEntityToNBT(nbt);
        nbt.func_74757_a("converter_canDespawn", this.canDespawn);
    }

    @Override
    public void writeFullUpdateToNBT(NBTTagCompound nbt) {
        this.writeOldEntityToNBT(nbt);
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.updateEntityAttributes();
    }

    protected boolean func_70692_ba() {
        return this.canDespawn;
    }

    protected void func_70628_a(boolean p_70628_1_, int p_70628_2_) {
        this.getConvertedHelper().dropConvertedItems(this.entityCreature, p_70628_1_, p_70628_2_);
    }

    protected IConvertingHandler.IDefaultHelper getConvertedHelper() {
        IConvertingHandler handler = VampirismAPI.biteableRegistry().getEntry(this.entityCreature).convertingHandler;
        if (handler instanceof DefaultConvertingHandler) {
            return ((DefaultConvertingHandler)handler).getHelper();
        }
        return null;
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityCreature.class, VampirismAPI.factionRegistry().getPredicate(this.getFaction(), false, true, false, false, VReference.HUNTER_FACTION), 10.0f, 1.0, 1.1));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIRestrictSun((EntityCreature)this));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIAttackMeleeNoSun(this, 0.9, false));
        this.field_70728_aV = 2;
        this.field_70714_bg.func_75776_a(11, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.7));
        this.field_70714_bg.func_75776_a(13, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(15, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 5, true, false, VampirismAPI.factionRegistry().getPredicate(this.getFaction(), true, false, true, false, null)));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityCreature.class, 5, true, false, VampirismAPI.factionRegistry().getPredicate(this.getFaction(), false, true, false, false, null)));
    }

    protected boolean nil() {
        return this.entityCreature == null;
    }

    protected void updateEntityAttributes() {
        if (!this.nil()) {
            IConvertingHandler.IDefaultHelper helper = this.getConvertedHelper();
            this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(helper.getConvertedDMG(this.entityCreature));
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(helper.getConvertedMaxHealth(this.entityCreature));
            this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(helper.getConvertedKnockbackResistance(this.entityCreature));
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(helper.getConvertedSpeed(this.entityCreature));
        } else {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(1000.0);
            this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(0.0);
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.0);
        }
    }

    private void writeOldEntityToNBT(NBTTagCompound nbt) {
        if (!this.nil()) {
            try {
                NBTTagCompound entity = new NBTTagCompound();
                ((EntityCreature)this.entityCreature).field_70128_L = false;
                this.entityCreature.func_70039_c(entity);
                ((EntityCreature)this.entityCreature).field_70128_L = true;
                nbt.func_74782_a("entity_old", (NBTBase)entity);
            }
            catch (Exception e) {
                VampirismMod.log.e(TAG, e, "Failed to write old entity (%s) to NBT. If this happens more often please report this to the mod author.", this.entityCreature);
                this.setEntityCreature(null);
            }
        }
    }
}

