/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.factions;

import de.teamlapen.lib.HelperLib;
import de.teamlapen.lib.lib.network.ISyncable;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.factions.IFactionPlayerHandler;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.event.FactionEvent;
import de.teamlapen.vampirism.config.Configs;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandlerDefaultImpl;
import de.teamlapen.vampirism.util.REFERENCE;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.fml.common.eventhandler.Event;

public class FactionPlayerHandler
implements ISyncable.ISyncableEntityCapabilityInst,
IFactionPlayerHandler {
    @CapabilityInject(value=IFactionPlayerHandler.class)
    public static final Capability<IFactionPlayerHandler> CAP = null;
    private static final String TAG = "FactionPlayerHandler";
    private final EntityPlayer player;
    private IPlayableFaction currentFaction = null;
    private int currentLevel = 0;

    public static FactionPlayerHandler get(EntityPlayer player) {
        return (FactionPlayerHandler)player.getCapability(CAP, null);
    }

    public static void registerCapability() {
        CapabilityManager.INSTANCE.register(IFactionPlayerHandler.class, (Capability.IStorage)new Storage(), FactionPlayerHandlerDefaultImpl.class);
    }

    public static ICapabilityProvider createNewCapability(final EntityPlayer player) {
        return new ICapabilitySerializable<NBTTagCompound>(){
            IFactionPlayerHandler inst;
            {
                this.inst = new FactionPlayerHandler(player);
            }

            public void deserializeNBT(NBTTagCompound nbt) {
                CAP.getStorage().readNBT(CAP, (Object)this.inst, null, (NBTBase)nbt);
            }

            public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
                return (T)(CAP.equals(capability) ? CAP.cast((Object)this.inst) : null);
            }

            public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
                return CAP.equals(capability);
            }

            public NBTTagCompound serializeNBT() {
                return (NBTTagCompound)CAP.getStorage().writeNBT(CAP, (Object)this.inst, null);
            }
        };
    }

    private FactionPlayerHandler(EntityPlayer player) {
        this.player = player;
    }

    @Override
    public boolean canJoin(IPlayableFaction faction) {
        FactionEvent.CanJoinFaction event = new FactionEvent.CanJoinFaction((IFactionPlayerHandler)this, this.currentFaction, faction);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.getResult() == Event.Result.DEFAULT) {
            return this.currentFaction == null;
        }
        return event.getResult() == Event.Result.ALLOW;
    }

    @Override
    public boolean canLeaveFaction() {
        if (this.currentFaction == null) {
            return true;
        }
        return this.currentFaction.getPlayerCapability(this.player).canLeaveFaction();
    }

    public void copyFrom(EntityPlayer old) {
        FactionPlayerHandler oldP = FactionPlayerHandler.get(old);
        this.currentFaction = oldP.currentFaction;
        this.currentLevel = oldP.currentLevel;
        this.notifyFaction(oldP.currentFaction, oldP.currentLevel);
    }

    @Override
    public ResourceLocation getCapKey() {
        return REFERENCE.FACTION_PLAYER_HANDLER_KEY;
    }

    @Override
    public IPlayableFaction getCurrentFaction() {
        return this.currentFaction;
    }

    @Override
    public IFactionPlayer getCurrentFactionPlayer() {
        return this.currentFaction == null ? null : (IFactionPlayer)this.currentFaction.getPlayerCapability(this.player);
    }

    @Override
    public int getCurrentLevel() {
        return this.currentLevel;
    }

    @Override
    public int getCurrentLevel(IPlayableFaction f) {
        return this.isInFaction(f) ? this.currentLevel : 0;
    }

    @Override
    public EntityPlayer getPlayer() {
        return this.player;
    }

    @Override
    public int getTheEntityID() {
        return this.player.func_145782_y();
    }

    @Override
    public boolean isInFaction(@Nullable IPlayableFaction f) {
        return Objects.equals(this.currentFaction, f);
    }

    @Override
    public void joinFaction(@Nonnull IPlayableFaction faction) {
        if (this.canJoin(faction)) {
            this.setFactionAndLevel(faction, 1);
        }
    }

    public void loadNBTData(NBTTagCompound nbt) {
        this.currentFaction = this.getFactionFromKey(new ResourceLocation(nbt.func_74779_i("faction")));
        if (this.currentFaction == null) {
            VampirismMod.log.w(TAG, "Could not find faction %s. Did mods change?", nbt.func_74779_i("faction"));
        } else {
            this.currentLevel = nbt.func_74762_e("level");
            this.notifyFaction(null, 0);
        }
    }

    @Override
    public void loadUpdateFromNBT(NBTTagCompound nbt) {
        IPlayableFaction old = this.currentFaction;
        int oldLevel = this.currentLevel;
        String f = nbt.func_74779_i("faction");
        if ("null".equals(f)) {
            this.currentFaction = null;
            this.currentLevel = 0;
        } else {
            this.currentFaction = this.getFactionFromKey(new ResourceLocation(f));
            if (this.currentFaction == null) {
                VampirismMod.log.e(TAG, "Cannot find faction %s on client. You have to register factions on both sides!", f);
                this.currentLevel = 0;
            } else {
                this.currentLevel = nbt.func_74762_e("level");
            }
        }
        this.notifyFaction(old, oldLevel);
    }

    @Override
    public boolean onEntityAttacked(DamageSource src, float amt) {
        if (Configs.pvp_only_between_factions && src instanceof EntityDamageSource && src.func_76346_g() instanceof EntityPlayer) {
            FactionPlayerHandler other = FactionPlayerHandler.get((EntityPlayer)src.func_76346_g());
            if (this.currentFaction != null && this.currentFaction.equals(other.currentFaction)) {
                return false;
            }
        }
        return true;
    }

    public void saveNBTData(NBTTagCompound nbt) {
        if (this.currentFaction != null) {
            nbt.func_74778_a("faction", this.currentFaction.getKey().toString());
            nbt.func_74768_a("level", this.currentLevel);
        }
    }

    @Override
    public boolean setFactionAndLevel(IPlayableFaction faction, int level) {
        IPlayableFaction old = this.currentFaction;
        int oldLevel = this.currentLevel;
        if (!(this.currentFaction == null || this.currentFaction.equals(faction) && level != 0 || this.currentFaction.getPlayerCapability(this.player).canLeaveFaction())) {
            VampirismMod.log.i(TAG, "You cannot leave faction %s, it is prevented by respective mod", this.currentFaction.getKey());
            return false;
        }
        if (faction != null && (level < 0 || level > faction.getHighestReachableLevel())) {
            VampirismMod.log.w(TAG, "Level %d in faction %s cannot be reached", level, faction.getKey());
            return false;
        }
        FactionEvent.ChangeLevelOrFaction event = new FactionEvent.ChangeLevelOrFaction(this, old, oldLevel, faction, faction == null ? 0 : level);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            VampirismMod.log.d(TAG, "Faction or Level change event canceled", new Object[0]);
            return false;
        }
        if (faction == null) {
            this.currentFaction = null;
            this.currentLevel = 0;
        } else {
            this.currentFaction = faction;
            this.currentLevel = level;
        }
        if (this.currentFaction == null) {
            this.currentLevel = 0;
        } else if (this.currentLevel == 0) {
            this.currentFaction = null;
        }
        this.notifyFaction(old, oldLevel);
        this.sync(!Objects.equals(old, this.currentFaction));
        return true;
    }

    @Override
    public boolean setFactionLevel(@Nonnull IPlayableFaction faction, int level) {
        return faction.equals(this.currentFaction) && this.setFactionAndLevel(faction, level);
    }

    @Override
    public void writeFullUpdateToNBT(NBTTagCompound nbt) {
        nbt.func_74778_a("faction", this.currentFaction == null ? "null" : this.currentFaction.getKey().toString());
        nbt.func_74768_a("level", this.currentLevel);
    }

    private IPlayableFaction getFactionFromKey(ResourceLocation key) {
        for (IPlayableFaction p : VampirismAPI.factionRegistry().getPlayableFactions()) {
            if (!p.getKey().equals((Object)key)) continue;
            return p;
        }
        return null;
    }

    private void notifyFaction(IPlayableFaction oldFaction, int oldLevel) {
        if (oldFaction != null && !oldFaction.equals(this.currentFaction)) {
            VampirismMod.log.d(TAG, "Leaving faction %s", oldFaction.getKey());
            oldFaction.getPlayerCapability(this.player).onLevelChanged(0, oldLevel);
        }
        if (this.currentFaction != null) {
            VampirismMod.log.d(TAG, "Changing to %s %d", this.currentFaction, this.currentLevel);
            this.currentFaction.getPlayerCapability(this.player).onLevelChanged(this.currentLevel, Objects.equals(oldFaction, this.currentFaction) ? oldLevel : 0);
        }
        if (!Objects.equals(this.currentFaction, oldFaction)) {
            this.onChangedFaction();
        }
    }

    private void onChangedFaction() {
        this.player.refreshDisplayName();
    }

    private void sync(boolean all) {
        HelperLib.sync(this, (Entity)this.player, all);
    }

    private static class Storage
    implements Capability.IStorage<IFactionPlayerHandler> {
        private Storage() {
        }

        public void readNBT(Capability<IFactionPlayerHandler> capability, IFactionPlayerHandler instance, EnumFacing side, NBTBase nbt) {
            ((FactionPlayerHandler)instance).loadNBTData((NBTTagCompound)nbt);
        }

        public NBTBase writeNBT(Capability<IFactionPlayerHandler> capability, IFactionPlayerHandler instance, EnumFacing side) {
            NBTTagCompound nbt = new NBTTagCompound();
            ((FactionPlayerHandler)instance).saveNBTData(nbt);
            return nbt;
        }
    }
}

