/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.vampire;

import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.difficulty.Difficulty;
import de.teamlapen.vampirism.api.entity.vampire.IAdvancedVampire;
import de.teamlapen.vampirism.config.Balance;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.core.ModPotions;
import de.teamlapen.vampirism.entity.ai.EntityAIAttackMeleeNoSun;
import de.teamlapen.vampirism.entity.ai.VampireAIFleeGarlic;
import de.teamlapen.vampirism.entity.ai.VampireAIFleeSun;
import de.teamlapen.vampirism.entity.ai.VampireAIRestrictSun;
import de.teamlapen.vampirism.entity.hunter.EntityHunterBase;
import de.teamlapen.vampirism.entity.vampire.EntityVampireBase;
import de.teamlapen.vampirism.util.IPlayerFace;
import de.teamlapen.vampirism.util.SupporterManager;
import de.teamlapen.vampirism.util.VampireBookManager;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIBreakDoor;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;

public class EntityAdvancedVampire
extends EntityVampireBase
implements IAdvancedVampire,
IPlayerFace {
    private static final DataParameter<Integer> LEVEL = EntityDataManager.func_187226_a(EntityAdvancedVampire.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> TYPE = EntityDataManager.func_187226_a(EntityAdvancedVampire.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<String> NAME = EntityDataManager.func_187226_a(EntityAdvancedVampire.class, (DataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<String> TEXTURE = EntityDataManager.func_187226_a(EntityAdvancedVampire.class, (DataSerializer)DataSerializers.field_187194_d);
    private final int MAX_LEVEL = 1;
    private int followingEntities = 0;

    public EntityAdvancedVampire(World world) {
        super(world, true);
        this.func_70105_a(0.6f, 1.8f);
        this.canSuckBloodFromPlayer = true;
        this.restrictedSpawn = true;
        this.setDontDropEquipment();
    }

    @Override
    public boolean func_70097_a(DamageSource damageSource, float amount) {
        boolean flag = super.func_70097_a(damageSource, amount);
        if (flag && damageSource.func_76364_f() instanceof EntityPlayer && this.field_70146_Z.nextInt(4) == 0) {
            this.func_70690_d(new PotionEffect(ModPotions.sunscreen, 150, 2));
        }
        return flag;
    }

    @Override
    public void decreaseFollowerCount() {
        this.followingEntities = Math.max(0, this.followingEntities - 1);
    }

    public boolean func_94059_bO() {
        return true;
    }

    @Override
    public int getEyeType() {
        return (Integer)this.func_184212_Q().func_187225_a(TYPE);
    }

    @Override
    public int getFollowingCount() {
        return this.followingEntities;
    }

    @Override
    public int getLevel() {
        return (Integer)this.func_184212_Q().func_187225_a(LEVEL);
    }

    @Override
    public void setLevel(int level) {
        if (level >= 0) {
            this.func_184212_Q().func_187227_b(LEVEL, (Object)level);
            this.updateEntityAttributes();
            if (level == 1) {
                this.func_70690_d(new PotionEffect(MobEffects.field_76429_m, 1000000, 0));
            }
        }
    }

    @Override
    public int getMaxFollowerCount() {
        return Balance.mobProps.ADVANCED_VAMPIRE_MAX_FOLLOWER;
    }

    @Override
    public int getMaxLevel() {
        return 1;
    }

    public String func_70005_c_() {
        String senderName = (String)this.func_184212_Q().func_187225_a(NAME);
        return "none".equals(senderName) ? super.func_70005_c_() : senderName;
    }

    @Override
    @Nullable
    public String getPlayerFaceName() {
        return this.getTextureName();
    }

    @Override
    @Nullable
    public String getTextureName() {
        String texture = (String)this.func_184212_Q().func_187225_a(TEXTURE);
        return "none".equals(texture) ? null : texture;
    }

    @Override
    public boolean increaseFollowerCount() {
        if (this.followingEntities < this.getMaxFollowerCount()) {
            ++this.followingEntities;
            return true;
        }
        return false;
    }

    public void func_70020_e(NBTTagCompound tagCompund) {
        super.func_70020_e(tagCompund);
        if (tagCompund.func_74764_b("level")) {
            this.setLevel(tagCompund.func_74762_e("level"));
        }
        if (tagCompund.func_74764_b("type")) {
            this.func_184212_Q().func_187227_b(TYPE, (Object)tagCompund.func_74762_e("type"));
            this.func_184212_Q().func_187227_b(NAME, (Object)tagCompund.func_74779_i("name"));
            this.func_184212_Q().func_187227_b(TEXTURE, (Object)tagCompund.func_74779_i("texture"));
        }
    }

    @Override
    public int suggestLevel(Difficulty d) {
        if (this.field_70146_Z.nextBoolean()) {
            return (int)((float)(d.avgPercLevel * 1) / 100.0f);
        }
        return this.field_70146_Z.nextInt(2);
    }

    @Override
    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74768_a("level", this.getLevel());
        nbt.func_74768_a("type", this.getEyeType());
        nbt.func_74778_a("texture", (String)this.func_184212_Q().func_187225_a(TEXTURE));
        nbt.func_74778_a("name", (String)this.func_184212_Q().func_187225_a(NAME));
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.updateEntityAttributes();
    }

    @Override
    protected float calculateFireDamage(float amount) {
        return (float)((double)amount * Balance.mobProps.ADVANCED_VAMPIRE_FIRE_VULNERABILITY);
    }

    protected void func_70628_a(boolean wasRecentlyHit, int lootingModifier) {
        switch (this.func_70681_au().nextInt(2)) {
            case 0: {
                this.func_145779_a(ModItems.vampireBlood, 1);
                break;
            }
            case 1: {
                this.func_70099_a(new ItemStack((Item)ModItems.bloodBottle, lootingModifier + 1, this.func_70681_au().nextInt(9)), 0.0f);
                break;
            }
        }
        if (this.func_70681_au().nextInt(20) == 0) {
            this.func_70099_a(VampireBookManager.getInstance().getRandomBook(this.func_70681_au()), 0.0f);
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        SupporterManager.Supporter supporter = SupporterManager.getInstance().getRandomVampire(this.field_70146_Z);
        this.func_184212_Q().func_187214_a(LEVEL, (Object)-1);
        this.func_184212_Q().func_187214_a(TYPE, (Object)supporter.typeId);
        this.func_184212_Q().func_187214_a(NAME, (Object)(supporter.senderName == null ? "none" : supporter.senderName));
        this.func_184212_Q().func_187214_a(TEXTURE, (Object)(supporter.textureName == null ? "none" : supporter.textureName));
    }

    protected int func_70693_a(EntityPlayer player) {
        return 10 * (1 + this.getLevel());
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        if (this.field_70170_p.func_175659_aa() == EnumDifficulty.HARD) {
            this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIBreakDoor((EntityLiving)this));
            ((PathNavigateGround)this.func_70661_as()).func_179688_b(true);
        }
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new VampireAIRestrictSun(this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new VampireAIFleeSun(this, 0.9, false));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new VampireAIFleeGarlic(this, 0.9, false));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIAttackMeleeNoSun(this, 1.0, false));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.9, 25));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 13.0f));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityHunterBase.class, 17.0f));
        this.field_70714_bg.func_75776_a(11, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 5, true, false, VampirismAPI.factionRegistry().getPredicate(this.getFaction(), true, false, true, false, null)));
        this.field_70715_bh.func_75776_a(5, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityCreature.class, 5, true, false, VampirismAPI.factionRegistry().getPredicate(this.getFaction(), false, true, false, false, null)));
    }

    protected void updateEntityAttributes() {
        int l = Math.max(this.getLevel(), 0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(Balance.mobProps.ADVANCED_VAMPIRE_MAX_HEALTH + Balance.mobProps.ADVANCED_VAMPIRE_MAX_HEALTH_PL * (double)l);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(Balance.mobProps.ADVANCED_VAMPIRE_ATTACK_DAMAGE + Balance.mobProps.ADVANCED_VAMPIRE_ATTACK_DAMAGE_PL * (double)l);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(Balance.mobProps.ADVANCED_VAMPIRE_SPEED);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(13.0);
    }
}

