/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.vampire;

import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.api.EnumStrength;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.api.entity.vampire.IVampireMob;
import de.teamlapen.vampirism.config.Balance;
import de.teamlapen.vampirism.core.ModBiomes;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.core.ModPotions;
import de.teamlapen.vampirism.entity.DamageHandler;
import de.teamlapen.vampirism.entity.EntityVampirism;
import de.teamlapen.vampirism.player.vampire.VampirePlayer;
import de.teamlapen.vampirism.util.Helper;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class EntityVampireBase
extends EntityVampirism
implements IVampireMob {
    private final boolean countAsMonsterForSpawn;
    protected boolean restrictedSpawn = false;
    protected EnumStrength garlicResist = EnumStrength.NONE;
    protected boolean canSuckBloodFromPlayer = false;
    protected boolean vulnerableToFire = true;
    private boolean sundamageCache;
    private EnumStrength garlicCache = EnumStrength.NONE;

    public EntityVampireBase(World world, boolean countAsMonsterForSpawn) {
        super(world);
        this.countAsMonsterForSpawn = countAsMonsterForSpawn;
    }

    @Override
    public boolean func_70652_k(Entity entity) {
        if (this.canSuckBloodFromPlayer && !this.field_70170_p.field_72995_K && entity instanceof EntityPlayer && !UtilLib.canReallySee((EntityLivingBase)entity, (EntityLivingBase)this, true) && this.field_70146_Z.nextInt(Balance.mobProps.VAMPIRE_BITE_ATTACK_CHANCE) == 0) {
            int amt = VampirePlayer.get((EntityPlayer)entity).onBite(this);
            this.drinkBlood(amt, 1.0f);
            return true;
        }
        return super.func_70652_k(entity);
    }

    @Override
    public boolean func_70097_a(DamageSource src, float amount) {
        if (this.vulnerableToFire) {
            if (DamageSource.field_76372_a.equals(src)) {
                return this.func_70097_a(VReference.VAMPIRE_IN_FIRE, this.calculateFireDamage(amount));
            }
            if (DamageSource.field_76370_b.equals(src)) {
                return this.func_70097_a(VReference.VAMPIRE_ON_FIRE, this.calculateFireDamage(amount));
            }
        }
        return super.func_70097_a(src, amount);
    }

    @Override
    public boolean doesResistGarlic(EnumStrength strength) {
        return !strength.isStrongerThan(this.garlicResist);
    }

    @Override
    public void drinkBlood(int amt, float saturationMod) {
        this.func_70690_d(new PotionEffect(MobEffects.field_76428_l, amt * 20));
    }

    @Override
    public boolean func_70601_bi() {
        if (this.isGettingSundamage(true) || this.field_70170_p.func_72935_r() && this.field_70146_Z.nextInt(5) != 0) {
            return false;
        }
        if (this.isGettingGarlicDamage(true) != EnumStrength.NONE) {
            return false;
        }
        if (this.field_70170_p.func_175714_ae().func_176056_a(this.func_180425_c(), 1) != null && this.func_70681_au().nextInt(60) != 0) {
            return false;
        }
        return super.func_70601_bi() && (!this.restrictedSpawn || this.getCanSpawnHereRestricted());
    }

    public EnumCreatureAttribute func_70668_bt() {
        return VReference.VAMPIRE_CREATURE_ATTRIBUTE;
    }

    @Override
    public IFaction getFaction() {
        return VReference.VAMPIRE_FACTION;
    }

    @Override
    public EntityLivingBase getRepresentingEntity() {
        return this;
    }

    public boolean isCreatureType(EnumCreatureType type, boolean forSpawnCount) {
        if (forSpawnCount && this.countAsMonsterForSpawn && type == EnumCreatureType.MONSTER) {
            return true;
        }
        return super.isCreatureType(type, forSpawnCount);
    }

    @Override
    public EnumStrength isGettingGarlicDamage() {
        return this.isGettingGarlicDamage(false);
    }

    @Override
    public EnumStrength isGettingGarlicDamage(boolean forcerefresh) {
        if (forcerefresh) {
            this.garlicCache = Helper.getGarlicStrength((Entity)this);
        }
        return this.garlicCache;
    }

    @Override
    public boolean isGettingSundamage(boolean forceRefresh) {
        if (!forceRefresh) {
            return this.sundamageCache;
        }
        this.sundamageCache = Helper.gettingSundamge((EntityLivingBase)this);
        return this.sundamageCache;
    }

    @Override
    public boolean isGettingSundamage() {
        return this.isGettingSundamage(false);
    }

    @Override
    public boolean isIgnoringSundamage() {
        return this.func_70644_a(ModPotions.sunscreen);
    }

    @Override
    public void func_70636_d() {
        if (this.field_70173_aa % 40 == 3) {
            this.isGettingGarlicDamage(true);
        }
        if (this.field_70173_aa % 8 == 2) {
            this.isGettingSundamage(true);
        }
        if (!this.field_70170_p.field_72995_K) {
            double dmg;
            if (this.isGettingSundamage() && this.field_70173_aa % 40 == 11 && (dmg = this.func_110148_a(VReference.sunDamage).func_111126_e()) > 0.0) {
                this.func_70097_a(VReference.SUNDAMAGE, (float)dmg);
            }
            if (this.isGettingGarlicDamage() != EnumStrength.NONE) {
                DamageHandler.affectVampireGarlicAmbient(this, this.isGettingGarlicDamage(), this.field_70173_aa);
            }
        }
        super.func_70636_d();
    }

    @Override
    public boolean wantsBlood() {
        return false;
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(VReference.sunDamage).func_111128_a(Balance.mobProps.VAMPIRE_MOB_SUN_DAMAGE);
    }

    protected float calculateFireDamage(float amount) {
        return amount;
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
    }

    private boolean getCanSpawnHereRestricted() {
        boolean vampireBiome = ((Object)((Object)ModBiomes.vampireForest)).equals(this.field_70170_p.func_180494_b(this.func_180425_c()));
        if (!vampireBiome) {
            return this.isLowLightLevel();
        }
        IBlockState iblockstate = this.field_70170_p.func_180495_p(new BlockPos((Entity)this).func_177977_b());
        return ((Object)((Object)ModBlocks.cursedEarth)).equals(iblockstate.func_177230_c());
    }
}

