/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.inventory;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import de.teamlapen.lib.lib.util.ItemStackUtil;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.api.items.IAlchemicalCauldronCraftingManager;
import de.teamlapen.vampirism.api.items.IAlchemicalCauldronRecipe;
import de.teamlapen.vampirism.inventory.AlchemicalCauldronRecipe;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class AlchemicalCauldronCraftingManager
implements IAlchemicalCauldronCraftingManager {
    private static final String TAG = "ACCraftingManager";
    private static AlchemicalCauldronCraftingManager ourInstance = new AlchemicalCauldronCraftingManager();
    private final List<IAlchemicalCauldronRecipe> recipes = Lists.newLinkedList();
    private Map<Object, Integer> liquidColors = Maps.newHashMap();

    public static AlchemicalCauldronCraftingManager getInstance() {
        return ourInstance;
    }

    private AlchemicalCauldronCraftingManager() {
    }

    @Override
    public void addRecipe(IAlchemicalCauldronRecipe recipe) {
        for (IAlchemicalCauldronRecipe r : this.recipes) {
            if (!r.areSameIngredients(recipe)) continue;
            throw new IllegalArgumentException("ACCraftingManager: Duplicate recipe " + r + " and " + recipe);
        }
        this.recipes.add(recipe);
    }

    @Override
    public IAlchemicalCauldronRecipe addRecipe(@Nonnull Object output, @Nonnull Object liquid, @Nullable Object ingredient) {
        AlchemicalCauldronRecipe recipe;
        if (liquid instanceof Item) {
            liquid = new ItemStack((Item)liquid);
        } else if (liquid instanceof Block) {
            liquid = new ItemStack((Block)liquid);
        }
        if (liquid instanceof ItemStack) {
            recipe = new AlchemicalCauldronRecipe(this.getItemStackCopy(output), ((ItemStack)liquid).func_77946_l(), this.getItemStackCopy(ingredient));
        } else if (liquid instanceof FluidStack) {
            recipe = new AlchemicalCauldronRecipe(this.getItemStackCopy(output), ((FluidStack)liquid).copy(), this.getItemStackCopy(ingredient));
        } else {
            throw new IllegalArgumentException("ACCraftingManager: Liquid has to be either a ItemStack or a FluidStack");
        }
        this.addRecipe(recipe);
        return recipe;
    }

    @Override
    public IAlchemicalCauldronRecipe addRecipe(@Nonnull Object output, @Nonnull Object liquid, @Nullable Object ingredient, int ticks, int exp, int reqLevel, ISkill ... reqSkills) {
        IAlchemicalCauldronRecipe recipe = this.addRecipe(output, liquid, ingredient);
        recipe.configure(ticks, exp, reqLevel, reqSkills);
        return recipe;
    }

    @Override
    @Nullable
    public IAlchemicalCauldronRecipe findRecipe(@Nonnull ItemStack liquid, @Nullable ItemStack ingredient) {
        for (IAlchemicalCauldronRecipe r : this.recipes) {
            if (!r.isValidLiquidItem(liquid) && r.isValidFluidItem(liquid) == null || !ItemStackUtil.doesStackContain(ingredient, r.getIngredient())) continue;
            return r;
        }
        return null;
    }

    @Override
    @Nullable
    public IAlchemicalCauldronRecipe findRecipe(FluidStack liquid, ItemStack ingredient) {
        for (IAlchemicalCauldronRecipe r : this.recipes) {
            if (r.isValidFluidStack(liquid) == null || !ItemStackUtil.doesStackContain(ingredient, r.getIngredient())) continue;
            return r;
        }
        return null;
    }

    @Override
    public int getLiquidColor(@Nullable ItemStack stack) {
        if (!ItemStackUtil.isEmpty(stack)) {
            if (this.liquidColors.containsKey(stack)) {
                return this.liquidColors.get(stack);
            }
            if (this.liquidColors.containsKey(stack.func_77973_b())) {
                return this.liquidColors.get(stack.func_77973_b());
            }
        }
        return -1;
    }

    public List<IAlchemicalCauldronRecipe> getRecipes() {
        return this.recipes;
    }

    @Override
    public void registerLiquidColor(@Nonnull ItemStack stack, int color) {
        this.liquidColors.put(stack, color);
    }

    @Override
    public void registerLiquidColor(Item item, int color) {
        this.liquidColors.put(item, color);
    }

    private ItemStack getItemStackCopy(Object o) {
        if (o == null) {
            return ItemStackUtil.getEmptyStack();
        }
        if (o instanceof ItemStack) {
            return ((ItemStack)o).func_77946_l();
        }
        if (o instanceof Item) {
            return new ItemStack((Item)o);
        }
        if (o instanceof Block) {
            return new ItemStack((Block)o);
        }
        throw new IllegalArgumentException("ACCraftingManager: Argument has to be one of the following: ItemStack, Item or Block");
    }
}

