/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.items;

import de.teamlapen.lib.lib.util.ItemStackUtil;
import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.EnumStrength;
import de.teamlapen.vampirism.api.items.IItemWithTier;
import de.teamlapen.vampirism.entity.DamageHandler;
import de.teamlapen.vampirism.entity.EntityThrowableItem;
import de.teamlapen.vampirism.items.VampirismItem;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.PotionTypes;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionType;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemHolyWaterBottle
extends VampirismItem
implements IItemWithTier,
EntityThrowableItem.IVampirismThrowableItem {
    private static final String regName = "holy_water_bottle";

    @Deprecated
    public static void registerSplashRecipes(ItemHolyWaterBottle item, IItemWithTier.TIER tier) {
        ItemStack base = item.setTier(new ItemStack((Item)item), tier);
        ItemStack splash = item.setSplash(base.func_77946_l(), true);
        GameRegistry.addShapelessRecipe((ItemStack)splash.func_77946_l(), (Object[])new Object[]{base, Items.field_151016_H});
        ItemStackUtil.grow(splash, 1);
        GameRegistry.addShapelessRecipe((ItemStack)splash.func_77946_l(), (Object[])new Object[]{base, base, Items.field_151016_H});
        ItemStackUtil.grow(splash, 1);
        GameRegistry.addShapelessRecipe((ItemStack)splash.func_77946_l(), (Object[])new Object[]{base, base, base, Items.field_151016_H});
        ItemStackUtil.grow(splash, 1);
        GameRegistry.addShapelessRecipe((ItemStack)splash.func_77946_l(), (Object[])new Object[]{base, base, base, base, Items.field_151016_H});
        ItemStackUtil.grow(splash, 1);
        GameRegistry.addShapelessRecipe((ItemStack)splash.func_77946_l(), (Object[])new Object[]{base, base, base, base, base, Items.field_151016_H});
    }

    public ItemHolyWaterBottle() {
        super(regName);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        super.func_77624_a(stack, playerIn, tooltip, advanced);
        IItemWithTier.TIER t = this.getTier(stack);
        if (t != IItemWithTier.TIER.NORMAL) {
            tooltip.add(TextFormatting.AQUA + UtilLib.translate("text.vampirism.item_tier." + t.name().toLowerCase()));
        }
    }

    public int getItemStackLimit(ItemStack stack) {
        return this.isSplash(stack) ? 1 : 64;
    }

    public ItemStack getStack(IItemWithTier.TIER tier) {
        return this.setTier(new ItemStack((Item)this), tier);
    }

    public EnumStrength getStrength(IItemWithTier.TIER tier) {
        switch (tier) {
            case NORMAL: {
                return EnumStrength.WEAK;
            }
            case ENHANCED: {
                return EnumStrength.MEDIUM;
            }
            case ULTIMATE: {
                return EnumStrength.STRONG;
            }
        }
        return EnumStrength.NONE;
    }

    public void func_150895_a(@Nonnull Item itemIn, CreativeTabs tab, List<ItemStack> subItems) {
        for (IItemWithTier.TIER t : IItemWithTier.TIER.values()) {
            subItems.add(this.setTier(new ItemStack(itemIn), t));
            subItems.add(this.setSplash(this.setTier(new ItemStack(itemIn), t), true));
        }
    }

    @Override
    public IItemWithTier.TIER getTier(ItemStack stack) {
        NBTTagCompound tag = UtilLib.checkNBT(stack);
        if (tag.func_74764_b("tier")) {
            try {
                return IItemWithTier.TIER.valueOf(tag.func_74779_i("tier"));
            }
            catch (IllegalArgumentException e) {
                VampirismMod.log.e("HolyWaterBottle", e, "Unknown item tier %s", tag.func_74779_i("tier"));
            }
        }
        return IItemWithTier.TIER.NORMAL;
    }

    @Nonnull
    public String func_77667_c(ItemStack stack) {
        String unloc = super.func_77667_c(stack);
        return this.isSplash(stack) ? unloc + ".splash" : unloc;
    }

    public boolean isSplash(ItemStack stack) {
        NBTTagCompound tag = UtilLib.checkNBT(stack);
        return tag.func_74764_b("splash") && tag.func_74767_n("splash");
    }

    @Override
    public void onImpact(EntityThrowableItem entity, ItemStack stack, RayTraceResult result, boolean remote) {
        if (!this.isSplash(stack)) {
            VampirismMod.log.w("HolyWaterBottle", "Threw non splash bottle", new Object[0]);
            return;
        }
        IItemWithTier.TIER tier = this.getTier(stack);
        if (!remote) {
            AxisAlignedBB axisalignedbb = entity.func_174813_aQ().func_72314_b(4.0, 2.0, 4.0);
            List list1 = entity.func_130014_f_().func_72872_a(EntityLivingBase.class, axisalignedbb);
            if (!list1.isEmpty()) {
                for (EntityLivingBase entitylivingbase : list1) {
                    DamageHandler.affectEntityHolyWaterSplash(entitylivingbase, this.getStrength(tier), entity.func_70068_e((Entity)entitylivingbase), result.field_72308_g != null);
                }
            }
            entity.func_130014_f_().func_175718_b(2002, new BlockPos((Entity)entity), PotionType.func_185171_a((PotionType)PotionTypes.field_185231_c));
        }
    }

    @Override
    @Nonnull
    public ActionResult<ItemStack> onItemRightClick(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        if (this.isSplash(stack)) {
            if (!playerIn.field_71075_bZ.field_75098_d) {
                ItemStackUtil.decr(stack);
            }
            worldIn.func_184148_a(null, playerIn.field_70165_t, playerIn.field_70163_u, playerIn.field_70161_v, SoundEvents.field_187827_fP, SoundCategory.NEUTRAL, 0.5f, 0.4f / (field_77697_d.nextFloat() * 0.4f + 0.8f));
            if (!worldIn.field_72995_K) {
                EntityThrowableItem entityThrowable = new EntityThrowableItem(worldIn, (EntityLivingBase)playerIn);
                entityThrowable.setItem(stack);
                entityThrowable.func_184538_a((Entity)playerIn, playerIn.field_70125_A, playerIn.field_70177_z, -20.0f, 0.5f, 1.0f);
                worldIn.func_72838_d((Entity)entityThrowable);
            }
            playerIn.func_71029_a(StatList.func_188057_b((Item)this));
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)stack);
    }

    public ItemStack setSplash(ItemStack stack, boolean value) {
        NBTTagCompound tag = UtilLib.checkNBT(stack);
        tag.func_74757_a("splash", value);
        return stack;
    }

    @Override
    public ItemStack setTier(ItemStack stack, IItemWithTier.TIER tier) {
        NBTTagCompound tag = UtilLib.checkNBT(stack);
        tag.func_74778_a("tier", tier.name());
        return stack;
    }
}

