/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.items;

import de.teamlapen.lib.lib.util.ItemStackUtil;
import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.api.entity.player.hunter.IHunterPlayer;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.core.ModEnchantments;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.items.ItemSimpleCrossbow;
import de.teamlapen.vampirism.player.hunter.skills.HunterSkills;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;

public class ItemTechCrossbow
extends ItemSimpleCrossbow {
    public static final int MAX_ARROW_COUNT = 12;

    private static int getArrowsLeft(@Nonnull ItemStack bowStack) {
        NBTTagCompound nbt = bowStack.func_77978_p();
        if (nbt == null || !nbt.func_74764_b("arrows")) {
            return 0;
        }
        return nbt.func_74762_e("arrows");
    }

    private static ItemStack setArrowsLeft(@Nonnull ItemStack bowStack, int arrows) {
        int i = Math.max(-1, Math.min(12, arrows));
        NBTTagCompound nbt = bowStack.func_77942_o() ? bowStack.func_77978_p() : new NBTTagCompound();
        nbt.func_74768_a("arrows", i);
        bowStack.func_77982_d(nbt);
        return bowStack;
    }

    private static boolean reduceArrowCount(@Nonnull ItemStack bowStack, Random rnd) {
        NBTTagCompound nbt = bowStack.func_77978_p();
        if (nbt == null || !nbt.func_74764_b("arrows")) {
            return false;
        }
        int count = nbt.func_74762_e("arrows");
        if (count == -1) {
            return true;
        }
        if (count == 0) {
            return false;
        }
        int frugal = ItemTechCrossbow.isCrossbowFrugal(bowStack);
        if (rnd.nextInt(frugal + 1) != 0) {
            return true;
        }
        nbt.func_74768_a("arrows", count - 1);
        bowStack.func_77982_d(nbt);
        return true;
    }

    public static ItemStack getLoadedItemStack(ItemTechCrossbow crossbow) {
        return ItemTechCrossbow.setArrowsLeft(new ItemStack((Item)crossbow, 1), 12);
    }

    public static ItemStack getUnLoadedItemStack(ItemTechCrossbow crossbow) {
        return ItemTechCrossbow.setArrowsLeft(new ItemStack((Item)crossbow, 1), 0);
    }

    protected static int isCrossbowFrugal(ItemStack crossbowStack) {
        int enchant = EnchantmentHelper.func_77506_a((Enchantment)ModEnchantments.crossbowFrugality, (ItemStack)crossbowStack);
        return enchant;
    }

    public ItemTechCrossbow(String regName, float speed, int cooldown, int maxDamage) {
        super(regName, speed, cooldown, maxDamage);
    }

    public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        super.func_77624_a(stack, playerIn, tooltip, advanced);
        int arrows = ItemTechCrossbow.getArrowsLeft(stack);
        if (arrows == -1) {
            tooltip.add(TextFormatting.DARK_GRAY + UtilLib.translate(Enchantments.field_185312_x.func_77320_a()));
        } else if (arrows == 0) {
            tooltip.add(TextFormatting.DARK_GRAY + UtilLib.translate("text.vampirism.crossbow.not_loaded"));
        } else {
            tooltip.add(TextFormatting.DARK_GRAY + UtilLib.translateFormatted("text.vampirism.crossbow.loaded_arrow_count", arrows));
        }
    }

    @Override
    @Nullable
    public ISkill<IHunterPlayer> getRequiredSkill(ItemStack stack) {
        return HunterSkills.techWeapons;
    }

    public void func_150895_a(Item itemIn, CreativeTabs tab, List<ItemStack> subItems) {
        subItems.add(ItemTechCrossbow.setArrowsLeft(new ItemStack(itemIn), 0));
        subItems.add(ItemTechCrossbow.setArrowsLeft(new ItemStack(itemIn), 12));
    }

    @Override
    @Nullable
    protected ItemStack findAmmo(EntityPlayer player, ItemStack bowStack) {
        boolean arrow = ItemTechCrossbow.reduceArrowCount(bowStack, player.func_70681_au());
        return arrow ? new ItemStack((Item)ModItems.crossbowArrow) : ItemStackUtil.getEmptyStack();
    }

    @Override
    protected float getArrowVelocity() {
        return 1.7f;
    }

    @Override
    protected int getCooldown(EntityPlayer player, ItemStack stack) {
        return 2;
    }

    @Override
    protected boolean isCrossbowInfinite(ItemStack stack, EntityPlayer player) {
        return false;
    }

    @Override
    protected boolean shouldConsumeArrow(ItemStack arrowStack, boolean playerCreative, boolean bowInfinite) {
        return false;
    }

    public static class ShapelessFillRecipe
    implements IRecipe {
        private final ItemTechCrossbow crossbowItem;
        private final ItemStack arrowPackage;
        private final ItemStack loadedCrossbow;

        public ShapelessFillRecipe(@Nonnull ItemTechCrossbow crossbowItem, @Nonnull ItemStack arrowPackage) {
            assert (!ItemStackUtil.isEmpty(arrowPackage)) : "Empty arrow stack package";
            this.crossbowItem = crossbowItem;
            this.arrowPackage = arrowPackage;
            this.loadedCrossbow = ItemTechCrossbow.getLoadedItemStack(crossbowItem);
        }

        @Nullable
        public ItemStack func_77572_b(InventoryCrafting inv) {
            for (int i = 0; i < inv.func_174923_h(); ++i) {
                for (int j = 0; j < inv.func_174922_i(); ++j) {
                    ItemStack itemstack = inv.func_70463_b(j, i);
                    if (ItemStackUtil.isEmpty(itemstack) || !this.crossbowItem.equals(itemstack.func_77973_b())) continue;
                    ItemStack result = this.loadedCrossbow.func_77946_l();
                    result.func_77964_b(itemstack.func_77952_i());
                    return result;
                }
            }
            return this.loadedCrossbow.func_77946_l();
        }

        @Nullable
        public ItemStack func_77571_b() {
            return this.loadedCrossbow;
        }

        public int func_77570_a() {
            return 2;
        }

        public ItemStack[] func_179532_b(InventoryCrafting inv) {
            ItemStack[] aitemstack = new ItemStack[inv.func_70302_i_()];
            for (int i = 0; i < aitemstack.length; ++i) {
                ItemStack itemstack = inv.func_70301_a(i);
                aitemstack[i] = ForgeHooks.getContainerItem((ItemStack)itemstack);
            }
            return aitemstack;
        }

        public boolean func_77569_a(InventoryCrafting inv, World worldIn) {
            boolean crossbow = false;
            boolean arrows = false;
            for (int i = 0; i < inv.func_174923_h(); ++i) {
                for (int j = 0; j < inv.func_174922_i(); ++j) {
                    ItemStack itemstack = inv.func_70463_b(j, i);
                    if (ItemStackUtil.isEmpty(itemstack)) continue;
                    boolean flag = false;
                    if (!crossbow && this.crossbowItem.equals(itemstack.func_77973_b())) {
                        if (ItemTechCrossbow.getArrowsLeft(itemstack) == 0) {
                            crossbow = true;
                            flag = true;
                        }
                    } else if (!(arrows || itemstack.func_77973_b() != this.arrowPackage.func_77973_b() || this.arrowPackage.func_77960_j() != Short.MAX_VALUE && itemstack.func_77960_j() != this.arrowPackage.func_77960_j())) {
                        flag = true;
                        arrows = true;
                    }
                    if (flag) continue;
                    return false;
                }
            }
            return arrows && crossbow;
        }
    }
}

