/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.modcompat.guide.pages;

import amerifrance.guideapi.api.impl.Book;
import amerifrance.guideapi.api.impl.Page;
import amerifrance.guideapi.api.impl.abstraction.CategoryAbstract;
import amerifrance.guideapi.api.impl.abstraction.EntryAbstract;
import amerifrance.guideapi.api.util.GuiHelper;
import amerifrance.guideapi.gui.GuiBase;
import com.google.common.collect.Lists;
import de.teamlapen.lib.lib.util.ItemStackUtil;
import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.api.entity.player.hunter.IHunterPlayer;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.api.items.IAlchemicalCauldronRecipe;
import de.teamlapen.vampirism.core.ModBlocks;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class AlchemicalCauldronRecipePage
extends Page {
    protected final IAlchemicalCauldronRecipe recipe;
    protected List<String> tooltips = Lists.newArrayList();
    private long lastCycle = -1L;
    private int cycleIdx = 0;
    private Random rand = new Random();

    public AlchemicalCauldronRecipePage(IAlchemicalCauldronRecipe recipe) {
        this.recipe = recipe;
    }

    @SideOnly(value=Side.CLIENT)
    public void draw(Book book, CategoryAbstract category, EntryAbstract entry, int guiLeft, int guiTop, int mouseX, int mouseY, GuiBase guiBase, FontRenderer fontRendererObj) {
        ItemStack liquid;
        ItemStack input;
        Minecraft mc = Minecraft.func_71410_x();
        long time = mc.field_71441_e.func_82737_E();
        if (this.lastCycle < 0L || this.lastCycle < time - 20L) {
            if (this.lastCycle > 0L) {
                ++this.cycleIdx;
                this.cycleIdx = Math.max(0, this.cycleIdx);
            }
            this.lastCycle = mc.field_71441_e.func_82737_E();
        }
        Minecraft.func_71410_x().func_110434_K().func_110577_a(new ResourceLocation("vampirismguide", "textures/gui/alchemical_cauldron_recipe.png"));
        guiBase.func_73729_b(guiLeft + 32, guiTop + 43, 0, 0, 110, 75);
        guiBase.func_73732_a(fontRendererObj, ModBlocks.alchemicalCauldron.func_149732_F(), guiLeft + guiBase.xSize / 2, guiTop + 12, 0);
        guiBase.func_73732_a(fontRendererObj, "\u00a7o" + this.getRecipeName() + "\u00a7r", guiLeft + guiBase.xSize / 2, guiTop + 14 + fontRendererObj.field_78288_b, 0);
        int outputX = 95 + (guiLeft + guiBase.xSize / 7);
        int outputY = 34 + (guiTop + guiBase.ySize / 5);
        int in1X = 23 + (guiLeft + guiBase.xSize / 7);
        int in1Y = 22 + (guiTop + guiBase.ySize / 5);
        int in2X = 53 + (guiLeft + guiBase.xSize / 7);
        int in2Y = 22 + (guiTop + guiBase.ySize / 5);
        ItemStack stack = this.recipe.getOutput();
        if (stack.func_77952_i() == Short.MAX_VALUE) {
            ArrayList subItems = new ArrayList();
            stack.func_77973_b().func_150895_a(stack.func_77973_b(), stack.func_77973_b().func_77640_w(), subItems);
            stack = (ItemStack)subItems.get(this.getRandomizedCycle(0, subItems.size()));
        }
        GuiHelper.drawItemStack((ItemStack)stack, (int)outputX, (int)outputY);
        if (GuiHelper.isMouseBetween((int)mouseX, (int)mouseY, (int)outputX, (int)outputY, (int)15, (int)15)) {
            this.tooltips = GuiHelper.getTooltip((ItemStack)this.recipe.getOutput());
        }
        if (!ItemStackUtil.isEmpty(input = this.recipe.getIngredient())) {
            if (input.func_77952_i() == Short.MAX_VALUE) {
                ArrayList subItems = new ArrayList();
                input.func_77973_b().func_150895_a(input.func_77973_b(), input.func_77973_b().func_77640_w(), subItems);
                input = (ItemStack)subItems.get(this.getRandomizedCycle(0, subItems.size()));
            }
            GuiHelper.drawItemStack((ItemStack)input, (int)in2X, (int)in2Y);
            if (GuiHelper.isMouseBetween((int)mouseX, (int)mouseY, (int)in2X, (int)in2Y, (int)15, (int)15)) {
                this.tooltips = GuiHelper.getTooltip((ItemStack)input);
            }
        }
        if (!ItemStackUtil.isEmpty(liquid = this.recipe.getDescriptiveFluidStack()) && liquid.func_77952_i() == Short.MAX_VALUE) {
            ArrayList subItems = new ArrayList();
            liquid.func_77973_b().func_150895_a(liquid.func_77973_b(), liquid.func_77973_b().func_77640_w(), subItems);
            liquid = (ItemStack)subItems.get(this.getRandomizedCycle(0, subItems.size()));
        }
        GuiHelper.drawItemStack((ItemStack)liquid, (int)in1X, (int)in1Y);
        if (GuiHelper.isMouseBetween((int)mouseX, (int)mouseY, (int)in1X, (int)in1Y, (int)15, (int)15)) {
            this.tooltips = GuiHelper.getTooltip((ItemStack)liquid);
        }
        int y = guiTop + 120;
        if (this.recipe.getRequiredLevel() > 1) {
            String level = UtilLib.translateFormatted("gui.vampirism.hunter_weapon_table.level", this.recipe.getRequiredLevel());
            guiBase.func_73731_b(fontRendererObj, level, guiLeft + 50, y, Color.gray.getRGB());
            y += fontRendererObj.field_78288_b + 2;
        }
        if (this.recipe.getRequiredSkills().length > 0) {
            String skills = "";
            for (ISkill<IHunterPlayer> skill : this.recipe.getRequiredSkills()) {
                skills = skills + "\n\u00a7o" + UtilLib.translate(skill.getUnlocalizedName()) + "\u00a7r ";
            }
            String skillText = UtilLib.translateFormatted("gui.vampirism.hunter_weapon_table.skill", skills);
            guiBase.drawSplitString(skillText, guiLeft + 50, y, 100, Color.gray.getRGB());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void drawExtras(Book book, CategoryAbstract category, EntryAbstract entry, int guiLeft, int guiTop, int mouseX, int mouseY, GuiBase guiBase, FontRenderer fontRendererObj) {
        guiBase.func_146283_a(this.tooltips, mouseX, mouseY);
        this.tooltips.clear();
    }

    protected int getRandomizedCycle(int index, int max) {
        this.rand.setSeed(index);
        return (index + this.rand.nextInt(max) + this.cycleIdx) % max;
    }

    protected String getRecipeName() {
        return UtilLib.translate("text.shaped.crafting");
    }
}

