/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.modcompat.guide.pages;

import amerifrance.guideapi.api.impl.Book;
import amerifrance.guideapi.api.impl.Page;
import amerifrance.guideapi.api.impl.abstraction.CategoryAbstract;
import amerifrance.guideapi.api.impl.abstraction.EntryAbstract;
import amerifrance.guideapi.gui.GuiBase;
import de.teamlapen.lib.lib.util.UtilLib;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PageTable
extends Page {
    private List<String[]> lines;
    private int[] width;
    private String headline;

    private PageTable(List<String[]> lines, int[] width, String headline) {
        this.lines = lines;
        this.width = width;
        this.headline = headline;
    }

    @SideOnly(value=Side.CLIENT)
    public void draw(Book book, CategoryAbstract category, EntryAbstract entry, int guiLeft, int guiTop, int mouseX, int mouseY, GuiBase guiBase, FontRenderer fontRendererObj) {
        fontRendererObj.func_78264_a(true);
        int charWidth = fontRendererObj.func_78263_a(' ');
        int y = guiTop + 12;
        int x = guiLeft + 39;
        if (this.headline != null) {
            fontRendererObj.func_78276_b("\u00a7l" + this.headline, x, y, 0);
            y += fontRendererObj.field_78288_b;
        }
        this.drawLine(x, y + fontRendererObj.field_78288_b, (float)x + (float)guiBase.xSize * 3.0f / 5.0f, y + fontRendererObj.field_78288_b, guiBase.publicZLevel);
        for (String[] l : this.lines) {
            x = guiLeft + 39;
            for (int i = 0; i < l.length; ++i) {
                int mw = this.width[i] * charWidth;
                int aw = fontRendererObj.func_78256_a(l[i]);
                int dw = (mw - aw) / 2;
                fontRendererObj.func_78276_b(l[i], x + dw, y, 0);
                x += mw;
            }
            y += fontRendererObj.field_78288_b;
        }
        fontRendererObj.func_78264_a(false);
    }

    protected void drawLine(float x1, float y1, float x2, float y2, float publicZLevel) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179090_x();
        GlStateManager.func_179131_c((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_187441_d((float)2.0f);
        GlStateManager.func_187447_r((int)1);
        GlStateManager.func_187435_e((float)x1, (float)y1, (float)publicZLevel);
        GlStateManager.func_187435_e((float)x2, (float)y2, (float)publicZLevel);
        GlStateManager.func_187437_J();
        GlStateManager.func_179098_w();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179121_F();
    }

    public static class Builder {
        int columns;
        List<String[]> lines;
        String headline;

        public Builder(int columns) {
            this.columns = columns;
            this.lines = new ArrayList<String[]>();
        }

        public Builder addLine(Object ... objects) {
            if (objects.length != this.columns) {
                throw new IllegalArgumentException("Every added line as to contain one String for every column");
            }
            String[] l = new String[objects.length];
            for (int i = 0; i < objects.length; ++i) {
                l[i] = String.valueOf(objects[i]);
            }
            this.lines.add(l);
            return this;
        }

        public Builder addUnlocLine(String ... strings) {
            String[] loc = new String[strings.length];
            for (int i = 0; i < strings.length; ++i) {
                loc[i] = UtilLib.translate(strings[i]);
            }
            return this.addLine(loc);
        }

        public PageTable build() {
            int[] width = new int[this.columns];
            for (int i = 0; i < this.columns; ++i) {
                int max = 0;
                for (String[] s : this.lines) {
                    int w = s[i].length();
                    if (w <= max) continue;
                    max = w;
                }
                width[i] = max;
            }
            return new PageTable(this.lines, width, this.headline);
        }

        public Builder setHeadline(String s) {
            this.headline = s;
            return this;
        }
    }
}

