/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.network;

import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.config.Configs;
import de.teamlapen.vampirism.entity.SundamageRegistry;
import de.teamlapen.vampirism.network.AbstractClientMessageHandler;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class SyncConfigPacket
implements IMessage {
    private NBTTagCompound nbt;

    public static SyncConfigPacket createSyncConfigPacket() {
        SyncConfigPacket packet = new SyncConfigPacket();
        packet.loadConfig();
        return packet;
    }

    public void fromBytes(ByteBuf buf) {
        this.nbt = ByteBufUtils.readTag((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.nbt);
    }

    private void applyConfig() {
        if (!FMLCommonHandler.instance().getSide().isClient()) {
            VampirismMod.log.e(null, "Trying to apply synced configs on server side", new Object[0]);
            return;
        }
        Configs.readFromNBTClient(this.nbt);
        ((SundamageRegistry)VampirismAPI.sundamageRegistry()).readFromNBTClient(this.nbt);
    }

    private void loadConfig() {
        this.nbt = new NBTTagCompound();
        Configs.writeToNBTServer(this.nbt);
        ((SundamageRegistry)VampirismAPI.sundamageRegistry()).writeToNBTServer(this.nbt);
    }

    public static class Handler
    extends AbstractClientMessageHandler<SyncConfigPacket> {
        @Override
        public IMessage handleClientMessage(EntityPlayer player, SyncConfigPacket message, MessageContext ctx) {
            VampirismMod.log.d("SyncConfigPacket", "Received config packet", new Object[0]);
            message.applyConfig();
            return null;
        }

        @Override
        protected boolean handleOnMainThread() {
            return true;
        }
    }
}

