/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.player;

import de.teamlapen.lib.HelperLib;
import de.teamlapen.lib.lib.entity.IPlayerEventListener;
import de.teamlapen.lib.lib.network.ISyncable;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.minions.IMinionLord;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;

public abstract class VampirismPlayer<T extends IFactionPlayer>
implements IFactionPlayer<T>,
ISyncable.ISyncableEntityCapabilityInst,
IPlayerEventListener,
IMinionLord {
    private static final String TAG = "VampirismPlayer";
    protected final EntityPlayer player;

    public VampirismPlayer(EntityPlayer player) {
        this.player = player;
    }

    @Override
    public long getLastComebackCall() {
        return 0L;
    }

    @Override
    public int getLevel() {
        return VampirismAPI.getFactionPlayerHandler(this.player).getCurrentLevel(this.getFaction());
    }

    @Override
    public int getMaxMinionCount() {
        return 0;
    }

    @Override
    public EntityLivingBase getMinionTarget() {
        return null;
    }

    @Override
    public EntityLivingBase getRepresentingEntity() {
        return this.player;
    }

    @Override
    public EntityPlayer getRepresentingPlayer() {
        return this.player;
    }

    @Override
    public double getTheDistanceSquared(Entity e) {
        if (e == null) {
            return Double.MAX_VALUE;
        }
        return this.player.func_70068_e(e);
    }

    @Override
    public int getTheEntityID() {
        return this.player.func_145782_y();
    }

    @Override
    public UUID getThePersistentID() {
        return this.player.func_110124_au();
    }

    @Override
    public boolean isRemote() {
        if (this.player.func_130014_f_() == null) {
            VampirismMod.log.e(TAG, new Throwable("World not loaded").fillInStackTrace(), "Trying to check if remote, but world is not set yet", new Object[0]);
            return false;
        }
        return this.player.func_130014_f_().field_72995_K;
    }

    @Override
    public boolean isTheEntityAlive() {
        return this.player.func_70089_S();
    }

    @Override
    public final void loadUpdateFromNBT(NBTTagCompound nbt) {
        this.loadUpdate(nbt);
    }

    @Override
    public void onPlayerClone(EntityPlayer original, boolean wasDeath) {
        this.copyFrom(original);
    }

    public void sync(boolean all) {
        HelperLib.sync(this, (Entity)this.player, all);
    }

    @Override
    public final void writeFullUpdateToNBT(NBTTagCompound nbt) {
        this.writeFullUpdate(nbt);
    }

    protected abstract VampirismPlayer copyFromPlayer(EntityPlayer var1);

    protected void loadUpdate(NBTTagCompound nbt) {
    }

    protected void sync(NBTTagCompound data, boolean all) {
        HelperLib.sync(this, data, (Entity)this.player, all);
    }

    protected void writeFullUpdate(NBTTagCompound nbt) {
    }

    private void copyFrom(EntityPlayer old) {
        VampirismPlayer p = this.copyFromPlayer(old);
    }
}

