/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.player.actions;

import com.google.common.collect.ImmutableBiMap;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.entity.player.actions.IAction;
import de.teamlapen.vampirism.api.entity.player.actions.IActionHandler;
import de.teamlapen.vampirism.api.entity.player.actions.ILastingAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class ActionHandler<T extends IFactionPlayer>
implements IActionHandler<T> {
    private static final String TAG = "ActionHandler";
    private final int[] actionTimer;
    private final T player;
    private final ImmutableBiMap<Integer, IAction<T>> actionIdMap;
    private final List<IAction<T>> unlockedActions = new ArrayList<IAction<T>>();
    private boolean dirty = false;

    public ActionHandler(T player) {
        this.player = player;
        ImmutableBiMap actionMap = VampirismAPI.actionRegistry().getActionMapForFaction(player.getFaction());
        ImmutableBiMap.Builder idBuilder = ImmutableBiMap.builder();
        int i = 0;
        for (IAction action : actionMap.values()) {
            idBuilder.put((Object)i++, (Object)action);
        }
        this.actionIdMap = idBuilder.build();
        this.actionTimer = new int[actionMap.size()];
    }

    @Override
    public void deactivateAllActions() {
        for (int i = 0; i < this.actionTimer.length; ++i) {
            if (this.actionTimer[i] <= 0) continue;
            this.actionTimer[i] = -this.getActionFromId(i).getCooldown();
            ((ILastingAction)this.getActionFromId(i)).onDeactivated(this.player);
        }
    }

    public IAction<T> getActionFromId(int id) {
        return (IAction)this.actionIdMap.get((Object)id);
    }

    @Override
    public List<IAction<T>> getAvailableActions() {
        ArrayList<IAction<T>> actions = new ArrayList<IAction<T>>();
        for (IAction<T> action : this.unlockedActions) {
            if (action.canUse(this.player) != IAction.PERM.ALLOWED) continue;
            actions.add(action);
        }
        return actions;
    }

    public int getIdFromAction(IAction action) {
        Integer i = (Integer)this.actionIdMap.inverse().get((Object)action);
        if (i == null) {
            throw new ActionNotRegisteredException(action);
        }
        return i;
    }

    @Override
    public float getPercentageForAction(IAction action) {
        Integer id = this.getIdFromAction(action);
        int i = this.actionTimer[id];
        if (i == 0) {
            return 0.0f;
        }
        if (i > 0) {
            return (float)i / (float)((ILastingAction)action).getDuration(this.player.getLevel());
        }
        return (float)i / (float)action.getCooldown();
    }

    @Override
    public boolean isActionActive(ILastingAction action) {
        return this.actionTimer[this.getIdFromAction(action)] > 0;
    }

    @Override
    public boolean isActionActive(String id) {
        IAction skill = VampirismAPI.actionRegistry().getActionFromKey(this.player.getFaction(), id);
        if (skill != null) {
            return this.isActionActive((ILastingAction)skill);
        }
        VampirismMod.log.w(TAG, "Skill with id %s is not registered", new Object[0]);
        return false;
    }

    @Override
    public boolean isActionUnlocked(IAction action) {
        return this.unlockedActions.contains(action);
    }

    public void loadFromNbt(NBTTagCompound nbt) {
        NBTTagCompound actions = nbt.func_74775_l("actions");
        if (actions != null) {
            for (String key : actions.func_150296_c()) {
                IAction action = VampirismAPI.actionRegistry().getActionFromKey(this.player.getFaction(), key);
                if (action == null) {
                    VampirismMod.log.w(TAG, "Did not find action with key %s", key);
                    continue;
                }
                this.actionTimer[this.getIdFromAction((IAction)action)] = actions.func_74762_e(key);
            }
        }
    }

    public void onActionsReactivated() {
        if (!this.player.isRemote()) {
            for (int i = 0; i < this.actionTimer.length; ++i) {
                if (this.actionTimer[i] <= 0) continue;
                ((ILastingAction)this.getActionFromId(i)).onReActivated(this.player);
            }
        }
    }

    public void readUpdateFromServer(NBTTagCompound nbt) {
        if (nbt.func_74764_b("action_timers")) {
            int[] updated = nbt.func_74759_k("action_timers");
            for (int i = 0; i < this.actionTimer.length; ++i) {
                int old = this.actionTimer[i];
                this.actionTimer[i] = updated[i];
                if (updated[i] > 0 && old <= 0) {
                    ((ILastingAction)this.getActionFromId(i)).onActivatedClient(this.player);
                    continue;
                }
                if (updated[i] > 0 || old <= 0) continue;
                ((ILastingAction)this.getActionFromId(i)).onDeactivated(this.player);
            }
        }
    }

    @Override
    public void resetTimers() {
        for (int i = 0; i < this.actionTimer.length; ++i) {
            if (this.actionTimer[i] > 0) {
                ((ILastingAction)this.getActionFromId(i)).onDeactivated(this.player);
            }
            this.actionTimer[i] = 0;
        }
        this.dirty = true;
    }

    public void saveToNbt(NBTTagCompound nbt) {
        NBTTagCompound actions = new NBTTagCompound();
        for (int i = 0; i < this.actionTimer.length; ++i) {
            IAction<T> a = this.getActionFromId(i);
            String key = VampirismAPI.actionRegistry().getKeyFromAction(a);
            actions.func_74768_a(key, this.actionTimer[i]);
        }
        nbt.func_74782_a("actions", (NBTBase)actions);
    }

    @Override
    public IAction.PERM toggleAction(IAction action) {
        int id = this.getIdFromAction(action);
        int t = this.actionTimer[id];
        if (t > 0) {
            this.actionTimer[id] = Math.min(-action.getCooldown() + t, 0);
            ((ILastingAction)action).onDeactivated(this.player);
            this.dirty = true;
            return IAction.PERM.ALLOWED;
        }
        if (t == 0) {
            if (!this.isActionUnlocked(action)) {
                return IAction.PERM.NOT_UNLOCKED;
            }
            IAction.PERM r = action.canUse(this.player);
            if (r == IAction.PERM.ALLOWED) {
                if (action.onActivated(this.player)) {
                    this.actionTimer[id] = action instanceof ILastingAction ? ((ILastingAction)action).getDuration(this.player.getLevel()) : -action.getCooldown();
                    this.dirty = true;
                }
                return IAction.PERM.ALLOWED;
            }
            return r;
        }
        return IAction.PERM.COOLDOWN;
    }

    @Override
    public void unlockActions(Collection<IAction<T>> actions) {
        this.unlockedActions.addAll(actions);
    }

    @Override
    public void ununlockActions(Collection<IAction<T>> actions) {
        this.unlockedActions.removeAll(actions);
        for (IAction<T> action : actions) {
            if (!(action instanceof ILastingAction) || !this.isActionActive((ILastingAction)action)) continue;
            this.toggleAction(action);
        }
    }

    public boolean updateActions() {
        for (int i = 0; i < this.actionTimer.length; ++i) {
            int t = this.actionTimer[i];
            if (t == 0) continue;
            if (t < 0) {
                int n = i;
                this.actionTimer[n] = this.actionTimer[n] + 1;
                continue;
            }
            int n = i;
            this.actionTimer[n] = this.actionTimer[n] - 1;
            ILastingAction skill = (ILastingAction)this.getActionFromId(i);
            if (t == 1) {
                skill.onDeactivated(this.player);
                this.actionTimer[i] = -skill.getCooldown();
                this.dirty = true;
                continue;
            }
            if (!skill.onUpdate(this.player)) continue;
            this.actionTimer[i] = 1;
        }
        if (this.dirty) {
            this.dirty = false;
            return true;
        }
        return false;
    }

    public void writeUpdateForClient(NBTTagCompound nbt) {
        nbt.func_74783_a("action_timers", this.actionTimer);
    }

    public static class ActionNotRegisteredException
    extends RuntimeException {
        public ActionNotRegisteredException(String name) {
            super("Action " + name + " is not registered. You cannot use it otherwise");
        }

        public ActionNotRegisteredException(IAction action) {
            this(action.toString());
        }
    }
}

