/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.player.actions;

import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableBiMap;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.api.entity.player.actions.IAction;
import de.teamlapen.vampirism.api.entity.player.actions.IActionPlayer;
import de.teamlapen.vampirism.api.entity.player.actions.IActionRegistry;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.util.StringUtils;

public class ActionRegistry
implements IActionRegistry {
    private final Map<IPlayableFaction, ImmutableBiMap<String, IAction>> actionMap = new HashMap<IPlayableFaction, ImmutableBiMap<String, IAction>>();
    private Map<IPlayableFaction, ImmutableBiMap.Builder<String, IAction>> actionBuilder = new HashMap<IPlayableFaction, ImmutableBiMap.Builder<String, IAction>>();

    public void finish() {
        if (this.actionBuilder == null) {
            throw new IllegalArgumentException("Action registry was already finished");
        }
        for (IPlayableFaction faction : VampirismAPI.factionRegistry().getPlayableFactions()) {
            if (this.actionBuilder.containsKey(faction)) {
                this.actionMap.put(faction, (ImmutableBiMap<String, IAction>)this.actionBuilder.get(faction).build());
                continue;
            }
            this.actionMap.put(faction, (ImmutableBiMap<String, IAction>)ImmutableBiMap.copyOf((Map)HashBiMap.create()));
        }
        this.actionBuilder = null;
    }

    @Override
    public int getActionCount(IPlayableFaction faction) {
        return this.actionMap.get(faction).size();
    }

    @Override
    public IAction getActionFromKey(IPlayableFaction faction, String key) {
        return (IAction)this.actionMap.get(faction).get((Object)key);
    }

    public ImmutableBiMap<String, IAction> getActionMapForFaction(IPlayableFaction faction) {
        ImmutableBiMap<String, IAction> map = this.actionMap.get(faction);
        if (map == null) {
            VampirismMod.log.w("ActionRegistry", "Gathering action map before post init has finished", new Object[0]);
            return ImmutableBiMap.copyOf((Map)HashBiMap.create());
        }
        return map;
    }

    @Override
    public String getKeyFromAction(IAction action) {
        IPlayableFaction<IActionPlayer> faction = action.getFaction();
        return (String)this.actionMap.get(faction).inverse().get((Object)action);
    }

    @Override
    public <T extends IAction> T registerAction(T action, String key) {
        if (action == null || StringUtils.func_151246_b((String)key)) {
            throw new IllegalArgumentException(String.format("Tried to either register a null action (%s) or with a null key (%s)", action, key));
        }
        IPlayableFaction<IActionPlayer> faction = action.getFaction();
        if (!this.actionBuilder.containsKey(faction)) {
            this.actionBuilder.put(faction, (ImmutableBiMap.Builder<String, IAction>)ImmutableBiMap.builder());
        }
        this.actionBuilder.get(faction).put((Object)key, action);
        return action;
    }
}

