/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.player.hunter;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.api.entity.player.actions.IActionHandler;
import de.teamlapen.vampirism.api.entity.player.hunter.IHunterPlayer;
import de.teamlapen.vampirism.api.entity.player.skills.ISkillHandler;
import de.teamlapen.vampirism.config.Balance;
import de.teamlapen.vampirism.core.Achievements;
import de.teamlapen.vampirism.core.ModPotions;
import de.teamlapen.vampirism.items.ItemObsidianArmor;
import de.teamlapen.vampirism.player.LevelAttributeModifier;
import de.teamlapen.vampirism.player.VampirismPlayer;
import de.teamlapen.vampirism.player.actions.ActionHandler;
import de.teamlapen.vampirism.player.hunter.HunterPlayerDefaultImpl;
import de.teamlapen.vampirism.player.hunter.HunterPlayerSpecialAttribute;
import de.teamlapen.vampirism.player.skills.SkillHandler;
import de.teamlapen.vampirism.util.REFERENCE;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatBase;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class HunterPlayer
extends VampirismPlayer<IHunterPlayer>
implements IHunterPlayer {
    @CapabilityInject(value=IHunterPlayer.class)
    public static final Capability<IHunterPlayer> CAP = null;
    private final ActionHandler<IHunterPlayer> actionHandler = new ActionHandler<HunterPlayer>(this);
    private final SkillHandler<IHunterPlayer> skillHandler = new SkillHandler<HunterPlayer>(this);
    private final HunterPlayerSpecialAttribute specialAttributes = new HunterPlayerSpecialAttribute();

    public static HunterPlayer get(EntityPlayer player) {
        return (HunterPlayer)player.getCapability(CAP, null);
    }

    public static void registerCapability() {
        CapabilityManager.INSTANCE.register(IHunterPlayer.class, (Capability.IStorage)new Storage(), HunterPlayerDefaultImpl.class);
    }

    public static ICapabilityProvider createNewCapability(final EntityPlayer player) {
        return new ICapabilitySerializable<NBTTagCompound>(){
            IHunterPlayer inst;
            {
                this.inst = new HunterPlayer(player);
            }

            public void deserializeNBT(NBTTagCompound nbt) {
                CAP.getStorage().readNBT(CAP, (Object)this.inst, null, (NBTBase)nbt);
            }

            public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
                return (T)(capability == CAP ? CAP.cast((Object)this.inst) : null);
            }

            public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
                return CAP.equals(capability);
            }

            public NBTTagCompound serializeNBT() {
                return (NBTTagCompound)CAP.getStorage().writeNBT(CAP, (Object)this.inst, null);
            }
        };
    }

    public HunterPlayer(EntityPlayer player) {
        super(player);
    }

    @Override
    public boolean canLeaveFaction() {
        return true;
    }

    @Override
    public IActionHandler<IHunterPlayer> getActionHandler() {
        return this.actionHandler;
    }

    @Override
    public ResourceLocation getCapKey() {
        return REFERENCE.HUNTER_PLAYER_KEY;
    }

    @Override
    public IFaction getDisguisedAs() {
        return this.player.func_70644_a(ModPotions.disguiseAsVampire) ? VReference.VAMPIRE_FACTION : this.getFaction();
    }

    @Override
    public IPlayableFaction<IHunterPlayer> getFaction() {
        return VReference.HUNTER_FACTION;
    }

    @Override
    public int getMaxLevel() {
        return 14;
    }

    @Override
    public Predicate<? super Entity> getNonFriendlySelector(boolean otherFactionPlayers, boolean ignoreDisguise) {
        if (otherFactionPlayers) {
            return Predicates.alwaysTrue();
        }
        return VampirismAPI.factionRegistry().getPredicate(this.getFaction(), ignoreDisguise);
    }

    @Override
    public ISkillHandler<IHunterPlayer> getSkillHandler() {
        return this.skillHandler;
    }

    public HunterPlayerSpecialAttribute getSpecialAttributes() {
        return this.specialAttributes;
    }

    @Override
    public int getTheEntityID() {
        return this.player.func_145782_y();
    }

    @Override
    public boolean isDisguised() {
        return this.player.func_70644_a(ModPotions.disguiseAsVampire);
    }

    public void loadData(NBTTagCompound compound) {
        this.actionHandler.loadFromNbt(compound);
        this.skillHandler.loadFromNbt(compound);
    }

    @Override
    public void onChangedDimension(int from, int to) {
    }

    @Override
    public void onDeath(DamageSource src) {
        this.actionHandler.deactivateAllActions();
    }

    @Override
    public boolean onEntityAttacked(DamageSource src, float amt) {
        return (DamageSource.field_76370_b.equals(src) || DamageSource.field_76372_a.equals(src)) && ItemObsidianArmor.isFullyEquipped(this.player);
    }

    @Override
    public void onJoinWorld() {
        if (this.getLevel() > 0) {
            this.actionHandler.onActionsReactivated();
        }
    }

    @Override
    public void onLevelChanged(int level, int oldLevel) {
        if (!this.isRemote()) {
            LevelAttributeModifier.applyModifier(this.player, SharedMonsterAttributes.field_111264_e, "Hunter", this.getLevel(), Balance.hp.STRENGTH_LCAP, Balance.hp.STRENGTH_MAX_MOD, Balance.hp.STRENGTH_TYPE, 2, false);
            if (level > 0) {
                if (this.player instanceof EntityPlayerMP && ((EntityPlayerMP)this.player).field_71135_a != null) {
                    this.player.func_71064_a((StatBase)Achievements.becomingAHunter, 1);
                }
                if (oldLevel == 0) {
                    this.skillHandler.enableRootSkill();
                }
            } else {
                this.skillHandler.disableAllSkills();
                this.actionHandler.resetTimers();
            }
        } else if (level == 0) {
            this.actionHandler.resetTimers();
        }
    }

    @Override
    public void onPlayerLoggedIn() {
    }

    @Override
    public void onPlayerLoggedOut() {
    }

    @Override
    public void onUpdate() {
        this.player.func_130014_f_().field_72984_F.func_76320_a("vampirism_hunterPlayer");
        int level = this.getLevel();
        if (!this.isRemote()) {
            if (level > 0) {
                boolean sync = false;
                boolean syncToAll = false;
                NBTTagCompound syncPacket = new NBTTagCompound();
                if (this.actionHandler.updateActions()) {
                    sync = true;
                    syncToAll = true;
                    this.actionHandler.writeUpdateForClient(syncPacket);
                }
                if (this.skillHandler.isDirty()) {
                    sync = true;
                    this.skillHandler.writeUpdateForClient(syncPacket);
                }
                if (sync) {
                    this.sync(syncPacket, syncToAll);
                }
            }
        } else if (level > 0) {
            this.actionHandler.updateActions();
        }
        this.player.func_130014_f_().field_72984_F.func_76319_b();
    }

    @Override
    public void onUpdatePlayer(TickEvent.Phase phase) {
    }

    public void saveData(NBTTagCompound compound) {
        this.actionHandler.saveToNbt(compound);
        this.skillHandler.saveToNbt(compound);
    }

    @Override
    protected VampirismPlayer copyFromPlayer(EntityPlayer old) {
        HunterPlayer oldHunter = HunterPlayer.get(old);
        NBTTagCompound nbt = new NBTTagCompound();
        oldHunter.saveData(nbt);
        this.loadData(nbt);
        return oldHunter;
    }

    @Override
    protected void loadUpdate(NBTTagCompound nbt) {
        this.actionHandler.readUpdateFromServer(nbt);
        this.skillHandler.readUpdateFromServer(nbt);
    }

    @Override
    protected void writeFullUpdate(NBTTagCompound nbt) {
        this.actionHandler.writeUpdateForClient(nbt);
        this.skillHandler.writeUpdateForClient(nbt);
    }

    private static class Storage
    implements Capability.IStorage<IHunterPlayer> {
        private Storage() {
        }

        public void readNBT(Capability<IHunterPlayer> capability, IHunterPlayer instance, EnumFacing side, NBTBase nbt) {
            ((HunterPlayer)instance).loadData((NBTTagCompound)nbt);
        }

        public NBTBase writeNBT(Capability<IHunterPlayer> capability, IHunterPlayer instance, EnumFacing side) {
            NBTTagCompound nbt = new NBTTagCompound();
            ((HunterPlayer)instance).saveData(nbt);
            return nbt;
        }
    }
}

