/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.player.vampire;

import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.config.Balance;
import de.teamlapen.vampirism.player.vampire.VampirePlayer;
import java.lang.reflect.Field;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.FoodStats;
import net.minecraft.world.EnumDifficulty;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BloodStats {
    public static final float LOW_SATURATION = 0.3f;
    public static final float MEDIUM_SATURATION = 0.7f;
    public static final float HIGH_SATURATION = 1.0f;
    private static final String TAG = "BloodStats";
    protected final int MAXBLOOD = 20;
    private final EntityPlayer player;
    private int bloodLevel = 20;
    private float bloodSaturationLevel = 5.0f;
    private float bloodExhaustionLevel;
    private int bloodTimer;
    private int prevBloodLevel = 20;
    private boolean changed = false;
    private Field field_foodExhaustionLevel = null;

    public BloodStats(EntityPlayer player) {
        this.player = player;
    }

    public int addBlood(int amount, float saturationModifier) {
        int add = Math.min(amount, 20 - this.bloodLevel);
        this.bloodLevel += add;
        this.bloodSaturationLevel = Math.min(this.bloodSaturationLevel + (float)add * saturationModifier * 2.0f, (float)this.bloodLevel);
        this.changed = true;
        return amount - add;
    }

    public boolean consumeBlood(int a) {
        int blood = this.getBloodLevel();
        int bloodToRemove = Math.min(a, blood);
        this.bloodLevel -= bloodToRemove;
        this.changed = true;
        return bloodToRemove <= blood;
    }

    public int getBloodLevel() {
        return this.bloodLevel;
    }

    public void setBloodLevel(int amt) {
        this.bloodLevel = amt < 0 ? 0 : (amt > 20 ? 20 : amt);
        this.changed = true;
    }

    @SideOnly(value=Side.CLIENT)
    public int getPrevBloodLevel() {
        return this.prevBloodLevel;
    }

    public boolean needsBlood() {
        return this.bloodLevel < 20;
    }

    public boolean onUpdate() {
        boolean regen;
        FoodStats foodStats = this.player.func_71024_bL();
        foodStats.func_75114_a(10);
        EnumDifficulty enumDifficulty = this.player.func_130014_f_().func_175659_aa();
        try {
            if (this.field_foodExhaustionLevel == null) {
                this.field_foodExhaustionLevel = ReflectionHelper.findField(FoodStats.class, (String[])new String[]{"foodExhaustionLevel", "field_75126_c"});
            }
            float exhaustion = ((Float)this.field_foodExhaustionLevel.get(foodStats)).floatValue();
            this.addExhaustion(exhaustion);
            this.field_foodExhaustionLevel.set(foodStats, 0);
        }
        catch (Exception e) {
            VampirismMod.log.e(TAG, e, "Failed to access foodExhaustionLevel (%s)", "field_75126_c");
            throw new RuntimeException(e);
        }
        this.prevBloodLevel = this.bloodLevel;
        if (this.bloodExhaustionLevel > 4.0f) {
            this.bloodExhaustionLevel -= 4.0f;
            if (this.bloodSaturationLevel > 0.0f) {
                this.bloodSaturationLevel = Math.max(this.bloodSaturationLevel - 1.0f, 0.0f);
            } else if (enumDifficulty != EnumDifficulty.PEACEFUL || Balance.vp.BLOOD_USAGE_PEACEFUL) {
                this.bloodLevel = Math.max(this.bloodLevel - 1, 0);
            }
        }
        if ((regen = this.player.func_130014_f_().func_82736_K().func_82766_b("naturalRegeneration")) && this.bloodSaturationLevel > 0.0f && this.player.func_70996_bM() && this.bloodLevel >= 20) {
            ++this.bloodTimer;
            if (this.bloodTimer >= 10) {
                float f = Math.min(this.bloodSaturationLevel, 4.0f);
                this.player.func_70691_i(f / 4.0f);
                this.addExhaustion(f, true);
                this.bloodTimer = 0;
            }
        } else if (regen && this.bloodLevel >= 18 && this.player.func_70996_bM()) {
            ++this.bloodTimer;
            if (this.bloodTimer >= 80) {
                this.player.func_70691_i(1.0f);
                this.addExhaustion(3.0f, true);
                this.bloodTimer = 0;
            }
        } else if (this.bloodLevel <= 0) {
            ++this.bloodTimer;
            if (this.bloodTimer >= 80) {
                if (this.player.func_110143_aJ() > 10.0f || enumDifficulty == EnumDifficulty.HARD || this.player.func_110143_aJ() > 1.0f && enumDifficulty == EnumDifficulty.NORMAL) {
                    this.player.func_70097_a(DamageSource.field_76366_f, 1.0f);
                }
                this.bloodTimer = 0;
            }
        } else {
            this.bloodTimer = 0;
        }
        if (this.changed || this.prevBloodLevel != this.bloodLevel) {
            this.changed = false;
            return true;
        }
        return false;
    }

    public void readNBT(NBTTagCompound nbt) {
        if (nbt.func_74764_b("bloodLevel")) {
            this.bloodLevel = nbt.func_74762_e("bloodLevel");
            if (nbt.func_74764_b("bloodTimer")) {
                this.bloodTimer = nbt.func_74762_e("bloodTimer");
                this.bloodSaturationLevel = nbt.func_74760_g("bloodSaturation");
                this.bloodExhaustionLevel = nbt.func_74760_g("bloodExhaustion");
            }
        }
    }

    public void writeNBT(NBTTagCompound nbt) {
        this.writeNBTBlood(nbt);
        nbt.func_74768_a("bloodTimer", this.bloodTimer);
        nbt.func_74776_a("bloodSaturation", this.bloodSaturationLevel);
        nbt.func_74776_a("bloodExhaustion", this.bloodExhaustionLevel);
    }

    public void writeNBTBlood(NBTTagCompound nbt) {
        nbt.func_74768_a("bloodLevel", this.bloodLevel);
    }

    protected void addExhaustion(float amount) {
        this.addExhaustion(amount, false);
    }

    protected void addExhaustion(float amount, boolean ignoreModifier) {
        float mult;
        VampirePlayer.get(this.player).checkAttributes(VReference.bloodExhaustion);
        IAttributeInstance attribute = this.player.func_110148_a(VReference.bloodExhaustion);
        if (ignoreModifier) {
            mult = 1.0f;
        } else if (attribute == null) {
            VampirismMod.log.w(TAG, "Blood exhaustion attribute is null for player %s (%s)", this.player, this.player == null ? null : this.player.func_110140_aT());
            mult = (float)VReference.bloodExhaustion.func_111110_b();
        } else {
            mult = (float)attribute.func_111126_e();
        }
        this.bloodExhaustionLevel = Math.min(this.bloodExhaustionLevel + amount * mult, 40.0f);
    }

    void loadUpdate(NBTTagCompound nbt) {
        if (nbt.func_74764_b("bloodLevel")) {
            this.setBloodLevel(nbt.func_74762_e("bloodLevel"));
        }
    }

    NBTTagCompound writeUpdate(NBTTagCompound nbt) {
        nbt.func_74768_a("bloodLevel", this.bloodLevel);
        return nbt;
    }
}

