/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.potion.blood;

import com.google.common.collect.Lists;
import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.hunter.IHunterMob;
import de.teamlapen.vampirism.api.entity.player.hunter.IHunterPlayer;
import de.teamlapen.vampirism.api.entity.player.skills.ISkillHandler;
import de.teamlapen.vampirism.api.items.IBloodPotionCategory;
import de.teamlapen.vampirism.api.items.IBloodPotionEffect;
import de.teamlapen.vampirism.api.items.IBloodPotionPropertyRandomizer;
import de.teamlapen.vampirism.api.items.IBloodPotionRegistry;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.core.ModPotions;
import de.teamlapen.vampirism.player.hunter.HunterPlayer;
import de.teamlapen.vampirism.player.hunter.skills.HunterSkills;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;

public class BloodPotions {
    public static void register() {
        IBloodPotionRegistry registry = VampirismAPI.bloodPotionRegistry();
        IBloodPotionCategory normalBodyBoost = registry.getOrCreateCategory("nbb", false, "text.vampirism.blood_potion.category.normal_body_boost");
        normalBodyBoost.addItems(Items.field_151034_e, Items.field_151083_be, Items.field_151157_am, Items.field_151168_bH, Items.field_151025_P);
        registry.registerPotionEffect("vampirism:speed", normalBodyBoost, false, MobEffects.field_76424_c, 30, new IBloodPotionPropertyRandomizer.SimpleRandomizer(600, 6000, 0));
        registry.registerPotionEffect("vampirism:jump", normalBodyBoost, false, MobEffects.field_76430_j, 25, new IBloodPotionPropertyRandomizer.SimpleRandomizer(500, 5000, 0));
        registry.registerPotionEffect("vampirism:health", normalBodyBoost, false, MobEffects.field_180152_w, 25, new IBloodPotionPropertyRandomizer.SimpleRandomizer(500, 5000, 0));
        registry.registerPotionEffect("vampirism:resistance", normalBodyBoost, false, MobEffects.field_76429_m, 30, new IBloodPotionPropertyRandomizer.SimpleRandomizer(600, 6000, 0));
        IBloodPotionCategory specialBodyBoost = registry.getOrCreateCategory("sbb", false, "text.vampirism.blood_potion.category.special_body_boost");
        specialBodyBoost.addItems(Items.field_151153_ao, Items.field_151150_bK);
        registry.registerPotionEffect("vampirism:specialSpeed", specialBodyBoost, false, MobEffects.field_76424_c, 15, new IBloodPotionPropertyRandomizer.SimpleRandomizer(500, 1500, 2));
        registry.registerPotionEffect("vampirism:specialJump", specialBodyBoost, false, MobEffects.field_76430_j, 10, new IBloodPotionPropertyRandomizer.SimpleRandomizer(400, 1000, 2));
        registry.registerPotionEffect("vampirism:specialHealth", specialBodyBoost, false, MobEffects.field_180152_w, 10, new IBloodPotionPropertyRandomizer.SimpleRandomizer(400, 1000, 2));
        registry.registerPotionEffect("vampirism:specialResistance", specialBodyBoost, false, MobEffects.field_76429_m, 15, new IBloodPotionPropertyRandomizer.SimpleRandomizer(500, 1500, 2));
        IBloodPotionCategory normalVampireSkills = registry.getOrCreateCategory("nvs", false, "text.vampirism.blood_potion.category.normal_vampire_skills");
        normalVampireSkills.addItems(new Object[]{ModItems.vampireFang, ModItems.bloodBottle, ModItems.itemCoffin});
        registry.registerPotionEffect("vampirism:nightVision", normalVampireSkills, false, MobEffects.field_76439_r, 20, new IBloodPotionPropertyRandomizer.SimpleRandomizer(600, 6000, 0));
        IBloodPotionCategory specialVampireSkills = registry.getOrCreateCategory("svs", false, "text.vampirism.blood_potion.category.special_vampire_skills");
        specialVampireSkills.addItems(new Object[]{ModItems.pureBlood});
        registry.registerPotionEffect("vampirism:disguise", specialVampireSkills, false, ModPotions.disguiseAsVampire, 5, new IBloodPotionPropertyRandomizer.SimpleRandomizer(500, 1500, 0));
        registry.registerPotionEffect("vampirism:specialNightVision", specialVampireSkills, false, MobEffects.field_76439_r, 20, new IBloodPotionPropertyRandomizer.SimpleRandomizer(1000, 24000, 0));
        IBloodPotionCategory specialOtherEffects = registry.getOrCreateCategory("so", false, "text.vampirism.blood_potion.category.special_other");
        specialOtherEffects.addItems(Items.field_151045_i);
        registry.registerPotionEffect("vampirism:invisibility", specialOtherEffects, false, MobEffects.field_76441_p, 10, new IBloodPotionPropertyRandomizer.SimpleRandomizer(600, 6000, 0));
        IBloodPotionCategory badOtherEffects = registry.getOrCreateCategory("o", true, "text.vampirism.blood_potion.category.bad_others");
        registry.registerPotionEffect("vampirism:weakness", badOtherEffects, true, MobEffects.field_76437_t, 30, new IBloodPotionPropertyRandomizer.SimpleRandomizer(600, 6000, 1));
        registry.registerPotionEffect("vampirism:shortNausea", badOtherEffects, true, MobEffects.field_76431_k, 20, new IBloodPotionPropertyRandomizer.SimpleRandomizer(300, 700, 0));
        registry.registerPotionEffect("vampirism:slowness", badOtherEffects, true, MobEffects.field_76421_d, 30, new IBloodPotionPropertyRandomizer.SimpleRandomizer(600, 5000, 0));
        registry.registerPotionEffect("vampirism:hunger", badOtherEffects, true, MobEffects.field_76438_s, 25, new IBloodPotionPropertyRandomizer.SimpleRandomizer(500, 5000, 0));
        registry.registerPotionEffect("vampirism:specialWeakness", badOtherEffects, true, MobEffects.field_76437_t, 15, new IBloodPotionPropertyRandomizer.SimpleRandomizer(600, 1500, 2));
        registry.registerPotionEffect("vampirism:specialSlowness", badOtherEffects, true, MobEffects.field_76421_d, 10, new IBloodPotionPropertyRandomizer.SimpleRandomizer(500, 1000, 2));
        registry.registerPotionEffect("vampirism:longNausea", badOtherEffects, true, MobEffects.field_76431_k, 2, new IBloodPotionPropertyRandomizer.SimpleRandomizer(500, 1000, 2));
    }

    public static void addTooltip(ItemStack stack, List<String> tooltip, IHunterPlayer player) {
        ISkillHandler skillHandler = player.getSkillHandler();
        ArrayList effects = stack.func_77942_o() ? BloodPotions.readEffectsFromNBT(stack.func_77978_p()) : Lists.newArrayList();
        Random identifyRandom = null;
        if (skillHandler.isSkillEnabled(HunterSkills.bloodPotion_identifySome)) {
            NBTTagCompound nbt = stack.func_77942_o() ? stack.func_77978_p() : new NBTTagCompound();
            int seed = nbt.func_74764_b("ident_seed") ? nbt.func_74762_e("ident_seed") : stack.hashCode();
            identifyRandom = new Random(seed);
        }
        for (ConfiguredEffect effect : effects) {
            String text = identifyRandom != null && identifyRandom.nextBoolean() ? effect.getEffect().getLocName(effect.properties) : UtilLib.translate("text.vampirism.unknown");
            if (skillHandler.isSkillEnabled(HunterSkills.bloodPotion_goodOrBad)) {
                text = effect.getEffect().isBad() ? TextFormatting.DARK_RED + text : TextFormatting.DARK_GREEN + text;
            }
            tooltip.add(text);
        }
    }

    public static void applyEffects(ItemStack stack, EntityLivingBase entity) {
        HunterPlayer hunterPlayer;
        if (!stack.func_77942_o()) {
            return;
        }
        List<ConfiguredEffect> effects = BloodPotions.readEffectsFromNBT(stack.func_77978_p());
        boolean flag = entity instanceof IHunterMob;
        float durationMult = 1.0f;
        if (!flag && entity instanceof EntityPlayer && (hunterPlayer = HunterPlayer.get((EntityPlayer)entity)).getLevel() > 0) {
            flag = true;
            if (hunterPlayer.getSkillHandler().isSkillEnabled(HunterSkills.bloodPotion_increaseDuration)) {
                durationMult = (float)((double)durationMult + 0.3);
            }
        }
        if (flag) {
            for (ConfiguredEffect effect : effects) {
                effect.getEffect().onActivated(entity, effect.getProperties(), durationMult);
            }
        }
    }

    @Nonnull
    private static List<ConfiguredEffect> readEffectsFromNBT(NBTTagCompound nbt) {
        ArrayList effects = Lists.newArrayList();
        NBTTagCompound effectsTag = nbt.func_74775_l("effects");
        for (String id : effectsTag.func_150296_c()) {
            NBTTagCompound properties = effectsTag.func_74775_l(id);
            IBloodPotionEffect effect = VampirismAPI.bloodPotionRegistry().getEffectFromId(id);
            if (effect == null) {
                VampirismMod.log.w("BloodPotions", "Cannot find effect with id %s", id);
                continue;
            }
            effects.add(new ConfiguredEffect(effect, properties));
        }
        return effects;
    }

    public static void chooseAndAddEffects(@Nonnull ItemStack stack, @Nonnull IHunterPlayer crafter, @Nullable ItemStack extraItem) {
        ArrayList effects = Lists.newArrayList();
        IBloodPotionRegistry registry = VampirismAPI.bloodPotionRegistry();
        Random rnd = crafter.getRepresentingPlayer().func_70681_au();
        ISkillHandler skillHandler = crafter.getSkillHandler();
        int good = rnd.nextInt(2) + 1;
        if (rnd.nextInt(10) == 0) {
            good = 3;
        }
        int badReductions = 0;
        if (skillHandler.isSkillEnabled(HunterSkills.bloodPotion_lessBad)) {
            ++badReductions;
        }
        if (skillHandler.isSkillEnabled(HunterSkills.bloodPotion_lessBad2)) {
            ++badReductions;
        }
        int bad = badReductions == 1 ? (rnd.nextInt(10) == 0 ? 2 : 1) : (badReductions == 2 ? rnd.nextInt(2) : (rnd.nextInt(10) == 0 ? 3 : rnd.nextInt(2) + 1));
        int extra = 0;
        for (int i = 0; i < good + bad + extra; ++i) {
            IBloodPotionEffect effect = registry.getRandomEffect(extraItem, i >= good + extra, rnd);
            boolean valid = true;
            for (ConfiguredEffect effect1 : effects) {
                if (effect1.getEffect().canCoexist(effect)) continue;
                extra = Math.min(extra + 1, 5);
                valid = false;
            }
            if (!valid) continue;
            effects.add(new ConfiguredEffect(effect, effect.getRandomProperties(rnd)));
        }
        BloodPotions.addEffects(stack, effects);
    }

    private static void addEffects(ItemStack stack, List<ConfiguredEffect> effects) {
        NBTTagCompound nbt = stack.func_77942_o() ? stack.func_77978_p() : new NBTTagCompound();
        NBTTagCompound effectTag = new NBTTagCompound();
        for (ConfiguredEffect effect : effects) {
            effectTag.func_74782_a(effect.getEffect().getId(), (NBTBase)effect.getProperties());
        }
        nbt.func_74782_a("effects", (NBTBase)effectTag);
        if (!nbt.func_74764_b("ident_seed")) {
            int seed = stack.hashCode();
            nbt.func_74768_a("ident_seed", seed);
        }
        stack.func_77982_d(nbt);
    }

    @Nonnull
    public static List<String> getLocalizedCategoryHint(ItemStack extra) {
        IBloodPotionRegistry registry = VampirismAPI.bloodPotionRegistry();
        return registry.getLocCategoryDescForItem(extra);
    }

    private static class ConfiguredEffect {
        private final IBloodPotionEffect effect;
        private final NBTTagCompound properties;

        private ConfiguredEffect(IBloodPotionEffect effect, NBTTagCompound properties) {
            this.effect = effect;
            this.properties = properties;
        }

        public IBloodPotionEffect getEffect() {
            return this.effect;
        }

        public NBTTagCompound getProperties() {
            return this.properties;
        }

        public String toString() {
            return "ConfEffect{effect=" + this.effect + ", properties=" + this.properties + '}';
        }
    }
}

