/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.util;

import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.EnumStrength;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.factions.IFactionPlayerHandler;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.api.entity.player.skills.ISkillHandler;
import de.teamlapen.vampirism.api.items.IFactionLevelItem;
import de.teamlapen.vampirism.config.Balance;
import de.teamlapen.vampirism.core.ModBiomes;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;

public class Helper {
    public static void spawnParticlesAroundEntity(EntityLivingBase e, EnumParticleTypes particle, double maxDistance, int amount) {
    }

    public static boolean gettingSundamge(EntityLivingBase entity) {
        float angle;
        entity.func_130014_f_().field_72984_F.func_76320_a("vampirism_checkSundamage");
        if (entity instanceof EntityPlayer && ((EntityPlayer)entity).func_175149_v()) {
            return false;
        }
        if (VampirismAPI.sundamageRegistry().getSundamageInDim(entity.func_130014_f_().field_73011_w.getDimension()) && !entity.func_130014_f_().func_72896_J() && ((double)(angle = entity.func_130014_f_().func_72826_c(1.0f)) > 0.78 || (double)angle < 0.24)) {
            BlockPos pos = new BlockPos(entity.field_70165_t, entity.field_70163_u + (double)MathHelper.func_76131_a((float)(entity.field_70131_O / 2.0f), (float)0.0f, (float)2.0f), entity.field_70161_v);
            if (Helper.canBlockSeeSun(entity.func_130014_f_(), pos)) {
                try {
                    Biome biome = entity.func_130014_f_().func_180494_b(pos);
                    if (VampirismAPI.sundamageRegistry().getSundamageInBiome(biome)) {
                        entity.func_130014_f_().field_72984_F.func_76319_b();
                        return true;
                    }
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
        }
        entity.func_130014_f_().field_72984_F.func_76319_b();
        return false;
    }

    public static boolean canBlockSeeSun(World world, BlockPos pos) {
        if (pos.func_177956_o() >= world.func_181545_F()) {
            return world.func_175678_i(pos);
        }
        BlockPos blockpos = new BlockPos(pos.func_177958_n(), world.func_181545_F(), pos.func_177952_p());
        if (!world.func_175678_i(blockpos)) {
            return false;
        }
        int liquidBlocks = 0;
        blockpos = blockpos.func_177977_b();
        while (blockpos.func_177956_o() > pos.func_177956_o()) {
            IBlockState iblockstate = world.func_180495_p(blockpos);
            if (iblockstate.func_177230_c().getLightOpacity(iblockstate, (IBlockAccess)world, blockpos) > 0) {
                if (iblockstate.func_185904_a().func_76224_d()) {
                    if (++liquidBlocks >= Balance.vp.SUNDAMAGE_WATER_BLOCKS) {
                        return false;
                    }
                } else {
                    return false;
                }
            }
            blockpos = blockpos.func_177977_b();
        }
        return true;
    }

    public static EnumStrength getGarlicStrength(Entity e) {
        return Helper.getGarlicStrengthAt(e.func_130014_f_(), e.func_180425_c());
    }

    public static EnumStrength getGarlicStrengthAt(World world, BlockPos pos) {
        return VampirismAPI.getGarlicChunkHandler(world).getStrengthAtChunk(new ChunkPos(pos));
    }

    public static boolean canBecomeVampire(EntityPlayer player) {
        return FactionPlayerHandler.get(player).canJoin(VReference.VAMPIRE_FACTION);
    }

    public static boolean isVampire(Entity entity) {
        return VReference.VAMPIRE_FACTION.equals(VampirismAPI.factionRegistry().getFaction(entity));
    }

    public static boolean isHunter(Entity entity) {
        return VReference.HUNTER_FACTION.equals(VampirismAPI.factionRegistry().getFaction(entity));
    }

    public static boolean areSkillsEnabled(ISkillHandler skillHandler, ISkill ... skills) {
        for (ISkill skill : skills) {
            if (skillHandler.isSkillEnabled(skill)) continue;
            return false;
        }
        return true;
    }

    public static boolean isEntityInVampireBiome(Entity e) {
        if (e == null) {
            return false;
        }
        try {
            return ModBiomes.vampireForest.getRegistryName().equals((Object)e.func_130014_f_().func_180494_b(e.func_180425_c()).getRegistryName());
        }
        catch (NullPointerException e1) {
            VampirismMod.log.e("Helper", e1, "Nullpointer when checking biome. This is strange and should not happen", new Object[0]);
            return false;
        }
    }

    public static boolean canUseFactionItem(ItemStack stack, IFactionLevelItem item, IFactionPlayerHandler playerHandler) {
        IPlayableFaction usingFaction = item.getUsingFaction(stack);
        ISkill requiredSkill = item.getRequiredSkill(stack);
        int reqLevel = item.getMinLevel(stack);
        if (usingFaction != null && !playerHandler.isInFaction(usingFaction)) {
            return false;
        }
        if (playerHandler.getCurrentLevel() < reqLevel) {
            return false;
        }
        return requiredSkill == null || playerHandler.getCurrentFactionPlayer() != null && playerHandler.getCurrentFactionPlayer().getSkillHandler().isSkillEnabled(requiredSkill);
    }
}

