/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.util;

import com.google.common.io.ByteStreams;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.core.ModItems;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;

public class VampireBookManager {
    private static final String TAG = "VampireBookManager";
    private static VampireBookManager ourInstance = new VampireBookManager();
    private NBTTagCompound[] bookTags = null;

    public static VampireBookManager getInstance() {
        return ourInstance;
    }

    private VampireBookManager() {
    }

    public void applyRandomBook(ItemStack stack, Random rnd) {
        NBTTagCompound nbt = this.bookTags == null || this.bookTags.length == 0 ? new NBTTagCompound() : this.bookTags[rnd.nextInt(this.bookTags.length)];
        stack.func_77982_d(nbt);
    }

    public ItemStack getRandomBook(Random rnd) {
        ItemStack book = new ItemStack((Item)ModItems.vampireBook, 1);
        this.applyRandomBook(book, rnd);
        return book;
    }

    public void init() {
        InputStream inputStream = null;
        try {
            inputStream = VampirismMod.class.getResourceAsStream("/vampireBooks.txt");
            if (inputStream == null) {
                throw new IOException("Could not find 'vampireBooks.txt' in resources");
            }
            String data = new String(ByteStreams.toByteArray((InputStream)inputStream));
            this.parseBooks(data);
        }
        catch (NBTException e) {
            VampirismMod.log.w(TAG, "----------------------------------------", new Object[0]);
            VampirismMod.log.e(TAG, e, "Failed to convert vampire books to NBT", new Object[0]);
            VampirismMod.log.w(TAG, "----------------------------------------", new Object[0]);
        }
        catch (IOException e) {
            VampirismMod.log.e(TAG, e, "Failed to read vampire books from resources", new Object[0]);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    VampirismMod.log.e(TAG, e, "Failed to close InputStream", new Object[0]);
                }
            }
        }
    }

    private void parseBooks(String data) throws NBTException {
        ArrayList<NBTTagCompound> books = new ArrayList<NBTTagCompound>();
        String[] lines = data.split("\n");
        for (int i = 0; i < lines.length; ++i) {
            NBTTagCompound nbt = JsonToNBT.func_180713_a((String)lines[i]);
            books.add(nbt);
        }
        this.bookTags = books.toArray(new NBTTagCompound[books.size()]);
    }
}

